/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectJabberImpl;
import net.java.sip.communicator.service.protocol.WhiteboardPoint;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectPath;
import net.java.sip.communicator.util.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WhiteboardObjectPathJabberImpl
extends WhiteboardObjectJabberImpl
implements WhiteboardObjectPath {
    private static final Logger logger = Logger.getLogger(WhiteboardObjectPathJabberImpl.class);
    private List<WhiteboardPoint> listPoints;

    public WhiteboardObjectPathJabberImpl() {
        this.listPoints = new LinkedList<WhiteboardPoint>();
    }

    public WhiteboardObjectPathJabberImpl(String xml) {
        block7: {
            this.listPoints = new LinkedList<WhiteboardPoint>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                Document doc = builder.parse(in);
                Element e = doc.getDocumentElement();
                String elementName = e.getNodeName();
                if (elementName.equals("path")) {
                    String id = e.getAttribute("id");
                    String d = e.getAttribute("d");
                    String stroke = e.getAttribute("stroke");
                    String stroke_width = e.getAttribute("stroke-width");
                    this.setID(id);
                    this.setThickness(Integer.parseInt(stroke_width));
                    this.setColor(Color.decode(stroke).getRGB());
                    this.setPoints(this.getPathPoints(d));
                }
            }
            catch (ParserConfigurationException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml));
                }
            }
            catch (IOException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml));
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)("Problem WhiteboardObject : " + xml));
            }
        }
    }

    public void setPoints(List<WhiteboardPoint> points) {
        this.listPoints = new LinkedList<WhiteboardPoint>(points);
    }

    public List<WhiteboardPoint> getPoints() {
        return this.listPoints;
    }

    private List<WhiteboardPoint> getPathPoints(String points) {
        LinkedList<WhiteboardPoint> list = new LinkedList<WhiteboardPoint>();
        if (points == null) {
            return list;
        }
        String patternStr = "[ML]\\S+ \\S+ ";
        Pattern pattern = Pattern.compile(patternStr);
        Matcher matcher = pattern.matcher(points);
        while (matcher.find()) {
            String[] coords = matcher.group(0).substring(1).split(" ");
            WhiteboardPoint point = new WhiteboardPoint(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]));
            list.add(point);
        }
        return list;
    }

    @Override
    public String toXML() {
        String s = "<path id=\"#i\" d=\"#p Z\" stroke=\"#s\" stroke-width=\"#w\"/>";
        s = s.replaceAll("#i", this.getID());
        s = s.replaceAll("#s", this.colorToHex(this.getColor()));
        s = s.replaceAll("#w", "" + this.getThickness());
        StringBuilder sb = new StringBuilder();
        int size = this.listPoints.size();
        for (int i = 0; i < size; ++i) {
            WhiteboardPoint point = this.listPoints.get(i);
            sb.append(i == 0 ? "M" : "L");
            sb.append(point.getX());
            sb.append(" ");
            sb.append(point.getY());
            sb.append(" ");
        }
        s = s.replaceAll("#p", sb.toString());
        return s;
    }
}

