/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.metrics;

import java.util.LinkedList;
import java.util.List;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.metrics.MetricServicePublisher;

public class MetricService {
    private static final Logger logger = Logger.getLogger(MetricService.class);
    private List<MetricServicePublisher> publishers = new LinkedList<MetricServicePublisher>();
    public static final String METRIC_CONFERENCES = "Conferences";
    public static final String METRIC_CHANNELS = "Channels";
    public static final String METRIC_CONFERENCELENGTH = "Conference length";
    public static final String METRIC_CHANNELSTART_POSTFIX = " start";

    public MetricService(ConfigurationService config) {
        List propNames = config.getPropertyNamesByPrefix("org.jitsi.videobridge.metricservice.", false);
        logger.info((Object)("Metric services enabled: " + (propNames == null ? "0" : Integer.valueOf(propNames.size()))));
        if (propNames != null) {
            for (String propName : propNames) {
                logger.info((Object)("Initialising metric service: " + propName));
                try {
                    String serviceClassName = config.getString(propName);
                    Class<?> serviceClass = Class.forName(serviceClassName);
                    MetricServicePublisher publisher = (MetricServicePublisher)serviceClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.publishers.add(publisher);
                }
                catch (Throwable t) {
                    logger.error((Object)"Error initialising metric service", t);
                }
            }
        }
    }

    public void publishNumericMetric(String metricName, int metricValue) {
        for (MetricServicePublisher publisher : this.publishers) {
            try {
                publisher.publishNumericMetric(metricName, metricValue);
            }
            catch (UnsupportedOperationException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(publisher.getName() + " publisher doesn't support numeric metric: " + metricName));
            }
            catch (Throwable t) {
                logger.error((Object)("Error publishing metric \"" + metricName + "\" with publisher: " + publisher.getName()), t);
            }
        }
    }

    public void publishStringMetric(String metricName, String metricValue) {
        for (MetricServicePublisher publisher : this.publishers) {
            try {
                publisher.publishStringMetric(metricName, metricValue);
            }
            catch (UnsupportedOperationException e) {
                logger.debug((Object)(publisher.getName() + " publisher doesn't support string metric: " + metricName));
            }
            catch (Throwable t) {
                logger.error((Object)("Error publishing metric \"" + metricName + "\" with publisher: " + publisher.getName()), t);
            }
        }
    }

    public void publishIncrementalMetric(String metricName) {
        for (MetricServicePublisher publisher : this.publishers) {
            try {
                publisher.publishIncrementalMetric(metricName);
            }
            catch (UnsupportedOperationException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(publisher.getName() + " publisher doesn't support incremental metric: " + metricName));
            }
            catch (Throwable t) {
                logger.error((Object)("Error publishing metric \"" + metricName + "\" with publisher: " + publisher.getName()), t);
            }
        }
    }

    public void publishIncrementalMetric(String metricName, int increment) {
        for (MetricServicePublisher publisher : this.publishers) {
            try {
                publisher.publishIncrementalMetric(metricName, increment);
            }
            catch (UnsupportedOperationException e) {
                logger.debug((Object)(publisher.getName() + " publisher doesn't support incremental metric: " + metricName));
            }
            catch (Throwable t) {
                logger.error((Object)("Error publishing metric \"" + metricName + "\" with publisher: " + publisher.getName()), t);
            }
        }
    }

    public void startMeasuredTransaction(String transactionType, String transactionId) {
        for (MetricServicePublisher publisher : this.publishers) {
            try {
                publisher.startMeasuredTransaction(transactionType, transactionId);
            }
            catch (UnsupportedOperationException e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(publisher.getName() + " publisher doesn't support measured transaction " + "metric: " + transactionType));
            }
            catch (Throwable t) {
                logger.error((Object)("Error publishing metric \"" + transactionType + "\" with publisher: " + publisher.getName()), t);
            }
        }
    }

    public void endMeasuredTransaction(String transactionType, String transactionId) {
        for (MetricServicePublisher publisher : this.publishers) {
            try {
                publisher.endMeasuredTransaction(transactionType, transactionId);
            }
            catch (UnsupportedOperationException e) {
                logger.debug((Object)(publisher.getName() + " publisher doesn't support measured transaction metric: " + transactionType));
            }
            catch (Throwable t) {
                logger.error((Object)("Error publishing metric \"" + transactionType + "\" with publisher: " + publisher.getName()), t);
            }
        }
    }
}

