/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.util.Vector;
import javax.media.protocol.DataSource;
import javax.media.rtp.LocalParticipant;
import javax.media.rtp.Participant;
import javax.media.rtp.RTPStream;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceptionStats;
import javax.media.rtp.rtcp.Feedback;
import javax.media.rtp.rtcp.Report;
import javax.media.rtp.rtcp.SenderReport;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;

public class RecvSSRCInfo
extends SSRCInfo
implements ReceiveStream,
SenderReport {
    RecvSSRCInfo(SSRCCache cache, int ssrc) {
        super(cache, ssrc);
    }

    RecvSSRCInfo(SSRCInfo info) {
        super(info);
    }

    public DataSource getDataSource() {
        return this.dsource;
    }

    public long getNTPTimeStampLSW() {
        return this.lastSRntptimestamp & 0xFFFFFFFFL;
    }

    public long getNTPTimeStampMSW() {
        return this.lastSRntptimestamp >> 32 & 0xFFFFFFFFL;
    }

    public Participant getParticipant() {
        SSRCCache cache = this.getSSRCCache();
        if (this.sourceInfo instanceof LocalParticipant && cache.sm.IsNonParticipating()) {
            return null;
        }
        return this.sourceInfo;
    }

    public long getRTPTimeStamp() {
        return this.lastSRrtptimestamp;
    }

    public long getSenderByteCount() {
        return this.lastSRoctetcount;
    }

    public Feedback getSenderFeedback() {
        SSRCCache cache = this.getSSRCCache();
        Report report = null;
        Vector reports = null;
        Vector feedback = null;
        Feedback reportblk = null;
        try {
            LocalParticipant localpartc = cache.sm.getLocalParticipant();
            reports = localpartc.getReports();
            for (int i = 0; i < reports.size(); ++i) {
                report = (Report)reports.elementAt(i);
                feedback = report.getFeedbackReports();
                for (int j = 0; j < feedback.size(); ++j) {
                    reportblk = (Feedback)feedback.elementAt(j);
                    long ssrc = reportblk.getSSRC();
                    if (ssrc != this.getSSRC()) continue;
                    return reportblk;
                }
            }
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public long getSenderPacketCount() {
        return this.lastSRpacketcount;
    }

    public SenderReport getSenderReport() {
        return this;
    }

    public ReceptionStats getSourceReceptionStats() {
        return this.stats;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public RTPStream getStream() {
        return this;
    }

    public int getRoundTripDelay(int sourceSSRC) {
        long l;
        Feedback feedback = null;
        for (Feedback feedback2 : this.getFeedbackReports()) {
            if (sourceSSRC != (int)feedback2.getSSRC()) continue;
            feedback = feedback2;
            break;
        }
        int roundTripDelay = 0;
        if (feedback != null && (l = this.lastRTCPreceiptTime) != 0L) {
            long lsr = feedback.getLSR();
            long dlsr = feedback.getDLSR();
            roundTripDelay = RecvSSRCInfo.getRoundTripDelay(l, lsr, dlsr);
        }
        return roundTripDelay;
    }

    public static int getRoundTripDelay(long systime, long lsr, long dlsr) {
        int roundTripDelay = 0;
        if (lsr > 0L) {
            long secs = systime / 1000L;
            double msecs = (double)(systime - secs * 1000L) / 1000.0;
            long lsw = (int)(msecs * 4.294967296E9);
            long msw = secs;
            long ntptime = (msw << 32) + lsw;
            long ntprtd = (ntptime = (ntptime & 0xFFFFFFFF0000L) >> 16) - lsr - dlsr;
            if (ntprtd > 0L) {
                roundTripDelay = ntprtd > 4294967L ? 65536 : (int)(ntprtd * 1000L >> 16);
            }
        }
        return roundTripDelay;
    }
}

