/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import org.ice4j.socket.DelegatingDatagramSocket;

public class SafeCloseDatagramSocket
extends DelegatingDatagramSocket {
    private int inReceive = 0;
    private final Object inReceiveSyncRoot = new Object();

    public SafeCloseDatagramSocket() throws SocketException {
    }

    public SafeCloseDatagramSocket(DatagramSocket delegate) throws SocketException {
        super(delegate);
    }

    public SafeCloseDatagramSocket(int port) throws SocketException {
        super(port);
    }

    public SafeCloseDatagramSocket(int port, InetAddress laddr) throws SocketException {
        super(port, laddr);
    }

    public SafeCloseDatagramSocket(SocketAddress bindaddr) throws SocketException {
        super(bindaddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        if (this.inReceiveSyncRoot == null) {
            return;
        }
        Object object = this.inReceiveSyncRoot;
        synchronized (object) {
            boolean interrupted = false;
            while (this.inReceive > 0) {
                try {
                    this.inReceiveSyncRoot.wait();
                }
                catch (InterruptedException iex) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(DatagramPacket p) throws IOException {
        Object object = this.inReceiveSyncRoot;
        synchronized (object) {
            ++this.inReceive;
        }
        try {
            super.receive(p);
        }
        finally {
            object = this.inReceiveSyncRoot;
            synchronized (object) {
                --this.inReceive;
                this.inReceiveSyncRoot.notifyAll();
            }
        }
    }
}

