/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.ssi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.MiscTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.SnacPacketEvent;
import net.kano.joscar.snac.SnacRequestListener;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snac.SnacResponseListener;
import net.kano.joscar.snaccmd.conn.SnacFamilyInfo;
import net.kano.joscar.snaccmd.ssi.ActivateSsiCmd;
import net.kano.joscar.snaccmd.ssi.AuthFutureCmd;
import net.kano.joscar.snaccmd.ssi.AuthReplyCmd;
import net.kano.joscar.snaccmd.ssi.BuddyAddedYouCmd;
import net.kano.joscar.snaccmd.ssi.BuddyAuthRequest;
import net.kano.joscar.snaccmd.ssi.CreateItemsCmd;
import net.kano.joscar.snaccmd.ssi.DeleteItemsCmd;
import net.kano.joscar.snaccmd.ssi.ItemsCmd;
import net.kano.joscar.snaccmd.ssi.ModifyItemsCmd;
import net.kano.joscar.snaccmd.ssi.SsiCommand;
import net.kano.joscar.snaccmd.ssi.SsiDataCmd;
import net.kano.joscar.snaccmd.ssi.SsiDataModResponse;
import net.kano.joscar.snaccmd.ssi.SsiDataRequest;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.snaccmd.ssi.SsiRightsRequest;
import net.kano.joscar.ssiitem.BuddyItem;
import net.kano.joscar.ssiitem.DefaultSsiItemObjFactory;
import net.kano.joscar.ssiitem.GroupItem;
import net.kano.joscar.ssiitem.RootItem;
import net.kano.joscar.ssiitem.SsiItemObj;
import net.kano.joustsim.JavaTools;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.oscar.OscarConnection;
import net.kano.joustsim.oscar.oscar.service.AbstractService;
import net.kano.joustsim.oscar.oscar.service.ServiceEvent;
import net.kano.joustsim.oscar.oscar.service.bos.ServerReadyEvent;
import net.kano.joustsim.oscar.oscar.service.ssi.BuddyAuthorizationListener;
import net.kano.joustsim.oscar.oscar.service.ssi.MutableBuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.MyBuddyIconItemManager;
import net.kano.joustsim.oscar.oscar.service.ssi.PermissionList;
import net.kano.joustsim.oscar.oscar.service.ssi.ServerStoredSettings;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiBuddyList;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiItemChangeListener;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiPermissionList;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiServerStoredSettings;
import net.kano.joustsim.oscar.oscar.service.ssi.SsiService;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SsiServiceImpl
extends AbstractService
implements SsiService {
    private static final Logger LOGGER = Logger.getLogger(SsiServiceImpl.class.getName());
    private static final int NUM_IDS = 32768;
    private final Map<Integer, Collection<Integer>> prospectiveIds = new HashMap<Integer, Collection<Integer>>();
    private final Collection<Integer> prospectiveGroupIds = new ArrayList<Integer>();
    private final CopyOnWriteArrayList<SsiItemChangeListener> listeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<BuddyAuthorizationListener> buddyAuthorizationListeners = new CopyOnWriteArrayList();
    private final Map<ItemId, SsiItem> items = new HashMap<ItemId, SsiItem>();
    private final SsiBuddyList buddyList = new SsiBuddyList(this);
    private final SsiPermissionList permissionList = new SsiPermissionList(this);
    private final SsiServerStoredSettings settings = new SsiServerStoredSettings(this);
    private final MyBuddyIconItemManager buddyIconItemManager = new MyBuddyIconItemManager(this);
    private final Random random = new Random();
    private boolean requestedList = false;

    public SsiServiceImpl(AimConnection aimConnection, OscarConnection oscarConnection) {
        super(aimConnection, oscarConnection, 19);
    }

    @Override
    public SnacFamilyInfo getSnacFamilyInfo() {
        return SsiCommand.FAMILY_INFO;
    }

    @Override
    public void connected() {
        OscarConnection conn = this.getOscarConnection();
        ClientSnacProcessor snacProcessor = conn.getSnacProcessor();
        snacProcessor.addGlobalResponseListener((SnacResponseListener)new ItemsChangeListener());
        boolean serverReady = conn.hasServiceEvents(ServerReadyEvent.class);
        if (serverReady) {
            this.requestList();
        }
    }

    @Override
    public void handleEvent(ServiceEvent event) {
        super.handleEvent(event);
        if (event instanceof ServerReadyEvent) {
            this.requestList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestList() {
        SsiServiceImpl ssiServiceImpl = this;
        synchronized (ssiServiceImpl) {
            if (this.requestedList) {
                return;
            }
            this.requestedList = true;
        }
        this.sendSnac((SnacCommand)new SsiRightsRequest());
        this.sendSnac((SnacCommand)new SsiDataRequest());
    }

    @Override
    public void requestBuddyAuthorization(Screenname sn, @Nullable String msg) {
        this.sendSnac((SnacCommand)new BuddyAuthRequest(sn.getFormatted(), msg));
    }

    @Override
    public void replyBuddyAuthorization(Screenname sn, boolean accept, @Nullable String msg) {
        this.sendSnac((SnacCommand)new AuthReplyCmd(sn.getFormatted(), msg, accept));
    }

    @Override
    public void sendFutureBuddyAuthorization(Screenname sn, @Nullable String msg) {
        this.sendSnac((SnacCommand)new AuthFutureCmd(sn.getFormatted(), msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSnacPacket(SnacPacketEvent snacPacketEvent) {
        SnacCommand snac = snacPacketEvent.getSnacCommand();
        LOGGER.fine("Got SSI packet: " + snac);
        if (snac == null) {
            LOGGER.fine("Packet: " + snacPacketEvent.getSnacPacket());
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (snac instanceof SsiDataCmd) {
            boolean done;
            SsiDataCmd ssiDataCmd = (SsiDataCmd)snac;
            boolean bl = done = (snac.getFlag2() & 1) == 0;
            if (LOGGER.isLoggable(Level.FINE)) {
                SsiServiceImpl ssiServiceImpl = this;
                synchronized (ssiServiceImpl) {
                    if (done) {
                        LOGGER.fine("Got final buddy list packet: " + this.items.size() + " items");
                    } else {
                        LOGGER.fine("Got buddy list part: " + this.items.size() + " items");
                    }
                }
            }
            List items = ssiDataCmd.getItems();
            for (SsiItem item : items) {
                LOGGER.finer("Buddy list item: " + item);
                try {
                    this.itemCreated(item);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
            if (done) {
                this.sendSnac((SnacCommand)new ActivateSsiCmd());
                this.setReady();
            }
        } else if (snac instanceof CreateItemsCmd) {
            CreateItemsCmd createItemsCmd = (CreateItemsCmd)snac;
            for (SsiItem ssiItem : createItemsCmd.getItems()) {
                LOGGER.fine("Item created by other client: " + ssiItem);
                try {
                    this.itemCreated(ssiItem);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        } else if (snac instanceof ModifyItemsCmd) {
            ModifyItemsCmd modifyItemsCmd = (ModifyItemsCmd)snac;
            for (SsiItem ssiItem : modifyItemsCmd.getItems()) {
                LOGGER.fine("Item modified by other client: " + ssiItem);
                try {
                    this.itemModified(ssiItem);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        } else if (snac instanceof DeleteItemsCmd) {
            DeleteItemsCmd deleteItemsCmd = (DeleteItemsCmd)snac;
            for (SsiItem ssiItem : deleteItemsCmd.getItems()) {
                LOGGER.fine("Item deleted by other client: " + ssiItem);
                try {
                    this.itemDeleted(ssiItem);
                }
                catch (Exception e) {
                    exceptions.add(e);
                }
            }
        } else if (snac instanceof AuthReplyCmd) {
            AuthReplyCmd cmd = (AuthReplyCmd)snac;
            for (BuddyAuthorizationListener listener : this.buddyAuthorizationListeners) {
                try {
                    if (cmd.isAccepted()) {
                        listener.authorizationAccepted(new Screenname(cmd.getSender()), cmd.getReason());
                        continue;
                    }
                    listener.authorizationDenied(new Screenname(cmd.getSender()), cmd.getReason());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Exception thrown by buddyAuthorizationListeners listener " + listener, ex);
                }
            }
        } else if (snac instanceof BuddyAuthRequest) {
            BuddyAuthRequest cmd = (BuddyAuthRequest)snac;
            for (BuddyAuthorizationListener listener : this.buddyAuthorizationListeners) {
                try {
                    listener.authorizationRequestReceived(new Screenname(cmd.getScreenname()), cmd.getMessage());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Exception thrown by buddyAuthorizationListeners listener " + listener, ex);
                }
            }
        } else if (snac instanceof AuthFutureCmd) {
            AuthFutureCmd cmd = (AuthFutureCmd)snac;
            for (BuddyAuthorizationListener listener : this.buddyAuthorizationListeners) {
                try {
                    listener.futureAuthorizationGranted(new Screenname(cmd.getUin()), cmd.getReason());
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Exception thrown by buddyAuthorizationListeners listener " + listener, ex);
                }
            }
        } else if (snac instanceof BuddyAddedYouCmd) {
            BuddyAddedYouCmd cmd = (BuddyAddedYouCmd)snac;
            for (BuddyAuthorizationListener listener : this.buddyAuthorizationListeners) {
                try {
                    listener.youWereAdded(new Screenname(cmd.getUin()));
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, "Exception thrown by buddyAuthorizationListeners listener " + listener, ex);
                }
            }
        }
        JavaTools.throwExceptions(exceptions, (String)"Exception while processing SSI packets");
    }

    @Override
    public MutableBuddyList getBuddyList() {
        return this.buddyList;
    }

    private void itemCreated(SsiItem item) {
        LOGGER.fine("Item created: " + item);
        this.storeCreatedItem(item);
        for (SsiItemChangeListener listener : this.listeners) {
            try {
                listener.handleItemCreated(item);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception thrown by SSI listener " + listener, e);
            }
        }
    }

    private synchronized void storeCreatedItem(SsiItem item) throws IllegalArgumentException {
        ItemId id = new ItemId(item);
        SsiItem old = this.items.get(id);
        if (old != null) {
            throw new IllegalArgumentException("item " + id + " already exists " + "as " + old + ", tried to add as " + item);
        }
        this.items.put(id, item);
    }

    private void itemModified(SsiItem item) {
        LOGGER.fine("Item modified: " + item);
        this.storeModifiedItem(item);
        for (SsiItemChangeListener listener : this.listeners) {
            try {
                listener.handleItemModified(item);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception thrown by SSI listener " + listener, e);
            }
        }
    }

    private synchronized void storeModifiedItem(SsiItem item) throws IllegalArgumentException {
        ItemId id = new ItemId(item);
        SsiItem oldItem = this.items.get(id);
        if (oldItem == null) {
            throw new IllegalArgumentException("item does not exist: " + id + " - " + item);
        }
        LOGGER.fine("(Old item: " + oldItem + ")");
        this.items.put(id, item);
    }

    private void itemDeleted(SsiItem item) {
        LOGGER.fine("Item deleted: " + item);
        SsiItem removed = this.removeDeletedItem(item);
        LOGGER.fine("(Actual deleted: " + removed + ")");
        for (SsiItemChangeListener listener : this.listeners) {
            try {
                listener.handleItemDeleted(item);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception thrown by SSI listener " + listener, e);
            }
        }
    }

    private synchronized SsiItem removeDeletedItem(SsiItem item) {
        SsiItem removed = this.items.remove(new ItemId(item));
        if (removed == null) {
            throw new IllegalArgumentException("no such item " + item);
        }
        return removed;
    }

    synchronized int getUniqueItemId(int type, int parent) {
        int nextid;
        if (type == 1) {
            throw new IllegalArgumentException("groups all have id 0");
        }
        Set<Integer> idsForType = this.getIdsForType(type);
        if (type == 0) {
            this.addUsedBuddyIdsInGroup(idsForType, parent);
        }
        while (idsForType.contains(nextid = this.random.nextInt(32768))) {
        }
        Collection<Integer> ids = this.prospectiveIds.get(type);
        if (ids == null) {
            ids = new ArrayList<Integer>(10);
            this.prospectiveIds.put(type, ids);
        }
        ids.add(nextid);
        return nextid;
    }

    private synchronized void addUsedBuddyIdsInGroup(Set<Integer> idsForType, int parent) {
        for (Map.Entry<ItemId, SsiItem> id : this.items.entrySet()) {
            GroupItem groupItem;
            int[] buddies;
            DefaultSsiItemObjFactory objFactory;
            SsiItemObj itemObj;
            ItemId key = id.getKey();
            if (key.getType() != 1 || key.getParent() != parent || !((itemObj = (objFactory = new DefaultSsiItemObjFactory()).getItemObj(id.getValue())) instanceof GroupItem) || (buddies = (groupItem = (GroupItem)itemObj).getBuddies()) == null) continue;
            for (int bid : buddies) {
                idsForType.add(bid);
            }
        }
    }

    private synchronized void addUsedGroupIdsInRoot(Set<Integer> idsForType) {
        for (Map.Entry<ItemId, SsiItem> id : this.items.entrySet()) {
            RootItem groupItem;
            int[] groupids;
            DefaultSsiItemObjFactory objFactory;
            SsiItemObj itemObj;
            ItemId key = id.getKey();
            if (key.getType() != 1 || key.getParent() != 0 || !((itemObj = (objFactory = new DefaultSsiItemObjFactory()).getItemObj(id.getValue())) instanceof RootItem) || (groupids = (groupItem = (RootItem)itemObj).getGroupids()) == null) continue;
            for (int bid : groupids) {
                idsForType.add(bid);
            }
        }
    }

    private synchronized Set<Integer> getIdsForType(int type) {
        HashSet<Integer> idsForType = new HashSet<Integer>(this.items.size());
        for (ItemId id : this.items.keySet()) {
            if (id.getType() != type) continue;
            idsForType.add(id.getId());
        }
        Collection<Integer> prospective = this.prospectiveIds.get(type);
        if (prospective != null) {
            idsForType.addAll(prospective);
        }
        return idsForType;
    }

    private synchronized Set<Integer> getPossiblyUsedGroupIds() {
        HashSet<Integer> idsForType = new HashSet<Integer>(this.items.size());
        for (ItemId id : this.items.keySet()) {
            if (id.getType() != 1) continue;
            idsForType.add(id.getParent());
        }
        idsForType.addAll(this.prospectiveGroupIds);
        return idsForType;
    }

    synchronized int getUniqueGroupId() {
        int nextid;
        Set<Integer> groupIds = this.getPossiblyUsedGroupIds();
        this.addUsedGroupIdsInRoot(groupIds);
        while (groupIds.contains(nextid = this.random.nextInt(32768))) {
        }
        this.prospectiveGroupIds.add(nextid);
        return nextid;
    }

    @Override
    public PermissionList getPermissionList() {
        return this.permissionList;
    }

    @Override
    public ServerStoredSettings getServerStoredSettings() {
        return this.settings;
    }

    @Override
    public MyBuddyIconItemManager getBuddyIconItemManager() {
        return this.buddyIconItemManager;
    }

    void sendSsiModification(ItemsCmd cmd, SnacRequestListener listener) {
        this.sendSnacRequest((SnacCommand)cmd, listener);
    }

    void sendSsiModification(ItemsCmd cmd) {
        this.sendSnac((SnacCommand)cmd);
    }

    @Override
    public void addItemChangeListener(SsiItemChangeListener listener) {
        this.listeners.addIfAbsent((Object)listener);
    }

    @Override
    public void removeListener(SsiItemChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void addBuddyAuthorizationListener(BuddyAuthorizationListener listener) {
        this.buddyAuthorizationListeners.addIfAbsent((Object)listener);
    }

    @Override
    public void removeBuddyAuthorizationListener(BuddyAuthorizationListener listener) {
        this.buddyAuthorizationListeners.remove((Object)listener);
    }

    private class ItemsChangeListener
    implements SnacResponseListener {
        private ItemsChangeListener() {
        }

        public void handleResponse(SnacResponseEvent e) {
            if (e.getSnacCommand() instanceof SsiDataModResponse) {
                SsiDataModResponse dataModResponse = (SsiDataModResponse)e.getSnacCommand();
                SnacCommand origCmd = e.getRequest().getCommand();
                boolean create = origCmd instanceof CreateItemsCmd;
                boolean modify = origCmd instanceof ModifyItemsCmd;
                boolean delete = origCmd instanceof DeleteItemsCmd;
                if (!(create || modify || delete)) {
                    return;
                }
                ItemsCmd itemsCmd = (ItemsCmd)origCmd;
                String className = MiscTools.getClassName((Object)itemsCmd);
                List items = itemsCmd.getItems();
                int[] results = dataModResponse.getResults();
                for (int i = 0; i < results.length; ++i) {
                    int result = results[i];
                    SsiItem item = (SsiItem)items.get(i);
                    if (result == 0) {
                        if (create) {
                            SsiServiceImpl.this.itemCreated(item);
                            continue;
                        }
                        if (modify) {
                            SsiServiceImpl.this.itemModified(item);
                            continue;
                        }
                        assert (delete);
                        SsiServiceImpl.this.itemDeleted(item);
                        continue;
                    }
                    if (result == 10) {
                        int id = item.getId();
                        TreeSet possible = new TreeSet(SsiServiceImpl.this.getIdsForType(item.getItemType()));
                        LOGGER.warning("ID taken for " + className + " of " + item);
                        LOGGER.warning("ID: " + id + " of possible ID's: " + possible);
                        continue;
                    }
                    if (result == 14) {
                        for (BuddyAuthorizationListener listener : SsiServiceImpl.this.buddyAuthorizationListeners) {
                            try {
                                if (!listener.authorizationRequired(new Screenname(item.getName()))) continue;
                                Vector<SsiItem> buddiesToBeAdded = new Vector<SsiItem>();
                                BuddyItem newBuddy = new BuddyItem(item);
                                newBuddy.setAwaitingAuth(true);
                                buddiesToBeAdded.add(newBuddy.toSsiItem());
                                CreateItemsCmd addCMD = new CreateItemsCmd(buddiesToBeAdded);
                                LOGGER.info("Adding buddy as awaiting authorization");
                                SsiServiceImpl.this.getOscarConnection().sendSnac((SnacCommand)addCMD);
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.SEVERE, "Exception thrown by buddyAuthorizationListeners listener " + listener, ex);
                            }
                        }
                        continue;
                    }
                    LOGGER.warning("SSI error 0x" + Integer.toHexString(result) + " for " + className + " of " + item);
                }
            }
        }
    }

    private static class ItemId {
        private final int type;
        private final int parent;
        private final int id;

        public ItemId(int type, int parent, int id) {
            this.type = type;
            this.parent = parent;
            this.id = id;
        }

        public ItemId(SsiItem item) {
            this(item.getItemType(), item.getParentId(), item.getId());
        }

        public int getType() {
            return this.type;
        }

        public int getParent() {
            return this.parent;
        }

        public int getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemId itemId = (ItemId)o;
            if (this.id != itemId.id) {
                return false;
            }
            if (this.parent != itemId.parent) {
                return false;
            }
            return this.type == itemId.type;
        }

        public int hashCode() {
            int result = this.type;
            result = 29 * result + this.parent;
            result = 29 * result + this.id;
            return result;
        }

        public String toString() {
            return "ItemId{type=" + MiscTools.findIntField(SsiItem.class, (long)this.type, (String)"TYPE_.*") + ", parent=0x" + Integer.toHexString(this.parent) + ", id=0x" + Integer.toHexString(this.id) + "}";
        }
    }
}

