/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.secureim;

import java.beans.PropertyChangeEvent;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.icbm.InstantMessage;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.BuddyInfo;
import net.kano.joustsim.oscar.BuddyInfoManager;
import net.kano.joustsim.oscar.BuddyInfoTracker;
import net.kano.joustsim.oscar.BuddyInfoTrackerListener;
import net.kano.joustsim.oscar.GlobalBuddyInfoAdapter;
import net.kano.joustsim.oscar.GlobalBuddyInfoListener;
import net.kano.joustsim.oscar.oscar.NoBuddyKeysException;
import net.kano.joustsim.oscar.oscar.service.icbm.Conversation;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationException;
import net.kano.joustsim.oscar.oscar.service.icbm.InternalIcbmTools;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.MutableIcbmService;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.DecryptableAimMessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.DecryptedAimMessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.DecryptedMessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.EncryptedAimMessage;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.EncryptedAimMessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.EncryptionFailedException;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.InvalidSignatureException;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.NoLocalKeysException;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.NotTrustedException;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.OutgoingSecureAimMessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.SecureAimDecoder;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.SecureAimEncoder;
import net.kano.joustsim.oscar.oscar.service.icbm.secureim.UndecryptableAimMessageInfo;
import net.kano.joustsim.trust.BuddyCertificateInfo;
import net.kano.joustsim.trust.PrivateKeys;
import net.kano.joustsim.trust.PrivateKeysPreferences;
import net.kano.joustsim.trust.TrustPreferences;
import org.bouncycastle.cms.CMSException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureAimConversation
extends Conversation {
    private static final Logger LOGGER = Logger.getLogger(SecureAimConversation.class.getName());
    private final AimConnection conn;
    private final BuddyInfoManager buddyInfoMgr;
    private final BuddyInfoTracker buddyInfoTracker;
    private SecureAimEncoder encoder = new SecureAimEncoder();
    private SecureAimDecoder decoder = new SecureAimDecoder();
    private PrivateKeys privates = null;
    private BuddyCertificateInfo buddyCertInfo = null;
    private Map<ByteBlock, LinkedList<QueuedDecryptableMsg>> decryptables = new HashMap<ByteBlock, LinkedList<QueuedDecryptableMsg>>();
    private boolean canSend = false;
    private final BuddyInfoTrackerListener trackerListener = new BuddyInfoTrackerListener(){};
    private final GlobalBuddyInfoListener buddyInfoListener = new GlobalBuddyInfoAdapter(){

        public void buddyInfoChanged(BuddyInfoManager manager, Screenname buddy, BuddyInfo info, PropertyChangeEvent event) {
            if (!buddy.equals((Object)SecureAimConversation.this.getBuddy())) {
                return;
            }
            if (event.getPropertyName().equals("certificateInfo")) {
                BuddyCertificateInfo certInfo = (BuddyCertificateInfo)event.getNewValue();
                SecureAimConversation.this.setBuddyCerts(certInfo);
                SecureAimConversation.this.tryQueuedMessages(certInfo);
            }
        }
    };

    protected SecureAimConversation(AimConnection conn, Screenname buddy) {
        super(buddy);
        DefensiveTools.checkNull((Object)conn, (String)"conn");
        this.conn = conn;
        this.buddyInfoMgr = conn.getBuddyInfoManager();
        this.buddyInfoTracker = conn.getBuddyInfoTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        Boolean canSendUpdated;
        TrustPreferences prefs = this.conn.getAimSession().getTrustPreferences();
        PrivateKeysPreferences keysMgr = prefs.getPrivateKeysPreferences();
        PrivateKeys pkinfo = keysMgr.getKeysInfo();
        SecureAimConversation secureAimConversation = this;
        synchronized (secureAimConversation) {
            this.privates = pkinfo;
            canSendUpdated = this.updateCanSend();
        }
        this.fireCanSendChanged(canSendUpdated);
    }

    private void tryQueuedMessages(BuddyCertificateInfo certInfo) {
        if (certInfo == null || !certInfo.isUpToDate()) {
            return;
        }
        List<QueuedDecryptableMsg> decrypted = this.tryDecrypting(certInfo);
        Iterator<QueuedDecryptableMsg> i$ = decrypted.iterator();
        while (i$.hasNext()) {
            QueuedDecryptableMsg aDecrypted;
            QueuedDecryptableMsg msg = aDecrypted = i$.next();
            String decryptedMsg = msg.getDecryptedForm().getMessage();
            this.handleDecrypted(msg.getMessageInfo(), decryptedMsg);
        }
    }

    private synchronized List<QueuedDecryptableMsg> tryDecrypting(BuddyCertificateInfo certInfo) {
        ByteBlock hash = certInfo.getCertificateInfoHash();
        if (hash == null) {
            return DefensiveTools.emptyList();
        }
        List<QueuedDecryptableMsg> forHash = this.tryDecryptingWithHash(certInfo, hash);
        List<QueuedDecryptableMsg> hashless = this.tryDecryptingWithHash(certInfo, null);
        if (forHash.isEmpty()) {
            return hashless;
        }
        if (hashless.isEmpty()) {
            return forHash;
        }
        ArrayList<QueuedDecryptableMsg> combined = new ArrayList<QueuedDecryptableMsg>(forHash.size() + hashless.size());
        combined.addAll(forHash);
        combined.addAll(hashless);
        return combined;
    }

    private synchronized List<QueuedDecryptableMsg> tryDecryptingWithHash(BuddyCertificateInfo certInfo, ByteBlock hash) {
        List decHash = this.decryptables.get(hash);
        if (decHash == null) {
            return DefensiveTools.emptyList();
        }
        this.decoder.setBuddyCerts(certInfo);
        ArrayList<QueuedDecryptableMsg> success = null;
        Iterator it = decHash.iterator();
        while (it.hasNext()) {
            QueuedDecryptableMsg msg = (QueuedDecryptableMsg)it.next();
            ByteBlock encrypted = msg.getMessage().getEncryptedForm();
            try {
                this.decoder.setLocalKeys(msg.getPrivates());
                DecryptedMessageInfo decrypted = this.decoder.decryptMessage(encrypted);
                it.remove();
                msg.setDecryptedForm(decrypted);
                if (success == null) {
                    success = new ArrayList<QueuedDecryptableMsg>();
                }
                success.add(msg);
            }
            catch (Exception expected) {}
        }
        if (decHash.isEmpty()) {
            this.decryptables.remove(hash);
        }
        if (success == null) {
            return DefensiveTools.emptyList();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBuddyCerts(BuddyCertificateInfo certInfo) {
        Boolean updated;
        SecureAimConversation secureAimConversation = this;
        synchronized (secureAimConversation) {
            this.buddyCertInfo = certInfo;
            updated = this.updateCanSend();
        }
        this.fireCanSendChanged(updated);
    }

    private void fireCanSendChanged(Boolean updated) {
        if (updated != null) {
            this.fireCanSendChangedEvent(updated);
        }
    }

    private synchronized Boolean updateCanSend() {
        boolean can;
        BuddyCertificateInfo buddyCertInfo = this.buddyCertInfo;
        boolean bl = can = this.privates != null && buddyCertInfo != null && buddyCertInfo.hasBothCertificates();
        if (can != this.canSend) {
            this.canSend = can;
            return can;
        }
        return null;
    }

    @Override
    protected synchronized void opened() {
        LOGGER.fine("secure conversation opened");
        Screenname buddy = this.getBuddy();
        this.buddyInfoMgr.addGlobalBuddyInfoListener(this.buddyInfoListener);
        this.buddyInfoTracker.addTracker(buddy, this.trackerListener);
        BuddyInfo buddyInfo = this.buddyInfoMgr.getBuddyInfo(buddy);
        this.setBuddyCerts(buddyInfo.getCertificateInfo());
    }

    @Override
    protected void closed() {
        this.buddyInfoMgr.removeGlobalBuddyInfoListener(this.buddyInfoListener);
        this.buddyInfoTracker.removeTracker(this.getBuddy(), this.trackerListener);
    }

    @Override
    public synchronized boolean canSendMessage() {
        return this.canSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Message msg) throws ConversationException {
        byte[] encrypted;
        BuddyCertificateInfo buddyCertInfo;
        PrivateKeys privates;
        MutableIcbmService icbmService = (MutableIcbmService)this.conn.getIcbmService();
        if (icbmService == null) {
            throw new ConversationException("no ICBM service present to send through", (Conversation)this);
        }
        try {
            SecureAimConversation secureAimConversation = this;
            synchronized (secureAimConversation) {
                privates = this.privates;
                buddyCertInfo = this.buddyCertInfo;
                this.encoder.setLocalKeys(privates);
                this.encoder.setBuddyCerts(buddyCertInfo);
                encrypted = this.encoder.encryptMsg(msg.getMessageBody());
            }
        }
        catch (NoBuddyKeysException e) {
            throw new NotTrustedException(e, (Conversation)this);
        }
        catch (Exception e) {
            throw new EncryptionFailedException(e, (Conversation)this);
        }
        InstantMessage im = new InstantMessage(ByteBlock.wrap((byte[])encrypted));
        InternalIcbmTools.sendIM(icbmService, this.getBuddy(), im, msg.isAutoResponse());
        OutgoingSecureAimMessageInfo msginfo = OutgoingSecureAimMessageInfo.getInstance(this.conn.getScreenname(), this.getBuddy(), msg, new Date(), privates, buddyCertInfo, im);
        this.fireOutgoingEvent(msginfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleIncomingEvent(ConversationEventInfo minfo) {
        this.open();
        if (!(minfo instanceof EncryptedAimMessageInfo)) {
            throw new IllegalArgumentException("SecureAimConversation can't handle incoming message objects of type " + minfo.getClass().getName() + " (" + minfo + ")");
        }
        EncryptedAimMessageInfo info = (EncryptedAimMessageInfo)minfo;
        EncryptedAimMessage msg = (EncryptedAimMessage)info.getMessage();
        BuddyCertificateInfo certInfo = info.getMessageCertificates();
        String decryptedMsg = null;
        Exception exception = null;
        SecureAimConversation secureAimConversation = this;
        synchronized (secureAimConversation) {
            try {
                this.decoder.setLocalKeys(this.privates);
                this.decoder.setBuddyCerts(info.getMessageCertificates());
                ByteBlock enc = msg.getEncryptedForm();
                DecryptedMessageInfo decrypted = this.decoder.decryptMessage(enc);
                if (decrypted != null) {
                    decryptedMsg = decrypted.getMessage();
                }
            }
            catch (Exception e) {
                exception = e;
            }
            if (exception != null && (exception instanceof NoLocalKeysException || exception instanceof NoBuddyKeysException)) {
                this.queueDecryptable(info);
            }
        }
        if (exception != null) {
            if (exception instanceof NoSuchProviderException || exception instanceof NoSuchAlgorithmException || exception instanceof CMSException) {
                this.handleUndecryptable(info, certInfo, UndecryptableAimMessageInfo.Reason.DECRYPT_ERROR, exception);
            } else if (exception instanceof InvalidSignatureException) {
                this.handleUndecryptable(info, certInfo, UndecryptableAimMessageInfo.Reason.BAD_SIGNATURE, exception);
            } else if (exception instanceof NoLocalKeysException || exception instanceof NoBuddyKeysException) {
                this.handleDecryptable(info, certInfo);
            } else {
                this.handleUndecryptable(info, certInfo, UndecryptableAimMessageInfo.Reason.UNKNOWN, exception);
            }
            return;
        }
        if (decryptedMsg == null) {
            this.handleUndecryptable(info, certInfo, UndecryptableAimMessageInfo.Reason.UNKNOWN, null);
            return;
        }
        this.handleDecrypted(info, decryptedMsg);
    }

    private void handleDecrypted(EncryptedAimMessageInfo info, String decryptedMsg) {
        BuddyCertificateInfo certInfo = info.getMessageCertificates();
        DecryptedAimMessageInfo dinfo = DecryptedAimMessageInfo.getInstance(info, decryptedMsg, certInfo);
        this.fireIncomingEvent(dinfo);
    }

    private void handleUndecryptable(EncryptedAimMessageInfo info, BuddyCertificateInfo certInfo, UndecryptableAimMessageInfo.Reason reason, Exception exception) {
        UndecryptableAimMessageInfo minfo = UndecryptableAimMessageInfo.getInstance(info, certInfo, reason, exception);
        this.fireIncomingEvent(minfo);
    }

    private synchronized void queueDecryptable(EncryptedAimMessageInfo info) {
        QueuedDecryptableMsg queued = new QueuedDecryptableMsg(this.privates, info);
        ByteBlock hash = queued.getCertificateHash();
        LinkedList<QueuedDecryptableMsg> queue = this.decryptables.get(hash);
        if (queue == null) {
            queue = new LinkedList();
            this.decryptables.put(hash, queue);
        }
        queue.addLast(queued);
    }

    private void handleDecryptable(EncryptedAimMessageInfo info, BuddyCertificateInfo certInfo) {
        this.fireIncomingEvent(DecryptableAimMessageInfo.getInstance(info, certInfo));
    }

    private static class QueuedDecryptableMsg {
        private final PrivateKeys privates;
        private final BuddyCertificateInfo buddyCerts;
        private final EncryptedAimMessageInfo msgInfo;
        private final EncryptedAimMessage emsg;
        private final ByteBlock certHash;
        private DecryptedMessageInfo decryptedForm = null;

        public QueuedDecryptableMsg(PrivateKeys privates, EncryptedAimMessageInfo msgInfo) {
            BuddyCertificateInfo certs;
            DefensiveTools.checkNull((Object)privates, (String)"privates");
            DefensiveTools.checkNull((Object)msgInfo, (String)"msg");
            EncryptedAimMessage emsg = (EncryptedAimMessage)msgInfo.getMessage();
            if (emsg == null) {
                throw new IllegalArgumentException("empty message");
            }
            this.privates = privates;
            this.msgInfo = msgInfo;
            this.emsg = emsg;
            this.buddyCerts = certs = msgInfo.getMessageCertificates();
            this.certHash = certs == null ? null : certs.getCertificateInfoHash();
        }

        public PrivateKeys getPrivates() {
            return this.privates;
        }

        public BuddyCertificateInfo getBuddyCerts() {
            return this.buddyCerts;
        }

        public EncryptedAimMessageInfo getMessageInfo() {
            return this.msgInfo;
        }

        public EncryptedAimMessage getMessage() {
            return this.emsg;
        }

        public ByteBlock getCertificateHash() {
            return this.certHash;
        }

        public synchronized void setDecryptedForm(DecryptedMessageInfo decryptedForm) {
            this.decryptedForm = decryptedForm;
        }

        public synchronized DecryptedMessageInfo getDecryptedForm() {
            return this.decryptedForm;
        }
    }
}

