/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.search;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.DirInfo;
import net.kano.joscar.snaccmd.search.SearchCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultsCmd
extends SearchCommand {
    public static final int CODE_DEFAULT = 5;
    public static final int SUBCODE_DEFAULT = 0;
    private final int code;
    private final int subCode;
    private final List<DirInfo> results;

    protected SearchResultsCmd(SnacPacket packet) {
        super(3);
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = packet.getData();
        this.code = BinaryTools.getUShort((ByteBlock)snacData, (int)0);
        this.subCode = BinaryTools.getUShort((ByteBlock)snacData, (int)2);
        if (snacData.getLength() >= 6) {
            int resultCount = BinaryTools.getUShort((ByteBlock)snacData, (int)4);
            ArrayList<DirInfo> resultList = new ArrayList<DirInfo>();
            ByteBlock block = snacData.subBlock(6);
            for (int i = 0; i < resultCount; ++i) {
                int tlvCount = BinaryTools.getUShort((ByteBlock)block, (int)0);
                ByteBlock dirBlock = block.subBlock(2);
                DirInfo dirInfo = DirInfo.readDirInfo(dirBlock, tlvCount);
                if (dirInfo == null) break;
                resultList.add(dirInfo);
                block = block.subBlock(2 + dirInfo.getTotalSize());
            }
            this.results = DefensiveTools.getUnmodifiable(resultList);
        } else {
            this.results = null;
        }
    }

    public SearchResultsCmd(Collection<DirInfo> results) {
        this(5, 0, results);
    }

    public SearchResultsCmd(int code, int subCode, Collection<DirInfo> results) {
        super(3);
        DefensiveTools.checkRange((int)code, (String)"code", (int)0);
        DefensiveTools.checkRange((int)subCode, (String)"subCode", (int)0);
        this.code = code;
        this.subCode = subCode;
        this.results = DefensiveTools.getSafeNonnullListCopy(results, (String)"results");
    }

    public final int getResultCode() {
        return this.code;
    }

    public final int getResultSubCode() {
        return this.subCode;
    }

    public List<DirInfo> getResults() {
        return this.results;
    }

    @Override
    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort((OutputStream)out, (int)this.code);
        BinaryTools.writeUShort((OutputStream)out, (int)this.subCode);
        if (this.results != null) {
            BinaryTools.writeUShort((OutputStream)out, (int)this.results.size());
            for (DirInfo result : this.results) {
                BinaryTools.writeUShort((OutputStream)out, (int)result.getTlvCount());
                result.write(out);
            }
        }
    }

    public String toString() {
        return "SearchResultsCmd: " + this.results.size() + " results";
    }
}

