/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ImEncodedString;
import net.kano.joscar.ImEncodingParams;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.icbm.AbstractImIcbm;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class OldIcbm
extends AbstractImIcbm {
    private static final int TYPE_MESSAGE_DATA = 5;
    public static final int MTYPE_AUTHREQ = 6;
    public static final int MTYPE_AUTHDENY = 7;
    public static final int MTYPE_AUTHOK = 8;
    public static final int MTYPE_ADDED = 12;
    public static final int MTYPE_PLAIN = 1;
    public static final int MTYPE_CHAT = 2;
    public static final int MTYPE_FILEREQ = 3;
    public static final int MTYPE_URL = 4;
    public static final int MTYPE_SERVER = 9;
    public static final int MTYPE_WWP = 13;
    public static final int MTYPE_EEXPRESS = 14;
    public static final int MTYPE_CONTACTS = 19;
    public static final int MTYPE_PLUGIN = 26;
    public static final int MTYPE_AUTOAWAY = 232;
    public static final int MTYPE_AUTOBUSY = 233;
    public static final int MTYPE_AUTONA = 234;
    public static final int MTYPE_AUTODND = 235;
    public static final int MTYPE_AUTOFFC = 236;
    private int messageType = -1;
    private final FullUserInfo userInfo;
    private long sender;
    private String reason;
    private long requestID = -1L;

    public OldIcbm(SnacPacket packet) {
        super(7, packet);
        this.requestID = packet.getReqid();
        DefensiveTools.checkNull((Object)packet, (String)"packet");
        ByteBlock snacData = this.getChannelData();
        this.userInfo = FullUserInfo.readUserInfo(snacData);
        ByteBlock tlvBlock = snacData.subBlock(this.userInfo.getTotalSize());
        ImmutableTlvChain chain = TlvTools.readChain(tlvBlock);
        Tlv messageDataTlv = chain.getLastTlv(5);
        ByteBlock messageData = messageDataTlv.getData();
        this.sender = LEBinaryTools.getUInt(messageData, 0);
        this.messageType = LEBinaryTools.getUByte(messageData, 4);
        short msgFlags = LEBinaryTools.getUByte(messageData, 5);
        int textlen = LEBinaryTools.getUShort(messageData, 6) - 1;
        ByteBlock field = messageData.subBlock(8, textlen);
        ImEncodingParams encoding = new ImEncodingParams(0);
        this.reason = ImEncodedString.readImEncodedString(encoding, field);
    }

    protected void writeChannelData(OutputStream out) throws IOException {
    }

    public String getReason() {
        return this.reason;
    }

    public long getSender() {
        return this.sender;
    }

    public FullUserInfo getUserInfo() {
        return this.userInfo;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public long getRequestID() {
        return this.requestID;
    }
}

