/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antserver.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import net.sf.antcontrib.antserver.Command;
import net.sf.antcontrib.antserver.Response;
import net.sf.antcontrib.antserver.commands.DisconnectCommand;
import org.apache.tools.ant.Project;

public class Client {
    private String machine;
    private int port;
    private Project project;
    private Socket socket;
    private OutputStream os;
    private InputStream is;
    private ObjectOutputStream oos;
    private ObjectInputStream ois;
    private boolean connected;

    public Client(Project project, String string, int n) {
        this.machine = string;
        this.port = n;
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        this.project.log("Opening connection to " + this.machine + ":" + this.port, 4);
        try {
            this.socket = new Socket(this.machine, this.port);
            this.project.log("Got connection to " + this.machine + ":" + this.port, 4);
            this.os = this.socket.getOutputStream();
            this.is = this.socket.getInputStream();
            this.oos = new ObjectOutputStream(this.os);
            this.ois = new ObjectInputStream(this.is);
            this.connected = true;
            try {
                this.ois.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        finally {
            if (!this.connected) {
                try {
                    if (this.os != null) {
                        this.os.close();
                    }
                    this.os = null;
                    this.oos = null;
                }
                catch (IOException iOException) {}
                try {
                    if (this.is != null) {
                        this.is.close();
                    }
                    this.is = null;
                    this.ois = null;
                }
                catch (IOException iOException) {}
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                    this.socket = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void disconnect() throws IOException {
        if (!this.connected) {
            return;
        }
        this.oos.writeObject(DisconnectCommand.DISCONNECT_COMMAND);
        try {
            this.ois.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.os = null;
        this.oos = null;
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.is = null;
        this.ois = null;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
        this.connected = false;
    }

    public Response sendCommand(Command command) throws IOException {
        this.project.log("Sending command: " + command, 4);
        this.oos.writeObject(command);
        command.localExecute(this.project, this.oos);
        Response response = null;
        try {
            response = (Response)this.ois.readObject();
            this.project.log("Received Response: " + response, 4);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return response;
    }
}

