/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.screens;

import com.install4j.runtime.installer.config.ComponentConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.InstallerWizard;
import com.install4j.runtime.installer.frontend.screens.BaseChecklistScreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ComponentsScreen
extends BaseChecklistScreen {
    public ComponentsScreen(InstallerWizard installerWizard) {
        super(installerWizard);
    }

    protected void addSingleChecks(GridBagConstraints gridBagConstraints) {
        gridBagConstraints.insets.bottom = 0;
        Iterator iterator = InstallerConfig.getCurrentInstance().getComponents().iterator();
        while (iterator.hasNext()) {
            ComponentConfig componentConfig = (ComponentConfig)iterator.next();
            SingleComponentPanel singleComponentPanel = new SingleComponentPanel(componentConfig);
            this.checklistPanel.add((Component)singleComponentPanel, gridBagConstraints);
            this.singleCheckPanels.add(singleComponentPanel);
            ++gridBagConstraints.gridy;
        }
    }

    protected String getTitle() {
        return this.messages.getString("WizardSelectComponents");
    }

    protected String getSubTitle() {
        return this.messages.getString("SelectComponentsDesc");
    }

    protected void addScreenContent(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        this.addDisplayTextArea(MessageFormat.format(this.messages.getString("SelectComponentsLabel2"), this.getApplicationName()), jPanel, gridBagConstraints);
        super.addScreenContent(jPanel, gridBagConstraints);
    }

    protected class SingleComponentPanel
    extends BaseChecklistScreen.SingleCheckPanel {
        private ComponentConfig componentConfig;
        private JCheckBox chkInstall;

        public SingleComponentPanel(ComponentConfig componentConfig) {
            this.componentConfig = componentConfig;
            this.setLayout(new BorderLayout());
            this.chkInstall = new JCheckBox(componentConfig.getName(), componentConfig.isSelected());
            this.chkInstall.setEnabled(!componentConfig.isMandatory());
            this.add((Component)this.chkInstall, "West");
        }

        public void save() {
            this.componentConfig.setSelected(this.chkInstall.isSelected());
        }

        public void update() {
            this.chkInstall.setSelected(this.componentConfig.isSelected());
        }
    }
}

