/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.generators.DHParametersHelper;
import org.bouncycastle.crypto.params.ElGamalParameters;

public class ElGamalParametersGenerator {
    private int size;
    private int certainty;
    private SecureRandom random;
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    public void init(int n, int n2, SecureRandom secureRandom) {
        this.size = n;
        this.certainty = n2;
        this.random = secureRandom;
    }

    public ElGamalParameters generateParameters() {
        BigInteger bigInteger;
        BigInteger[] bigIntegerArray = DHParametersHelper.generateSafePrimes(this.size, this.certainty, this.random);
        BigInteger bigInteger2 = bigIntegerArray[0];
        BigInteger bigInteger3 = bigIntegerArray[1];
        int n = this.size - 1;
        while ((bigInteger = new BigInteger(n, this.random)).modPow(TWO, bigInteger2).equals(ONE) || bigInteger.modPow(bigInteger3, bigInteger2).equals(ONE)) {
        }
        return new ElGamalParameters(bigInteger2, bigInteger);
    }
}

