/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.util.Stack;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.utils.Debug;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ChangePrefixMapping;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.Comment;
import weblogic.xml.stream.EndDocument;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.EndPrefixMapping;
import weblogic.xml.stream.EntityReference;
import weblogic.xml.stream.ProcessingInstruction;
import weblogic.xml.stream.Space;
import weblogic.xml.stream.StartDocument;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.StartPrefixMapping;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLStreamException;

public class DOMNodeWriter
extends XMLWriter {
    protected Stack nodeParentStack;
    protected Document document;
    protected Node root;
    protected int level;
    private static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";

    public DOMNodeWriter(Document document) {
        this.document = document;
        this.root = this.document;
        this.init();
    }

    public DOMNodeWriter(Document document, DocumentFragment documentFragment) {
        this.document = document;
        this.root = documentFragment;
        this.init();
    }

    protected void init() {
        this.setWriteHeader(true);
        this.setWriteElementNameSpaces(true);
        this.setWriteAll(false);
        this.setShowNamespaceBindings(false);
        this.setNormalizeWhiteSpace(false);
        this.reset();
    }

    public void reset() {
        this.level = 0;
        this.nodeParentStack = new Stack();
    }

    protected Node getCurrentParent() throws XMLStreamException {
        if (this.nodeParentStack.empty()) {
            throw new XMLStreamException("Null parent");
        }
        return (Node)this.nodeParentStack.peek();
    }

    public void addAttributes(AttributeIterator attributeIterator, Element element) throws XMLStreamException {
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            try {
                element.setAttributeNS(attribute.getName().getNamespaceUri(), attribute.getName().getQualifiedName(), attribute.getValue());
            }
            catch (DOMException dOMException) {
                Debug.say((String)("(manoj):e" + element));
                Debug.say((String)("(manoj):a" + attribute));
                Debug.say((String)("(manoj):domException" + dOMException));
                throw new XMLStreamException((Throwable)dOMException);
            }
        }
    }

    public void addNamespaces(AttributeIterator attributeIterator, Element element) throws XMLStreamException {
        while (attributeIterator.hasNext()) {
            Attribute attribute = attributeIterator.next();
            try {
                element.setAttributeNS(XMLNS_URI, attribute.getName().getQualifiedName(), attribute.getValue());
            }
            catch (DOMException dOMException) {
                throw new XMLStreamException((Throwable)dOMException);
            }
        }
    }

    public void write(StartElement startElement) throws XMLStreamException {
        Element element = this.document.createElementNS(startElement.getName().getNamespaceUri(), startElement.getName().getQualifiedName());
        if (this.writeElementNameSpaces) {
            this.addNamespaces(startElement.getNamespaces(), element);
        }
        this.addAttributes(startElement.getAttributes(), element);
        if (this.nodeParentStack.empty()) {
            DocumentFragment documentFragment = this.document.createDocumentFragment();
            documentFragment.appendChild(element);
            this.root.appendChild(documentFragment);
            this.nodeParentStack.push(element);
            ++this.level;
        } else {
            this.getCurrentParent().appendChild(element);
            this.nodeParentStack.push(element);
            ++this.level;
        }
    }

    public void write(EndElement endElement) throws XMLStreamException {
        --this.level;
        this.nodeParentStack.pop();
    }

    public void write(ProcessingInstruction processingInstruction) throws XMLStreamException {
        this.getCurrentParent().appendChild(this.document.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData()));
    }

    public void write(CharacterData characterData) throws XMLStreamException {
        if (this.nodeParentStack.empty()) {
            DocumentFragment documentFragment = this.document.createDocumentFragment();
            documentFragment.appendChild(this.document.createTextNode(characterData.getContent()));
            this.root.appendChild(documentFragment);
        } else {
            this.getCurrentParent().appendChild(this.document.createTextNode(characterData.getContent()));
        }
    }

    public void write(StartDocument startDocument) throws XMLStreamException {
        this.reset();
        this.nodeParentStack.push(this.document);
    }

    public void write(EndDocument endDocument) throws XMLStreamException {
    }

    public void write(Comment comment) throws XMLStreamException {
        this.getCurrentParent().appendChild(this.document.createComment(comment.getContent()));
    }

    public void write(StartPrefixMapping startPrefixMapping) throws XMLStreamException {
    }

    public void write(ChangePrefixMapping changePrefixMapping) throws XMLStreamException {
    }

    public void write(EndPrefixMapping endPrefixMapping) throws XMLStreamException {
    }

    public void write(EntityReference entityReference) throws XMLStreamException {
        this.document.createEntityReference(entityReference.getName().getQualifiedName());
    }

    public void write(Space space) throws XMLStreamException {
        if (this.level > 0) {
            this.getCurrentParent().appendChild(this.document.createTextNode(space.getContent()));
        }
    }

    public void flush() throws XMLStreamException {
    }

    public Node getDocument() throws XMLStreamException {
        return this.getCurrentParent();
    }

    public boolean write(XMLEvent xMLEvent) throws XMLStreamException {
        switch (xMLEvent.getType()) {
            case 2: {
                this.write((StartElement)xMLEvent);
                break;
            }
            case 4: {
                this.write((EndElement)xMLEvent);
                break;
            }
            case 8: {
                this.write((ProcessingInstruction)xMLEvent);
                break;
            }
            case 16: {
                this.write((CharacterData)xMLEvent);
                break;
            }
            case 32: {
                this.write((Comment)xMLEvent);
                break;
            }
            case 256: {
                this.write((StartDocument)xMLEvent);
                break;
            }
            case 512: {
                this.write((EndDocument)xMLEvent);
                break;
            }
            case 1024: {
                this.write((StartPrefixMapping)xMLEvent);
                break;
            }
            case 2048: {
                this.write((EndPrefixMapping)xMLEvent);
                break;
            }
            case 4096: {
                this.write((ChangePrefixMapping)xMLEvent);
                break;
            }
            case 8192: {
                this.write((EntityReference)xMLEvent);
                break;
            }
            case 64: {
                this.write((Space)xMLEvent);
                break;
            }
            case 128: {
                throw new XMLStreamException("Attempt to write a null element.");
            }
            default: {
                throw new XMLStreamException("Attempt to write unknown element [" + xMLEvent.getType() + "]");
            }
        }
        return true;
    }
}

