/*
 * Decompiled with CFR 0.152.
 */
package com.oopsconsultancy.xmltask;

import com.oopsconsultancy.xmltask.Action;
import com.oopsconsultancy.xmltask.XPathAnalyser;
import com.oopsconsultancy.xmltask.XPathAnalyserClient;
import com.oopsconsultancy.xmltask.XPathAnalyserFactory;
import java.util.ArrayList;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlReplace
implements XPathAnalyserClient {
    private String path = null;
    private Action action = null;
    private Task task = null;

    public XmlReplace(String path, Action action) {
        this.path = path;
        this.action = action;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    private void log(String msg, int level) {
        if (this.task != null) {
            this.task.log(msg, level);
        } else {
            System.out.println(msg);
        }
    }

    public int apply(Document doc) throws Exception {
        this.log("Applying " + this.action + " to " + this.path, 3);
        this.action.setDocument(doc);
        ArrayList removals = new ArrayList();
        XPathAnalyser xpa = XPathAnalyserFactory.getAnalyser();
        xpa.registerClient(this, null);
        int count = xpa.analyse(doc, this.path);
        this.log("Applied " + this.action + " - " + count + " match(es)", 3);
        this.action.complete();
        return count;
    }

    public String toString() {
        return this.action.toString() + " (" + this.path + ")";
    }

    public void applyNode(Node n, Object callback) throws Exception {
        this.action.apply(n);
    }

    public void applyNode(String str, Object callback) throws Exception {
        this.action.apply(this.action.getDocument().createTextNode(str));
    }
}

