/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.util.Properties;
import java.util.Vector;
import ymsg.network.ConnectionHandler;
import ymsg.network.NetworkConstants;
import ymsg.network.PacketBodyBuffer;
import ymsg.network.ServiceConstants;
import ymsg.network.Session;
import ymsg.network.Util;
import ymsg.network.YMSG9InputStream;
import ymsg.network.YMSG9Packet;

public class HTTPConnectionHandler
extends ConnectionHandler
implements ServiceConstants,
NetworkConstants {
    private ThreadGroup threadGroup;
    private Session session;
    private String proxyHost;
    private int proxyPort;
    private long lastFetch;
    private Vector packets;
    private boolean connected = false;
    private boolean quitFlag = false;
    private String cookie = null;
    private long identifier = 0L;
    private Notifier notifierThread;
    private static final long IDLE_TIMEOUT = 30000L;
    private String headerHttpPost;
    private String headerAgent;
    private String headerHost;
    private String headerProxyAuth;

    public HTTPConnectionHandler() throws IllegalArgumentException {
        this._init();
        this.proxyHost = Util.httpProxyHost();
        this.proxyPort = Util.httpProxyPort();
        if (this.proxyHost == null || this.proxyPort <= 0) {
            throw new IllegalArgumentException("Bad HTTP proxy properties");
        }
    }

    public HTTPConnectionHandler(String ph, int pp, String ex) {
        this._init();
        this.proxyHost = ph;
        this.proxyPort = pp;
        Properties p = System.getProperties();
        p.put("proxyHost", this.proxyHost);
        p.put("http.proxyHost", this.proxyHost);
        p.put("proxyPort", this.proxyPort + "");
        p.put("http.proxyPort", this.proxyPort + "");
        p.put("proxySet", "true");
        if (ex != null) {
            p.put("http.nonProxyHosts", ex);
        } else {
            p.remove("http.nonProxyHosts");
        }
    }

    public HTTPConnectionHandler(String ph, int pp, Vector ex) {
        this(ph, pp, (String)null);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ex.size(); ++i) {
            sb.append((String)ex.elementAt(i));
            if (i + 1 >= ex.size()) continue;
            sb.append("|");
        }
        System.getProperties().put("http.nonProxyHosts", sb.toString());
    }

    public HTTPConnectionHandler(String ph, int pp) {
        this(ph, pp, (String)null);
    }

    private void _init() {
        this.packets = new Vector(5);
        this.connected = false;
        String host = Util.httpHost();
        this.headerHttpPost = "POST http://" + host + "/notify HTTP/1.0" + "\n";
        this.headerAgent = "User-Agent: Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)\n";
        this.headerHost = "Host: " + host + "\n";
        this.headerProxyAuth = "Proxy-Authorization: " + Util.httpProxyAuth() + "\n";
    }

    public static void setProxyAuthorizationProperty(String method, String username, String password) throws UnsupportedOperationException {
        if (!method.equalsIgnoreCase("basic")) {
            throw new UnsupportedOperationException("Method " + method + " unsupported.");
        }
        String a = username + ":" + password;
        String s = "Basic " + Util.base64(a.getBytes());
        System.setProperty("ymsg.network.httpProxyAuth", s);
    }

    void install(Session ss, ThreadGroup tg) {
        this.session = ss;
        this.threadGroup = tg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() {
        this.connected = true;
        HTTPConnectionHandler hTTPConnectionHandler = this;
        synchronized (hTTPConnectionHandler) {
            if (this.notifierThread == null) {
                this.notifierThread = new Notifier(this.threadGroup, "HTTP Notifier");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.connected = false;
        HTTPConnectionHandler hTTPConnectionHandler = this;
        synchronized (hTTPConnectionHandler) {
            if (this.notifierThread != null) {
                this.notifierThread.quitFlag = true;
                this.notifierThread = null;
            }
        }
    }

    synchronized void sendPacket(PacketBodyBuffer body, int service, long status, long sessionID) throws IOException, IllegalStateException {
        if (!this.connected) {
            throw new IllegalStateException("Not logged in");
        }
        if (this.filterOutput(body, service)) {
            return;
        }
        byte[] b = body.getBuffer();
        Socket soc = new Socket(this.proxyHost, this.proxyPort);
        PushbackInputStream pbis = new PushbackInputStream(soc.getInputStream());
        DataOutputStream dos = new DataOutputStream(soc.getOutputStream());
        dos.writeBytes(this.headerHttpPost);
        dos.writeBytes("Content-length: " + (b.length + 20) + "\n");
        dos.writeBytes(this.headerAgent);
        dos.writeBytes(this.headerHost);
        if (this.headerProxyAuth != null) {
            dos.writeBytes(this.headerProxyAuth);
        }
        if (this.cookie != null) {
            dos.writeBytes("Cookie: " + this.cookie + "\n");
        }
        dos.writeBytes("\n");
        dos.write(NetworkConstants.MAGIC, 0, 4);
        dos.write(NetworkConstants.VERSION_HTTP, 0, 4);
        dos.writeShort(b.length & 0xFFFF);
        dos.writeShort(service & 0xFFFF);
        dos.writeInt((int)(status & 0xFFFFFFFFFFFFFFFFL));
        dos.writeInt((int)(sessionID & 0xFFFFFFFFFFFFFFFFL));
        dos.write(b, 0, b.length);
        dos.flush();
        String s = this.readLine(pbis);
        if (s == null || s.indexOf(" 200 ") < 0) {
            return;
        }
        while (s != null && s.trim().length() > 0) {
            s = this.readLine(pbis);
        }
        byte[] code = new byte[4];
        pbis.read(code, 0, 4);
        int count = code[0];
        YMSG9InputStream yip = new YMSG9InputStream(pbis);
        try {
            for (int i = 0; i < count; ++i) {
                YMSG9Packet pkt = yip.readPacket();
                if (this.filterInput(pkt)) continue;
                this.push(pkt);
            }
        }
        catch (Exception e) {
            this.push(e);
        }
        if (Util.debugMode) {
            System.out.println("Size:" + this.packets.size());
        }
        soc.close();
        this.lastFetch = System.currentTimeMillis();
    }

    private String readLine(PushbackInputStream pbis) throws IOException {
        int c = pbis.read();
        String s = "";
        while (c != 10 && c != 13) {
            s = s + (char)c;
            c = pbis.read();
        }
        int c2 = pbis.read();
        if (c == 10 && c2 != 13 || c == 13 && c2 != 10) {
            pbis.unread(c2);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    YMSG9Packet receivePacket() throws IOException {
        if (!this.connected) {
            throw new IllegalStateException("Not logged in");
        }
        while (true) {
            HTTPConnectionHandler hTTPConnectionHandler = this;
            synchronized (hTTPConnectionHandler) {
                if (this.packets.size() > 0) {
                    Object o = this.pull();
                    if (o instanceof IOException) {
                        throw (IOException)o;
                    }
                    return (YMSG9Packet)o;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private boolean filterOutput(PacketBodyBuffer body, int service) {
        switch (service) {
            case 2: 
            case 4: {
                return true;
            }
        }
        if (this.identifier > 0L) {
            body.addElement("24", this.identifier + "");
        }
        return false;
    }

    private boolean filterInput(YMSG9Packet pkt) {
        switch (pkt.service) {
            case 85: {
                String[] cookieArr = HTTPConnectionHandler.extractCookies(pkt);
                this.cookie = cookieArr[0] + "; " + cookieArr[1];
                break;
            }
            case 1: {
                try {
                    this.identifier = Long.parseLong(pkt.getValue("24"));
                }
                catch (NumberFormatException e) {
                    this.identifier = 0L;
                }
                break;
            }
            case 6: {
                if (pkt.getValue("14") != null) break;
                if (pkt.getValue("10") != null) {
                    pkt.service = 4;
                    break;
                }
                if (pkt.body.length != 0) break;
                return true;
            }
        }
        return false;
    }

    private synchronized Object pull() {
        if (this.packets.size() <= 0) {
            return null;
        }
        Object p = this.packets.elementAt(0);
        this.packets.removeElementAt(0);
        return p;
    }

    private synchronized void push(Object p) {
        this.packets.addElement(p);
    }

    public String toString() {
        return "HTTP connection: " + this.proxyHost + ":" + this.proxyPort;
    }

    class Notifier
    extends Thread {
        boolean quitFlag = false;

        Notifier(ThreadGroup tg, String nm) {
            super(tg, nm);
            HTTPConnectionHandler.this.lastFetch = System.currentTimeMillis();
            this.start();
        }

        public void run() {
            while (!this.quitFlag) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long t = System.currentTimeMillis();
                if (this.quitFlag || !HTTPConnectionHandler.this.connected || t - HTTPConnectionHandler.this.lastFetch <= 30000L || HTTPConnectionHandler.this.session.getSessionStatus() != 2) continue;
                try {
                    HTTPConnectionHandler.this.session.transmitIdle();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

