/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.NameValue;
import gov.nist.javax.sip.header.Authorization;
import gov.nist.javax.sip.header.Challenge;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.ProxyAuthorization;
import java.text.ParseException;
import javax.sip.address.URI;

public abstract class AuthenticationHeader
extends ParametersHeader {
    public static final String DOMAIN = "domain";
    public static final String REALM = "realm";
    public static final String OPAQUE = "opaque";
    public static final String ALGORITHM = "algorithm";
    public static final String QOP = "qop";
    public static final String STALE = "stale";
    public static final String SIGNATURE = "signature";
    public static final String RESPONSE = "response";
    public static final String SIGNED_BY = "signed-by";
    public static final String NC = "nc";
    public static final String URI = "uri";
    public static final String USERNAME = "username";
    public static final String CNONCE = "cnonce";
    public static final String NONCE = "nonce";
    public static final String IK = "ik";
    public static final String CK = "ck";
    public static final String INTEGRITY_PROTECTED = "integrity-protected";
    protected String scheme;

    public AuthenticationHeader(String string) {
        super(string);
        this.parameters.setSeparator(",");
        this.scheme = "Digest";
    }

    public AuthenticationHeader() {
        this.parameters.setSeparator(",");
    }

    public void setParameter(String string, String string2) throws ParseException {
        NameValue nameValue = this.parameters.getNameValue(string.toLowerCase());
        if (nameValue == null) {
            nameValue = new NameValue(string, string2);
            if (string.equalsIgnoreCase(QOP) || string.equalsIgnoreCase(REALM) || string.equalsIgnoreCase(CNONCE) || string.equalsIgnoreCase(NONCE) || string.equalsIgnoreCase(USERNAME) || string.equalsIgnoreCase(DOMAIN) || string.equalsIgnoreCase(OPAQUE) || string.equalsIgnoreCase("nextnonce") || string.equalsIgnoreCase(URI) || string.equalsIgnoreCase(RESPONSE) || string.equalsIgnoreCase(IK) || string.equalsIgnoreCase(CK) || string.equalsIgnoreCase(INTEGRITY_PROTECTED)) {
                if (!(this instanceof Authorization) && !(this instanceof ProxyAuthorization) || !string.equalsIgnoreCase(QOP)) {
                    nameValue.setQuotedValue();
                }
                if (string2 == null) {
                    throw new NullPointerException("null value");
                }
                if (string2.startsWith("\"")) {
                    throw new ParseException(string2 + " : Unexpected DOUBLE_QUOTE", 0);
                }
            }
            super.setParameter(nameValue);
        } else {
            nameValue.setValue(string2);
        }
    }

    public void setChallenge(Challenge challenge) {
        this.scheme = challenge.scheme;
        this.parameters = challenge.authParams;
    }

    public String encodeBody() {
        return this.scheme + " " + this.parameters.encode();
    }

    public void setScheme(String string) {
        this.scheme = string;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setRealm(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception,  AuthenticationHeader, setRealm(), The realm parameter is null");
        }
        this.setParameter(REALM, string);
    }

    public String getRealm() {
        return this.getParameter(REALM);
    }

    public void setNonce(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception,  AuthenticationHeader, setNonce(), The nonce parameter is null");
        }
        this.setParameter(NONCE, string);
    }

    public String getNonce() {
        return this.getParameter(NONCE);
    }

    public void setURI(URI uRI) {
        if (uRI == null) {
            throw new NullPointerException("Null URI");
        }
        NameValue nameValue = new NameValue(URI, uRI);
        nameValue.setQuotedValue();
        this.parameters.set(nameValue);
    }

    public URI getURI() {
        return this.getParameterAsURI(URI);
    }

    public void setAlgorithm(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter(ALGORITHM, string);
    }

    public String getAlgorithm() {
        return this.getParameter(ALGORITHM);
    }

    public void setQop(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter(QOP, string);
    }

    public String getQop() {
        return this.getParameter(QOP);
    }

    public void setOpaque(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter(OPAQUE, string);
    }

    public String getOpaque() {
        return this.getParameter(OPAQUE);
    }

    public void setDomain(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("null arg");
        }
        this.setParameter(DOMAIN, string);
    }

    public String getDomain() {
        return this.getParameter(DOMAIN);
    }

    public void setStale(boolean bl) {
        this.setParameter(new NameValue(STALE, new Boolean(bl)));
    }

    public boolean isStale() {
        return this.getParameterAsBoolean(STALE);
    }

    public void setCNonce(String string) throws ParseException {
        this.setParameter(CNONCE, string);
    }

    public String getCNonce() {
        return this.getParameter(CNONCE);
    }

    public int getNonceCount() {
        return this.getParameterAsHexInt(NC);
    }

    public void setNonceCount(int n) throws ParseException {
        if (n < 0) {
            throw new ParseException("bad value", 0);
        }
        String string = Integer.toHexString(n);
        String string2 = "00000000";
        string = string2.substring(0, 8 - string.length()) + string;
        this.setParameter(NC, string);
    }

    public String getResponse() {
        return (String)this.getParameterValue(RESPONSE);
    }

    public void setResponse(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("Null parameter");
        }
        this.setParameter(RESPONSE, string);
    }

    public String getUsername() {
        return this.getParameter(USERNAME);
    }

    public void setUsername(String string) throws ParseException {
        this.setParameter(USERNAME, string);
    }

    public void setIK(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception,  AuthenticationHeader, setIk(), The auth-param IK parameter is null");
        }
        this.setParameter(IK, string);
    }

    public String getIK() {
        return this.getParameter(IK);
    }

    public void setCK(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception,  AuthenticationHeader, setCk(), The auth-param CK parameter is null");
        }
        this.setParameter(CK, string);
    }

    public String getCK() {
        return this.getParameter(CK);
    }

    public void setIntegrityProtected(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception,  AuthenticationHeader, setIntegrityProtected(), The integrity-protected parameter is null");
        }
        this.setParameter(INTEGRITY_PROTECTED, string);
    }

    public String getIntegrityProtected() {
        return this.getParameter(INTEGRITY_PROTECTED);
    }
}

