/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.wizard;

import com.install4j.runtime.wizard.WizardBase;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class WizardFrame
extends JFrame {
    private WizardBase wizardBase;

    public WizardFrame(WizardBase wizardBase, JFrame jFrame) {
        this.wizardBase = wizardBase;
        this.init(jFrame);
    }

    private int getFrameHeight() {
        return this.wizardBase.getFrameHeight();
    }

    private int getFrameWidth() {
        return this.wizardBase.getFrameWidth();
    }

    private void init(JFrame jFrame) {
        this.setContentPane(this.wizardBase);
        if (this.isMacOS()) {
            this.wizardBase.setBorder(BorderFactory.createEmptyBorder(0, 0, 11, 0));
        }
        if (jFrame != null) {
            this.setIconImage(jFrame.getIconImage());
        }
        this.setTitle(this.wizardBase.getTitle());
        this.setBounds(this.getNewFrameBounds());
        this.setDefaultCloseOperation(0);
        if (this.wizardBase.isQuitOnWindowClose()) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    WizardFrame.this.wizardBase.quit();
                }
            });
        }
    }

    protected Rectangle getNewFrameBounds() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = this.getFrameWidth();
        int n2 = this.getFrameHeight();
        if (n == -1) {
            n = this.getWidth();
        }
        if (n2 == -1) {
            n2 = this.getHeight();
        }
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        Rectangle rectangle = new Rectangle(n3, n4, n, n2);
        return rectangle;
    }

    private boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }
}

