/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snac;

import net.kano.joscar.SeqNum;
import net.kano.joscar.flap.FlapProcessor;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.AbstractSnacProcessor;

public class ServerSnacProcessor
extends AbstractSnacProcessor {
    public static final long REQID_MIN = 0x80000000L;
    public static final long REQID_MAX = 0xFFFFFFFFL;
    private final SeqNum reqid = new SeqNum(0x80000000L, 0xFFFFFFFFL);

    public ServerSnacProcessor(FlapProcessor flapProcessor) {
        super(flapProcessor);
    }

    public final void sendSnac(SnacCommand cmd) {
        this.sendSnac(this.reqid.next(), cmd);
    }

    public final void sendResponse(long reqid, SnacCommand cmd) {
        if (reqid >= 0x80000000L && reqid <= 0xFFFFFFFFL) {
            throw new IllegalArgumentException("response ID (" + reqid + ") " + "must not be in server request ID range (0x" + Long.toHexString(0x80000000L) + "-0x" + Long.toHexString(0xFFFFFFFFL) + ", inclusive)");
        }
        this.sendSnac(reqid, cmd);
    }

    public String toString() {
        return "ServerSnacProcessor: lastreqid=" + this.reqid.getLast();
    }
}

