/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.ContainsRegexpSelector;
import org.apache.tools.ant.types.selectors.ContainsSelector;
import org.apache.tools.ant.types.selectors.DateSelector;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.DepthSelector;
import org.apache.tools.ant.types.selectors.DifferentSelector;
import org.apache.tools.ant.types.selectors.ExtendSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.MajoritySelector;
import org.apache.tools.ant.types.selectors.NoneSelector;
import org.apache.tools.ant.types.selectors.NotSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.apache.tools.ant.types.selectors.SelectSelector;
import org.apache.tools.ant.types.selectors.SelectorContainer;
import org.apache.tools.ant.types.selectors.SelectorScanner;
import org.apache.tools.ant.types.selectors.SizeSelector;
import org.apache.tools.ant.types.selectors.TypeSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.ModifiedSelector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractFileSet
extends DataType
implements Cloneable,
SelectorContainer {
    private PatternSet defaultPatterns;
    private Vector additionalPatterns;
    private Vector selectors;
    private File dir;
    private boolean useDefaultExcludes;
    private boolean isCaseSensitive;
    private boolean followSymlinks;

    public void setRefid(Reference reference) throws BuildException {
        if (this.dir != null || this.defaultPatterns.hasPatterns(this.getProject())) {
            throw this.tooManyAttributes();
        }
        if (!this.additionalPatterns.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        if (!this.selectors.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(reference);
    }

    public void setDir(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.dir = file;
    }

    public File getDir(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getDir(project);
        }
        return this.dir;
    }

    public PatternSet createPatternSet() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PatternSet patternSet = new PatternSet();
        this.additionalPatterns.addElement(patternSet);
        return patternSet;
    }

    public PatternSet.NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createIncludesFile();
    }

    public PatternSet.NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createExcludesFile();
    }

    public void setFile(File file) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.setDir(file.getParentFile());
        PatternSet.NameEntry nameEntry = this.createInclude();
        nameEntry.setName(file.getName());
    }

    public void setIncludes(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludes(string);
    }

    public void setExcludes(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setExcludes(string);
    }

    public void setIncludesfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludesfile(file);
    }

    public void setExcludesfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setExcludesfile(file);
    }

    public void setDefaultexcludes(boolean bl) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.useDefaultExcludes = bl;
    }

    public void setCaseSensitive(boolean bl) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.isCaseSensitive = bl;
    }

    public void setFollowSymlinks(boolean bl) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.followSymlinks = bl;
    }

    public boolean isFollowSymlinks() {
        if (this.isReference()) {
            return this.getRef(this.getProject()).isFollowSymlinks();
        }
        return this.followSymlinks;
    }

    protected String getDataTypeName() {
        int n;
        Object object;
        Project project = this.getProject();
        if (project != null) {
            object = project.getDataTypeDefinitions();
            Enumeration enumeration = ((Hashtable)object).keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Class clazz = (Class)((Hashtable)object).get(string);
                if (clazz != this.getClass()) continue;
                return string;
            }
        }
        if ((n = ((String)(object = this.getClass().getName())).lastIndexOf(".")) == -1) {
            return object;
        }
        return ((String)object).substring(n + 1);
    }

    public DirectoryScanner getDirectoryScanner(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getDirectoryScanner(project);
        }
        if (this.dir == null) {
            throw new BuildException("No directory specified for " + this.getDataTypeName() + '.');
        }
        if (!this.dir.exists()) {
            throw new BuildException(this.dir.getAbsolutePath() + " not found.");
        }
        if (!this.dir.isDirectory()) {
            throw new BuildException(this.dir.getAbsolutePath() + " is not a directory.");
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        this.setupDirectoryScanner(directoryScanner, project);
        directoryScanner.setFollowSymlinks(this.followSymlinks);
        directoryScanner.scan();
        return directoryScanner;
    }

    public void setupDirectoryScanner(FileScanner fileScanner, Project project) {
        if (this.isReference()) {
            this.getRef(project).setupDirectoryScanner(fileScanner, project);
            return;
        }
        if (fileScanner == null) {
            throw new IllegalArgumentException("ds cannot be null");
        }
        fileScanner.setBasedir(this.dir);
        int n = this.additionalPatterns.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this.additionalPatterns.elementAt(n2);
            this.defaultPatterns.append((PatternSet)e, project);
            ++n2;
        }
        project.log(this.getDataTypeName() + ": Setup scanner in dir " + this.dir + " with " + this.defaultPatterns, 4);
        fileScanner.setIncludes(this.defaultPatterns.getIncludePatterns(project));
        fileScanner.setExcludes(this.defaultPatterns.getExcludePatterns(project));
        if (fileScanner instanceof SelectorScanner) {
            SelectorScanner selectorScanner = (SelectorScanner)((Object)fileScanner);
            selectorScanner.setSelectors(this.getSelectors(project));
        }
        if (this.useDefaultExcludes) {
            fileScanner.addDefaultExcludes();
        }
        fileScanner.setCaseSensitive(this.isCaseSensitive);
    }

    protected AbstractFileSet getRef(Project project) {
        Object object;
        if (!this.isChecked()) {
            object = new Stack<AbstractFileSet>();
            ((Stack)object).push(this);
            this.dieOnCircularReference((Stack)object, project);
        }
        object = this.getRefid().getReferencedObject(project);
        if (!this.getClass().isAssignableFrom(object.getClass())) {
            String string = this.getRefid().getRefId() + " doesn't denote a " + this.getDataTypeName();
            throw new BuildException(string);
        }
        return (AbstractFileSet)object;
    }

    public boolean hasSelectors() {
        if (this.isReference() && this.getProject() != null) {
            return this.getRef(this.getProject()).hasSelectors();
        }
        return this.selectors.isEmpty() ^ true;
    }

    public boolean hasPatterns() {
        if (this.isReference() && this.getProject() != null) {
            return this.getRef(this.getProject()).hasPatterns();
        }
        if (this.defaultPatterns.hasPatterns(this.getProject())) {
            return true;
        }
        Enumeration enumeration = this.additionalPatterns.elements();
        while (enumeration.hasMoreElements()) {
            PatternSet patternSet = (PatternSet)enumeration.nextElement();
            if (!patternSet.hasPatterns(this.getProject())) continue;
            return true;
        }
        return false;
    }

    public int selectorCount() {
        if (this.isReference() && this.getProject() != null) {
            return this.getRef(this.getProject()).selectorCount();
        }
        return this.selectors.size();
    }

    public FileSelector[] getSelectors(Project project) {
        if (this.isReference()) {
            return this.getRef(project).getSelectors(project);
        }
        Object[] objectArray = new FileSelector[this.selectors.size()];
        this.selectors.copyInto(objectArray);
        return objectArray;
    }

    public Enumeration selectorElements() {
        if (this.isReference() && this.getProject() != null) {
            return this.getRef(this.getProject()).selectorElements();
        }
        return this.selectors.elements();
    }

    public void appendSelector(FileSelector fileSelector) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.selectors.addElement(fileSelector);
    }

    public void addSelector(SelectSelector selectSelector) {
        this.appendSelector(selectSelector);
    }

    public void addAnd(AndSelector andSelector) {
        this.appendSelector(andSelector);
    }

    public void addOr(OrSelector orSelector) {
        this.appendSelector(orSelector);
    }

    public void addNot(NotSelector notSelector) {
        this.appendSelector(notSelector);
    }

    public void addNone(NoneSelector noneSelector) {
        this.appendSelector(noneSelector);
    }

    public void addMajority(MajoritySelector majoritySelector) {
        this.appendSelector(majoritySelector);
    }

    public void addDate(DateSelector dateSelector) {
        this.appendSelector(dateSelector);
    }

    public void addSize(SizeSelector sizeSelector) {
        this.appendSelector(sizeSelector);
    }

    public void addDifferent(DifferentSelector differentSelector) {
        this.appendSelector(differentSelector);
    }

    public void addFilename(FilenameSelector filenameSelector) {
        this.appendSelector(filenameSelector);
    }

    public void addType(TypeSelector typeSelector) {
        this.appendSelector(typeSelector);
    }

    public void addCustom(ExtendSelector extendSelector) {
        this.appendSelector(extendSelector);
    }

    public void addContains(ContainsSelector containsSelector) {
        this.appendSelector(containsSelector);
    }

    public void addPresent(PresentSelector presentSelector) {
        this.appendSelector(presentSelector);
    }

    public void addDepth(DepthSelector depthSelector) {
        this.appendSelector(depthSelector);
    }

    public void addDepend(DependSelector dependSelector) {
        this.appendSelector(dependSelector);
    }

    public void addContainsRegexp(ContainsRegexpSelector containsRegexpSelector) {
        this.appendSelector(containsRegexpSelector);
    }

    public void addModified(ModifiedSelector modifiedSelector) {
        this.appendSelector(modifiedSelector);
    }

    public void add(FileSelector fileSelector) {
        this.appendSelector(fileSelector);
    }

    public String toString() {
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        if (this.isReference()) {
            return this.getRef(this.getProject()).clone();
        }
        try {
            AbstractFileSet abstractFileSet = (AbstractFileSet)super.clone();
            abstractFileSet.defaultPatterns = (PatternSet)this.defaultPatterns.clone();
            abstractFileSet.additionalPatterns = new Vector(this.additionalPatterns.size());
            Enumeration enumeration = this.additionalPatterns.elements();
            while (enumeration.hasMoreElements()) {
                abstractFileSet.additionalPatterns.addElement(((PatternSet)enumeration.nextElement()).clone());
            }
            abstractFileSet.selectors = (Vector)abstractFileSet.selectors.clone();
            return abstractFileSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new BuildException(cloneNotSupportedException);
        }
    }

    private final /* synthetic */ void this() {
        this.defaultPatterns = new PatternSet();
        this.additionalPatterns = new Vector();
        this.selectors = new Vector();
        this.useDefaultExcludes = true;
        this.isCaseSensitive = true;
        this.followSymlinks = true;
    }

    public AbstractFileSet() {
        this.this();
    }

    protected AbstractFileSet(AbstractFileSet abstractFileSet) {
        this.this();
        this.dir = abstractFileSet.dir;
        this.defaultPatterns = abstractFileSet.defaultPatterns;
        this.additionalPatterns = abstractFileSet.additionalPatterns;
        this.selectors = abstractFileSet.selectors;
        this.useDefaultExcludes = abstractFileSet.useDefaultExcludes;
        this.isCaseSensitive = abstractFileSet.isCaseSensitive;
        this.followSymlinks = abstractFileSet.followSymlinks;
        this.setProject(abstractFileSet.getProject());
    }
}

