/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.compilers;

import java.io.File;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class DefaultCompilerAdapter
implements CompilerAdapter {
    protected static final String lSep = System.getProperty("line.separator");
    protected Path src;
    protected File destDir;
    protected String encoding;
    protected boolean debug;
    protected boolean optimize;
    protected boolean deprecation;
    protected boolean depend;
    protected boolean verbose;
    protected String target;
    protected Path bootclasspath;
    protected Path extdirs;
    protected Path compileClasspath;
    protected Path compileSourcepath;
    protected Project project;
    protected Location location;
    protected boolean includeAntRuntime;
    protected boolean includeJavaRuntime;
    protected String memoryInitialSize;
    protected String memoryMaximumSize;
    protected File[] compileList;
    protected Javac attributes;
    private FileUtils fileUtils;

    public void setJavac(Javac javac) {
        this.attributes = javac;
        this.src = javac.getSrcdir();
        this.destDir = javac.getDestdir();
        this.encoding = javac.getEncoding();
        this.debug = javac.getDebug();
        this.optimize = javac.getOptimize();
        this.deprecation = javac.getDeprecation();
        this.depend = javac.getDepend();
        this.verbose = javac.getVerbose();
        this.target = javac.getTarget();
        this.bootclasspath = javac.getBootclasspath();
        this.extdirs = javac.getExtdirs();
        this.compileList = javac.getFileList();
        this.compileClasspath = javac.getClasspath();
        this.compileSourcepath = javac.getSourcepath();
        this.project = javac.getProject();
        this.location = javac.getLocation();
        this.includeAntRuntime = javac.getIncludeantruntime();
        this.includeJavaRuntime = javac.getIncludejavaruntime();
        this.memoryInitialSize = javac.getMemoryInitialSize();
        this.memoryMaximumSize = javac.getMemoryMaximumSize();
    }

    public Javac getJavac() {
        return this.attributes;
    }

    protected Project getProject() {
        return this.project;
    }

    protected Path getCompileClasspath() {
        Path path;
        Path path2 = new Path(this.project);
        if (this.destDir != null) {
            path2.setLocation(this.destDir);
        }
        if ((path = this.compileClasspath) == null) {
            path = new Path(this.project);
        }
        if (this.includeAntRuntime) {
            path2.addExisting(path.concatSystemClasspath("last"));
        } else {
            path2.addExisting(path.concatSystemClasspath("ignore"));
        }
        if (this.includeJavaRuntime) {
            path2.addJavaRuntime();
        }
        return path2;
    }

    protected Commandline setupJavacCommandlineSwitches(Commandline commandline) {
        return this.setupJavacCommandlineSwitches(commandline, false);
    }

    protected Commandline setupJavacCommandlineSwitches(Commandline commandline, boolean bl) {
        Object object;
        String string;
        Path path = this.getCompileClasspath();
        Path path2 = null;
        path2 = this.compileSourcepath != null ? this.compileSourcepath : this.src;
        String string2 = string = this.assumeJava11() ? "-J-" : "-J-X";
        if (this.memoryInitialSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log("Since fork is false, ignoring memoryInitialSize setting.", 1);
            } else {
                commandline.createArgument().setValue(string + "ms" + this.memoryInitialSize);
            }
        }
        if (this.memoryMaximumSize != null) {
            if (!this.attributes.isForkedJavac()) {
                this.attributes.log("Since fork is false, ignoring memoryMaximumSize setting.", 1);
            } else {
                commandline.createArgument().setValue(string + "mx" + this.memoryMaximumSize);
            }
        }
        if (this.attributes.getNowarn()) {
            commandline.createArgument().setValue("-nowarn");
        }
        if (this.deprecation) {
            commandline.createArgument().setValue("-deprecation");
        }
        if (this.destDir != null) {
            commandline.createArgument().setValue("-d");
            commandline.createArgument().setFile(this.destDir);
        }
        commandline.createArgument().setValue("-classpath");
        if (this.assumeJava11()) {
            object = new Path(this.project);
            if (this.bootclasspath != null) {
                ((Path)object).append(this.bootclasspath);
            }
            if (this.extdirs != null) {
                ((Path)object).addExtdirs(this.extdirs);
            }
            ((Path)object).append(path);
            ((Path)object).append(path2);
            commandline.createArgument().setPath((Path)object);
        } else {
            commandline.createArgument().setPath(path);
            if (path2.size() > 0) {
                commandline.createArgument().setValue("-sourcepath");
                commandline.createArgument().setPath(path2);
            }
            if (this.target != null) {
                commandline.createArgument().setValue("-target");
                commandline.createArgument().setValue(this.target);
            }
            if (this.bootclasspath != null && this.bootclasspath.size() > 0) {
                commandline.createArgument().setValue("-bootclasspath");
                commandline.createArgument().setPath(this.bootclasspath);
            }
            if (this.extdirs != null && this.extdirs.size() > 0) {
                commandline.createArgument().setValue("-extdirs");
                commandline.createArgument().setPath(this.extdirs);
            }
        }
        if (this.encoding != null) {
            commandline.createArgument().setValue("-encoding");
            commandline.createArgument().setValue(this.encoding);
        }
        if (this.debug) {
            if (bl && !this.assumeJava11()) {
                object = this.attributes.getDebugLevel();
                if (object != null) {
                    commandline.createArgument().setValue("-g:" + (String)object);
                } else {
                    commandline.createArgument().setValue("-g");
                }
            } else {
                commandline.createArgument().setValue("-g");
            }
        } else if (!this.assumeJava11()) {
            commandline.createArgument().setValue("-g:none");
        }
        if (this.optimize) {
            commandline.createArgument().setValue("-O");
        }
        if (this.depend) {
            if (this.assumeJava11()) {
                commandline.createArgument().setValue("-depend");
            } else if (this.assumeJava12()) {
                commandline.createArgument().setValue("-Xdepend");
            } else {
                this.attributes.log("depend attribute is not supported by the modern compiler", 1);
            }
        }
        if (this.verbose) {
            commandline.createArgument().setValue("-verbose");
        }
        this.addCurrentCompilerArgs(commandline);
        return commandline;
    }

    protected Commandline setupModernJavacCommandlineSwitches(Commandline commandline) {
        this.setupJavacCommandlineSwitches(commandline, true);
        if (this.attributes.getSource() != null && !this.assumeJava13()) {
            commandline.createArgument().setValue("-source");
            commandline.createArgument().setValue(this.attributes.getSource());
        }
        return commandline;
    }

    protected Commandline setupModernJavacCommand() {
        Commandline commandline = new Commandline();
        this.setupModernJavacCommandlineSwitches(commandline);
        this.logAndAddFilesToCompile(commandline);
        return commandline;
    }

    protected Commandline setupJavacCommand() {
        return this.setupJavacCommand(false);
    }

    protected Commandline setupJavacCommand(boolean bl) {
        Commandline commandline = new Commandline();
        this.setupJavacCommandlineSwitches(commandline, bl);
        this.logAndAddFilesToCompile(commandline);
        return commandline;
    }

    protected void logAndAddFilesToCompile(Commandline commandline) {
        this.attributes.log("Compilation " + commandline.describeArguments(), 3);
        StringBuffer stringBuffer = new StringBuffer("File");
        if (this.compileList.length != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(" to be compiled:");
        stringBuffer.append(lSep);
        int n = 0;
        while (n < this.compileList.length) {
            String string = this.compileList[n].getAbsolutePath();
            commandline.createArgument().setValue(string);
            stringBuffer.append("    " + string + lSep);
            ++n;
        }
        this.attributes.log(stringBuffer.toString(), 3);
    }

    protected int executeExternalCompile(String[] stringArray, int n) {
        return this.executeExternalCompile(stringArray, n, true);
    }

    /*
     * Exception decompiling
     */
    protected int executeExternalCompile(String[] var1_1, int var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 282->288)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void addExtdirsToClasspath(Path path) {
        path.addExtdirs(this.extdirs);
    }

    protected void addCurrentCompilerArgs(Commandline commandline) {
        commandline.addArguments(this.getJavac().getCurrentCompilerArgs());
    }

    protected boolean assumeJava11() {
        boolean bl = false;
        if ("javac1.1".equals(this.attributes.getCompilerVersion()) || "classic".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.1") || "extJavac".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.1")) {
            bl = true;
        }
        return bl;
    }

    protected boolean assumeJava12() {
        boolean bl = false;
        if ("javac1.2".equals(this.attributes.getCompilerVersion()) || "classic".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.2") || "extJavac".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.2")) {
            bl = true;
        }
        return bl;
    }

    protected boolean assumeJava13() {
        boolean bl = false;
        if ("javac1.3".equals(this.attributes.getCompilerVersion()) || "classic".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.3") || "modern".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.3") || "extJavac".equals(this.attributes.getCompilerVersion()) && JavaEnvUtils.isJavaVersion("1.3")) {
            bl = true;
        }
        return bl;
    }

    private final /* synthetic */ void this() {
        this.debug = false;
        this.optimize = false;
        this.deprecation = false;
        this.depend = false;
        this.verbose = false;
        this.fileUtils = FileUtils.newFileUtils();
    }

    public DefaultCompilerAdapter() {
        this.this();
    }
}

