/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CopyOnWriteCollection
extends AbstractCollection {
    private static int DEF_INIT_CAPACITY = 5;
    private Object[] objects;
    private int size;

    public CopyOnWriteCollection() {
        this(DEF_INIT_CAPACITY);
    }

    public CopyOnWriteCollection(int n) {
        if (n < 0) {
            n = DEF_INIT_CAPACITY;
        }
        this.objects = new Object[n];
    }

    public int size() {
        return this.size;
    }

    public Iterator iterator() {
        return new Itr(this.objects, this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        Object[] objectArray = this.objects;
        synchronized (this.objects) {
            int n = this.objects.length;
            if (this.size() < n) {
                this.objects[this.size] = object;
            } else {
                Object[] objectArray2 = new Object[n * 3 / 2 + DEF_INIT_CAPACITY];
                System.arraycopy(this.objects, 0, objectArray2, 0, n);
                objectArray2[n] = object;
                this.objects = objectArray2;
            }
            ++this.size;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        Object[] objectArray = this.objects;
        synchronized (this.objects) {
            for (int i = 0; i < this.size; ++i) {
                if (!(object == null ? this.objects[i] == null : object.equals(this.objects[i]))) continue;
                Object[] objectArray2 = new Object[this.objects.length];
                System.arraycopy(this.objects, 0, objectArray2, 0, i);
                System.arraycopy(this.objects, i + 1, objectArray2, i, this.size - i - 1);
                --this.size;
                this.objects = objectArray2;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        Object[] objectArray = this.objects;
        synchronized (this.objects) {
            boolean bl = false;
            for (int i = 0; i < this.size; ++i) {
                if (!collection.contains(this.objects[i])) continue;
                this.remove(this.objects[i]);
                bl = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object[] objectArray = this.objects;
        synchronized (this.objects) {
            this.objects = new Object[this.objects.length];
            this.size = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static class Itr
    implements Iterator {
        private Object[] objs;
        private int cursor = 0;
        private int currentSize = 0;

        private Itr(Object[] objectArray, int n) {
            this.objs = objectArray;
            this.currentSize = n;
        }

        public boolean hasNext() {
            return this.cursor != this.currentSize;
        }

        public Object next() {
            if (this.cursor < this.currentSize) {
                return this.objs[this.cursor++];
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

