/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.zrtp.packets;

import gnu.java.zrtp.ZrtpConstants;
import gnu.java.zrtp.packets.ZrtpPacketBase;
import gnu.java.zrtp.utils.ZrtpUtils;

public class ZrtpPacketSASRelay
extends ZrtpPacketBase {
    private static final int ZRTP_SAS_RELAY_FIXED_LENGTH = 16;
    private static final int HMAC_OFFSET = 12;
    private static final int IV_OFFSET = 20;
    private static final int FILLER_OFFSET = 36;
    private static final int SIG_LENGTH_OFFSET = 38;
    private static final int FLAGS_OFFSET = 39;
    private static final int SAS_OFFSET = 40;
    private static final int TRUSTED_SAS_OFFSET = 44;
    private static final int SIG_DATA_OFFSET = 76;
    private static final int CONFIRM_FIXED_LENGTH = 80;
    private int signatureLength;

    public ZrtpPacketSASRelay() {
        super(null);
        this.setSignatureLength(0);
        this.setMessageType(ZrtpConstants.SASRelayMsg);
    }

    public ZrtpPacketSASRelay(int sl) {
        super(null);
        this.setSignatureLength(sl);
        this.setMessageType(ZrtpConstants.SASRelayMsg);
    }

    public final void setSignatureLength(int sl) {
        if (sl > 512) {
            return;
        }
        this.signatureLength = sl;
        int length = 80 + sl * 4;
        if (this.packetBuffer == null) {
            this.packetBuffer = new byte[length];
        } else {
            byte[] tmp = new byte[length];
            System.arraycopy(this.packetBuffer, 0, tmp, 0, 76);
            this.packetBuffer = tmp;
        }
        this.packetBuffer[38] = (byte)sl;
        if (sl > 255) {
            this.packetBuffer[37] = 1;
        }
        this.setLength((length - 4) / 4);
        this.setZrtpId();
    }

    public ZrtpPacketSASRelay(byte[] data) {
        super(data);
        this.signatureLength = this.packetBuffer[38] & 0xFF;
        if (this.packetBuffer[37] == 1) {
            this.signatureLength |= 0x100;
        }
    }

    public final boolean isSASFlag() {
        return (this.packetBuffer[39] & 4) == 4;
    }

    public final byte[] getIv() {
        return ZrtpUtils.readRegion(this.packetBuffer, 20, 16);
    }

    public final byte[] getHmac() {
        return ZrtpUtils.readRegion(this.packetBuffer, 12, 8);
    }

    public ZrtpConstants.SupportedSASTypes getSas() {
        for (ZrtpConstants.SupportedSASTypes sh : ZrtpConstants.SupportedSASTypes.values()) {
            byte[] s = sh.name;
            if (s[0] != this.packetBuffer[40] || s[1] != this.packetBuffer[41] || s[2] != this.packetBuffer[42] || s[3] != this.packetBuffer[43]) continue;
            return sh;
        }
        return null;
    }

    public final byte[] getTrustedSas() {
        return ZrtpUtils.readRegion(this.packetBuffer, 44, 32);
    }

    public final byte[] getDataToSecure() {
        int length = (this.getLength() - 9) * 4;
        return ZrtpUtils.readRegion(this.packetBuffer, 36, length);
    }

    public final byte[] getSignatureData() {
        return ZrtpUtils.readRegion(this.packetBuffer, 76, this.signatureLength);
    }

    public final int getSignatureLength() {
        return this.signatureLength;
    }

    public final boolean isLengthOk() {
        return this.getLength() >= 19;
    }

    public final void setSASFlag() {
        this.packetBuffer[39] = (byte)(this.packetBuffer[39] | 4);
    }

    public final void setHmac(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 12, 8);
    }

    public final void setIv(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 20, 16);
    }

    public final void setSasType(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 40, 4);
    }

    public final void setTrustedSas(byte[] data) {
        System.arraycopy(data, 0, this.packetBuffer, 44, 32);
    }

    public final void setDataToSecure(byte[] data) {
        int length = (this.getLength() - 9) * 4;
        System.arraycopy(data, 0, this.packetBuffer, 36, length);
    }

    public final void setSignatureData(byte[] data) {
        if (data.length > this.signatureLength) {
            return;
        }
        System.arraycopy(data, 0, this.packetBuffer, 76, data.length);
    }

    public static void main(String[] args) {
        ZrtpPacketSASRelay pkt = new ZrtpPacketSASRelay(0);
        System.err.println("SAS relay length: " + pkt.getLength());
        pkt.setSASFlag();
        System.err.println("packetBuffer length in bytes: " + pkt.getHeaderBase().length);
        ZrtpUtils.hexdump("SAS relay packet", pkt.getHeaderBase(), pkt.getHeaderBase().length);
        pkt = new ZrtpPacketSASRelay();
        pkt.setSignatureLength(150);
        System.err.println("SAS Relay length: " + pkt.getLength());
        pkt.setSASFlag();
        System.err.println("packetBuffer length in bytes: " + pkt.getHeaderBase().length);
        System.err.println("Signature length in words: " + pkt.getSignatureLength());
        ZrtpUtils.hexdump("SAS relay packet", pkt.getHeaderBase(), pkt.getHeaderBase().length);
    }
}

