/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.AudioSilenceMediaDevice;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.RTCPFeedbackMessageSender;
import org.jitsi.videobridge.Videobridge;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Content
implements RTPTranslator.WriteFilter {
    private static final Logger logger = Logger.getLogger(Content.class);
    private final Map<String, Channel> channels = new HashMap<String, Channel>();
    private final Conference conference;
    private boolean expired = false;
    private long lastActivityTime;
    private final MediaType mediaType;
    private MediaDevice mixer;
    private final String name;
    private RTCPFeedbackMessageSender rtcpFeedbackMessageSender;
    private final Object rtpLevelRelaySyncRoot = new Object();
    private RTPTranslator rtpTranslator;

    private static void logd(String s) {
        logger.info((Object)s);
    }

    public Content(Conference conference, String name) {
        if (conference == null) {
            throw new NullPointerException("conference");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.conference = conference;
        this.name = name;
        this.mediaType = MediaType.parseString((String)this.name);
        this.touch();
    }

    public boolean accept(MediaStream source, byte[] buffer, int offset, int length, MediaStream destination, boolean data) {
        Channel dst;
        boolean accept = true;
        if (destination != null && (dst = Channel.getChannel(destination)) != null) {
            Channel src = source == null ? null : Channel.getChannel(source);
            accept = dst.rtpTranslatorWillWrite(data, buffer, offset, length, src);
        }
        return accept;
    }

    void askForKeyframes(Set<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            for (Channel channel : endpoint.getChannels(MediaType.VIDEO)) {
                channel.askForKeyframes();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel createChannel() throws Exception {
        Channel channel = null;
        do {
            String id = this.generateChannelID();
            Map<String, Channel> map = this.channels;
            synchronized (map) {
                if (!this.channels.containsKey(id)) {
                    channel = new Channel(this, id);
                    this.channels.put(id, channel);
                }
            }
        } while (channel == null);
        Conference conference = this.getConference();
        Videobridge videobridge = conference.getVideobridge();
        Content.logd("Created channel " + channel.getID() + " of content " + this.getName() + " of conference " + conference.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        Content content = this;
        synchronized (content) {
            if (this.expired) {
                return;
            }
            this.expired = true;
        }
        Conference conference = this.getConference();
        try {
            conference.expireContent(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            for (Channel channel : this.getChannels()) {
                try {
                    channel.expire();
                }
                catch (Throwable t) {
                    logger.warn((Object)("Failed to expire channel " + channel.getID() + " of content " + this.getName() + " of conference " + conference.getID() + "!"), t);
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
            Object object = this.rtpLevelRelaySyncRoot;
            synchronized (object) {
                if (this.rtpTranslator != null) {
                    this.rtpTranslator.dispose();
                }
                this.rtcpFeedbackMessageSender = null;
            }
            Videobridge videobridge = conference.getVideobridge();
            Content.logd("Expired content " + this.getName() + " of conference " + conference.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
            throw throwable;
        }
        for (Channel channel : this.getChannels()) {
            try {
                channel.expire();
            }
            catch (Throwable t) {
                logger.warn((Object)("Failed to expire channel " + channel.getID() + " of content " + this.getName() + " of conference " + conference.getID() + "!"), t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        Object object = this.rtpLevelRelaySyncRoot;
        synchronized (object) {
            if (this.rtpTranslator != null) {
                this.rtpTranslator.dispose();
            }
            this.rtcpFeedbackMessageSender = null;
        }
        Videobridge videobridge = conference.getVideobridge();
        Content.logd("Expired content " + this.getName() + " of conference " + conference.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireChannel(Channel channel) {
        boolean expireChannel;
        String id = channel.getID();
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            if (channel.equals(this.channels.get(id))) {
                this.channels.remove(id);
                expireChannel = true;
            } else {
                expireChannel = false;
            }
        }
        if (expireChannel) {
            channel.expire();
        }
    }

    private String generateChannelID() {
        return Long.toHexString(System.currentTimeMillis() + Videobridge.RANDOM.nextLong());
    }

    Channel findChannelByReceiveSSRC(long receiveSSRC) {
        for (Channel channel : this.getChannels()) {
            for (int channelReceiveSSRC : channel.getReceiveSSRCs()) {
                if (receiveSSRC != (0xFFFFFFFFL & (long)channelReceiveSSRC)) continue;
                return channel;
            }
        }
        return null;
    }

    public BundleContext getBundleContext() {
        return this.getConference().getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(String id) {
        Channel channel;
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            channel = this.channels.get(id);
        }
        if (channel != null) {
            channel.touch();
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChannelCount() {
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            return this.channels.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel[] getChannels() {
        Map<String, Channel> map = this.channels;
        synchronized (map) {
            Collection<Channel> values = this.channels.values();
            return values.toArray(new Channel[values.size()]);
        }
    }

    public final Conference getConference() {
        return this.conference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        Content content = this;
        synchronized (content) {
            return this.lastActivityTime;
        }
    }

    MediaService getMediaService() {
        MediaService mediaService = (MediaService)ServiceUtils.getService((BundleContext)this.getBundleContext(), MediaService.class);
        if (mediaService == null) {
            mediaService = LibJitsi.getMediaService();
        }
        return mediaService;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public MediaDevice getMixer() {
        if (this.mixer == null) {
            MediaType mediaType = this.getMediaType();
            AudioSilenceMediaDevice device = MediaType.AUDIO.equals((Object)mediaType) ? new AudioSilenceMediaDevice() : null;
            if (device == null) {
                throw new UnsupportedOperationException("The mixer type of RTP-level relay is not supported for " + mediaType);
            }
            this.mixer = this.getMediaService().createMixer((MediaDevice)device);
        }
        return this.mixer;
    }

    public final String getName() {
        return this.name;
    }

    RTCPFeedbackMessageSender getRTCPFeedbackMessageSender() {
        return this.rtcpFeedbackMessageSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RTPTranslator getRTPTranslator() {
        Object object = this.rtpLevelRelaySyncRoot;
        synchronized (object) {
            if (this.rtpTranslator == null) {
                this.rtpTranslator = this.getMediaService().createRTPTranslator();
                if (this.rtpTranslator != null) {
                    new RTPTranslatorWriteFilter(this.rtpTranslator, this);
                    if (this.rtpTranslator instanceof RTPTranslatorImpl) {
                        this.rtcpFeedbackMessageSender = new RTCPFeedbackMessageSender((RTPTranslatorImpl)this.rtpTranslator);
                    }
                }
            }
            return this.rtpTranslator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        long now = System.currentTimeMillis();
        Content content = this;
        synchronized (content) {
            if (this.getLastActivityTime() < now) {
                this.lastActivityTime = now;
            }
        }
    }

    private static class RTPTranslatorWriteFilter
    implements RTPTranslator.WriteFilter {
        private final WeakReference<RTPTranslator> rtpTranslator;
        private final WeakReference<RTPTranslator.WriteFilter> writeFilter;

        public RTPTranslatorWriteFilter(RTPTranslator rtpTranslator, RTPTranslator.WriteFilter writeFilter) {
            this.rtpTranslator = new WeakReference<RTPTranslator>(rtpTranslator);
            this.writeFilter = new WeakReference<RTPTranslator.WriteFilter>(writeFilter);
            rtpTranslator.addWriteFilter((RTPTranslator.WriteFilter)this);
        }

        public boolean accept(MediaStream source, byte[] buffer, int offset, int length, MediaStream destination, boolean data) {
            RTPTranslator.WriteFilter writeFilter = (RTPTranslator.WriteFilter)this.writeFilter.get();
            boolean accept = true;
            if (writeFilter == null) {
                RTPTranslator rtpTranslator = (RTPTranslator)this.rtpTranslator.get();
                if (rtpTranslator != null) {
                    rtpTranslator.removeWriteFilter((RTPTranslator.WriteFilter)this);
                }
            } else {
                accept = writeFilter.accept(source, buffer, offset, length, destination, data);
            }
            return accept;
        }
    }
}

