/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.zrtp;

import gnu.java.zrtp.ZRtp;
import gnu.java.zrtp.ZrtpCallback;
import gnu.java.zrtp.ZrtpCodes;
import gnu.java.zrtp.ZrtpConfigure;
import gnu.java.zrtp.ZrtpConstants;
import gnu.java.zrtp.ZrtpSrtpSecrets;
import gnu.java.zrtp.ZrtpStateClass;
import gnu.java.zrtp.utils.ZrtpFortuna;
import gnu.java.zrtp.zidfile.ZidFile;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Timer;
import java.util.TimerTask;
import org.jitsi.impl.neomedia.AbstractRTPConnector;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTCPTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTPContextFactory;
import org.jitsi.impl.neomedia.transform.srtp.SRTPPolicy;
import org.jitsi.impl.neomedia.transform.srtp.SRTPTransformer;
import org.jitsi.impl.neomedia.transform.zrtp.SecurityEventManager;
import org.jitsi.impl.neomedia.transform.zrtp.ZRTCPTransformer;
import org.jitsi.impl.neomedia.transform.zrtp.ZrtpRawPacket;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.util.Logger;

public class ZRTPTransformEngine
extends SinglePacketTransformer
implements SrtpControl.TransformEngine,
ZrtpCallback {
    private static final Logger logger = Logger.getLogger(ZRTPTransformEngine.class);
    protected static final int ZRTP_PACKET_HEADER = 12;
    private AbstractRTPConnector zrtpConnector = null;
    private SRTPTransformer srtpOutTransformer = null;
    private SRTPTransformer srtpInTransformer = null;
    private SecurityEventManager securityEventManager = null;
    private ZRtp zrtpEngine = null;
    private boolean enableZrtp = false;
    private String clientIdString = "GNU ZRTP4J 3.1.0";
    private int ownSSRC = 0;
    private short senderZrtpSeqNo = 0;
    private TimeoutProvider timeoutProvider = null;
    private boolean started = false;
    private boolean muted = false;
    private boolean mitmMode = false;
    private boolean enableParanoidMode = false;
    private ZRTCPTransformer zrtcpTransformer = null;
    private long zrtpUnprotect;
    private boolean disposed = false;

    public ZRTPTransformEngine() {
        ZrtpFortuna secRand = ZrtpFortuna.getInstance();
        byte[] random = new byte[2];
        secRand.nextBytes(random);
        this.senderZrtpSeqNo = random[0];
        this.senderZrtpSeqNo = (short)(this.senderZrtpSeqNo | random[1] << 8);
        this.senderZrtpSeqNo = (short)(this.senderZrtpSeqNo & Short.MAX_VALUE);
    }

    @Override
    public ZRTCPTransformer getRTCPTransformer() {
        if (this.zrtcpTransformer == null && !this.disposed) {
            this.zrtcpTransformer = new ZRTCPTransformer();
        }
        return this.zrtcpTransformer;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    public boolean initialize(String zidFilename, ZrtpConfigure config) {
        return this.initialize(zidFilename, true, config);
    }

    public boolean initialize(String zidFilename, boolean autoEnable) {
        return this.initialize(zidFilename, autoEnable, null);
    }

    public boolean initialize(String zidFilename) {
        return this.initialize(zidFilename, true, null);
    }

    public synchronized boolean initialize(String zidFilename, boolean autoEnable, ZrtpConfigure config) {
        String zidFilePath;
        block12: {
            File file = null;
            FileAccessService faService = LibJitsi.getFileAccessService();
            if (faService != null) {
                try {
                    file = faService.getPrivatePersistentFile(zidFilename, FileCategory.PROFILE);
                }
                catch (Exception e) {
                    logger.warn("Failed to create the zid file.");
                }
            }
            zidFilePath = null;
            try {
                if (file != null) {
                    zidFilePath = file.getAbsolutePath();
                }
            }
            catch (SecurityException e) {
                if (!logger.isDebugEnabled()) break block12;
                logger.debug("Failed to obtain the absolute path of the zid file.", e);
            }
        }
        ZidFile zf = ZidFile.getInstance();
        if (!zf.isOpen()) {
            if (zidFilePath == null) {
                String home = System.getenv("HOME");
                String baseDir = home == null || home.length() < 1 ? "" : home + "/";
                zidFilePath = baseDir + ".GNUZRTP4J.zid";
            }
            if (zf.open(zidFilePath) < 0) {
                return false;
            }
        }
        if (config == null) {
            config = new ZrtpConfigure();
            config.setStandardConfig();
        }
        if (this.enableParanoidMode) {
            config.setParanoidMode(this.enableParanoidMode);
        }
        this.zrtpEngine = new ZRtp(zf.getZid(), (ZrtpCallback)this, this.clientIdString, config, this.mitmMode);
        if (this.timeoutProvider == null) {
            this.timeoutProvider = new TimeoutProvider("ZRTP");
            this.timeoutProvider.start();
        }
        this.enableZrtp = autoEnable;
        return true;
    }

    public void setStartMuted(boolean startMuted) {
        this.muted = startMuted;
        if (startMuted) {
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    ZRTPTransformEngine.this.muted = false;
                }
            }, 1500L);
        }
    }

    public boolean getSecureCommunicationStatus() {
        return this.srtpInTransformer != null || this.srtpOutTransformer != null;
    }

    public void startZrtp() {
        if (this.zrtpEngine != null) {
            this.zrtpEngine.startZrtpEngine();
            this.started = true;
            this.securityEventManager.securityNegotiationStarted();
        }
    }

    @Override
    public void close() {
        this.stopZrtp();
    }

    public void stopZrtp() {
        if (this.zrtpEngine != null) {
            if (this.zrtpUnprotect < 10L) {
                this.zrtpEngine.setRs2Valid();
            }
            this.zrtpEngine.stopZrtp();
            this.zrtpEngine = null;
            this.started = false;
        }
        if (this.srtpOutTransformer != null) {
            this.srtpOutTransformer.close();
            this.srtpOutTransformer = null;
        }
        if (this.srtpInTransformer != null) {
            this.srtpInTransformer.close();
            this.srtpOutTransformer = null;
        }
        if (this.zrtcpTransformer != null) {
            this.zrtcpTransformer.close();
            this.zrtcpTransformer = null;
        }
    }

    @Override
    public void cleanup() {
        this.disposed = true;
        this.stopZrtp();
        if (this.timeoutProvider != null) {
            this.timeoutProvider.stopRun();
            this.timeoutProvider = null;
        }
    }

    public void setOwnSSRC(long ssrc) {
        this.ownSSRC = (int)(ssrc & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        if (!ZrtpRawPacket.isZrtpData(pkt)) {
            if (this.enableZrtp && this.ownSSRC == 0) {
                this.ownSSRC = pkt.getSSRC();
            }
            if (this.srtpOutTransformer != null) {
                pkt = this.srtpOutTransformer.transform(pkt);
            }
        }
        return pkt;
    }

    @Override
    public RawPacket reverseTransform(RawPacket pkt) {
        if (!this.started && this.enableZrtp && this.ownSSRC != 0) {
            this.startZrtp();
        }
        if (!ZrtpRawPacket.isZrtpData(pkt)) {
            if (this.srtpInTransformer == null) {
                return this.muted ? null : pkt;
            }
            RawPacket pkt2 = this.srtpInTransformer.reverseTransform(pkt);
            if (pkt2 != null && this.started && this.zrtpEngine.inState(ZrtpStateClass.ZrtpStates.WaitConfAck)) {
                this.zrtpEngine.conf2AckSecure();
            }
            if (pkt2 != null) {
                ++this.zrtpUnprotect;
            }
            return pkt2;
        }
        if (this.enableZrtp && this.started) {
            ZrtpRawPacket zPkt = new ZrtpRawPacket(pkt);
            if (!zPkt.checkCrc()) {
                this.securityEventManager.showMessage(ZrtpCodes.MessageSeverity.Warning, EnumSet.of(ZrtpCodes.WarningCodes.WarningCRCmismatch));
            } else if (zPkt.hasMagic()) {
                int extHeaderOffset = zPkt.getHeaderLength() - zPkt.getExtensionLength() - 4;
                byte[] extHeader = zPkt.readRegion(extHeaderOffset, 4 + zPkt.getExtensionLength() + zPkt.getPayloadLength());
                this.zrtpEngine.processZrtpMessage(extHeader, zPkt.getSSRC());
            }
        }
        return null;
    }

    public boolean sendDataZRTP(byte[] data) {
        int totalLength = 12 + data.length;
        byte[] tmp = new byte[totalLength];
        System.arraycopy(data, 0, tmp, 12, data.length);
        ZrtpRawPacket packet = new ZrtpRawPacket(tmp, 0, tmp.length);
        packet.setSSRC(this.ownSSRC);
        short s = this.senderZrtpSeqNo;
        this.senderZrtpSeqNo = (short)(s + 1);
        packet.setSeqNum(s);
        packet.setCrc();
        try {
            this.zrtpConnector.getDataOutputStream().write(packet.getBuffer(), packet.getOffset(), packet.getLength());
        }
        catch (IOException e) {
            logger.warn("Failed to send ZRTP data.");
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to send ZRTP data.", e);
            }
            return false;
        }
        return true;
    }

    public boolean srtpSecretsReady(ZrtpSrtpSecrets secrets, ZrtpCallback.EnableSecurity part) {
        SRTPPolicy srtpPolicy = null;
        int cipher = 0;
        int authn = 0;
        int authKeyLen = 0;
        if (secrets.getAuthAlgorithm() == ZrtpConstants.SupportedAuthAlgos.HS) {
            authn = 1;
            authKeyLen = 20;
        } else if (secrets.getAuthAlgorithm() == ZrtpConstants.SupportedAuthAlgos.SK) {
            authn = 2;
            authKeyLen = 32;
        }
        if (secrets.getSymEncAlgorithm() == ZrtpConstants.SupportedSymAlgos.AES) {
            cipher = 1;
        } else if (secrets.getSymEncAlgorithm() == ZrtpConstants.SupportedSymAlgos.TwoFish) {
            cipher = 3;
        }
        if (part == ZrtpCallback.EnableSecurity.ForSender) {
            if (secrets.getRole() == ZrtpCallback.Role.Initiator) {
                srtpPolicy = new SRTPPolicy(cipher, secrets.getInitKeyLen() / 8, authn, authKeyLen, secrets.getSrtpAuthTagLen() / 8, secrets.getInitSaltLen() / 8);
                SRTPContextFactory engine = new SRTPContextFactory(true, secrets.getKeyInitiator(), secrets.getSaltInitiator(), srtpPolicy, srtpPolicy);
                this.srtpOutTransformer = new SRTPTransformer(engine);
                this.getRTCPTransformer().setSrtcpOut(new SRTCPTransformer(engine));
            } else {
                srtpPolicy = new SRTPPolicy(cipher, secrets.getRespKeyLen() / 8, authn, authKeyLen, secrets.getSrtpAuthTagLen() / 8, secrets.getRespSaltLen() / 8);
                SRTPContextFactory engine = new SRTPContextFactory(true, secrets.getKeyResponder(), secrets.getSaltResponder(), srtpPolicy, srtpPolicy);
                this.srtpOutTransformer = new SRTPTransformer(engine);
                this.getRTCPTransformer().setSrtcpOut(new SRTCPTransformer(engine));
            }
        } else if (part == ZrtpCallback.EnableSecurity.ForReceiver) {
            if (secrets.getRole() == ZrtpCallback.Role.Initiator) {
                srtpPolicy = new SRTPPolicy(cipher, secrets.getRespKeyLen() / 8, authn, authKeyLen, secrets.getSrtpAuthTagLen() / 8, secrets.getRespSaltLen() / 8);
                SRTPContextFactory engine = new SRTPContextFactory(false, secrets.getKeyResponder(), secrets.getSaltResponder(), srtpPolicy, srtpPolicy);
                this.srtpInTransformer = new SRTPTransformer(engine);
                this.getRTCPTransformer().setSrtcpIn(new SRTCPTransformer(engine));
                this.muted = false;
            } else {
                srtpPolicy = new SRTPPolicy(cipher, secrets.getInitKeyLen() / 8, authn, authKeyLen, secrets.getSrtpAuthTagLen() / 8, secrets.getInitSaltLen() / 8);
                SRTPContextFactory engine = new SRTPContextFactory(false, secrets.getKeyInitiator(), secrets.getSaltInitiator(), srtpPolicy, srtpPolicy);
                this.srtpInTransformer = new SRTPTransformer(engine);
                this.getRTCPTransformer().setSrtcpIn(new SRTCPTransformer(engine));
                this.muted = false;
            }
        }
        return true;
    }

    public void srtpSecretsOn(String c, String s, boolean verified) {
        if (this.securityEventManager != null) {
            this.securityEventManager.secureOn(c);
            if (s != null || !verified) {
                this.securityEventManager.showSAS(s, verified);
            }
        }
    }

    public void srtpSecretsOff(ZrtpCallback.EnableSecurity part) {
        if (part == ZrtpCallback.EnableSecurity.ForSender) {
            if (this.srtpOutTransformer != null) {
                this.srtpOutTransformer.close();
                this.srtpOutTransformer = null;
            }
        } else if (part == ZrtpCallback.EnableSecurity.ForReceiver && this.srtpInTransformer != null) {
            this.srtpInTransformer.close();
            this.srtpInTransformer = null;
        }
        if (this.securityEventManager != null) {
            this.securityEventManager.secureOff();
        }
    }

    public int activateTimer(int time) {
        if (this.timeoutProvider != null) {
            this.timeoutProvider.requestTimeout(time);
        }
        return 1;
    }

    public int cancelTimer() {
        if (this.timeoutProvider != null) {
            this.timeoutProvider.cancelRequest();
        }
        return 1;
    }

    public void handleTimeout() {
        if (this.zrtpEngine != null) {
            this.zrtpEngine.processTimeout();
        }
    }

    public void sendInfo(ZrtpCodes.MessageSeverity severity, EnumSet<?> subCode) {
        if (this.securityEventManager != null) {
            this.securityEventManager.showMessage(severity, subCode);
        }
    }

    public void zrtpNegotiationFailed(ZrtpCodes.MessageSeverity severity, EnumSet<?> subCode) {
        if (this.securityEventManager != null) {
            this.securityEventManager.zrtpNegotiationFailed(severity, subCode);
        }
    }

    public void zrtpNotSuppOther() {
        if (this.securityEventManager != null) {
            this.securityEventManager.zrtpNotSuppOther();
        }
    }

    public void zrtpAskEnrollment(ZrtpCodes.InfoEnrollment info) {
        if (this.securityEventManager != null) {
            this.securityEventManager.zrtpAskEnrollment(info);
        }
    }

    public void zrtpInformEnrollment(ZrtpCodes.InfoEnrollment info) {
        if (this.securityEventManager != null) {
            this.securityEventManager.zrtpInformEnrollment(info);
        }
    }

    public void signSAS(byte[] sasHash) {
        if (this.securityEventManager != null) {
            this.securityEventManager.signSAS(sasHash);
        }
    }

    public boolean checkSASSignature(byte[] sasHash) {
        return this.securityEventManager != null ? this.securityEventManager.checkSASSignature(sasHash) : false;
    }

    public void setEnableZrtp(boolean onOff) {
        this.enableZrtp = onOff;
    }

    public boolean isEnableZrtp() {
        return this.enableZrtp;
    }

    public void SASVerified() {
        if (this.zrtpEngine != null) {
            this.zrtpEngine.SASVerified();
        }
        if (this.securityEventManager != null) {
            this.securityEventManager.setSASVerified(true);
        }
    }

    public void resetSASVerified() {
        if (this.zrtpEngine != null) {
            this.zrtpEngine.resetSASVerified();
        }
        if (this.securityEventManager != null) {
            this.securityEventManager.setSASVerified(false);
        }
    }

    public void requestGoClear() {
    }

    public void requestGoSecure() {
    }

    public void setAuxSecret(byte[] data) {
        if (this.zrtpEngine != null) {
            this.zrtpEngine.setAuxSecret(data);
        }
    }

    public void setClientId(String id) {
        this.clientIdString = id;
    }

    public String getHelloHash(int index) {
        return this.zrtpEngine != null ? this.zrtpEngine.getHelloHash(index) : new String();
    }

    public String[] getHelloHashSep(int index) {
        return this.zrtpEngine != null ? this.zrtpEngine.getHelloHashSep(index) : null;
    }

    public String getPeerHelloHash() {
        return this.zrtpEngine != null ? this.zrtpEngine.getPeerHelloHash() : new String();
    }

    public byte[] getMultiStrParams() {
        return this.zrtpEngine != null ? this.zrtpEngine.getMultiStrParams() : new byte[]{};
    }

    public void setMultiStrParams(byte[] parameters) {
        if (this.zrtpEngine != null) {
            this.zrtpEngine.setMultiStrParams(parameters);
        }
    }

    public boolean isMultiStream() {
        return this.zrtpEngine != null ? this.zrtpEngine.isMultiStream() : false;
    }

    public void acceptEnrollment(boolean accepted) {
        if (this.zrtpEngine != null) {
            this.zrtpEngine.acceptEnrollment(accepted);
        }
    }

    public ZrtpConstants.SupportedSASTypes getSasType() {
        return this.zrtpEngine != null ? this.zrtpEngine.getSasType() : null;
    }

    public byte[] getSasHash() {
        return this.zrtpEngine != null ? this.zrtpEngine.getSasHash() : null;
    }

    public boolean sendSASRelayPacket(byte[] sh, ZrtpConstants.SupportedSASTypes render) {
        return this.zrtpEngine != null ? this.zrtpEngine.sendSASRelayPacket(sh, render) : false;
    }

    public boolean isMitmMode() {
        return this.mitmMode;
    }

    public void setMitmMode(boolean mitmMode) {
        this.mitmMode = mitmMode;
    }

    public void setParanoidMode(boolean yesNo) {
        this.enableParanoidMode = yesNo;
    }

    public boolean isParanoidMode() {
        return this.enableParanoidMode;
    }

    public boolean isEnrollmentMode() {
        return this.zrtpEngine != null ? this.zrtpEngine.isEnrollmentMode() : false;
    }

    public void setEnrollmentMode(boolean enrollmentMode) {
        if (this.zrtpEngine != null) {
            this.zrtpEngine.setEnrollmentMode(enrollmentMode);
        }
    }

    public boolean setSignatureData(byte[] data) {
        return this.zrtpEngine != null ? this.zrtpEngine.setSignatureData(data) : false;
    }

    public byte[] getSignatureData() {
        return this.zrtpEngine != null ? this.zrtpEngine.getSignatureData() : new byte[]{};
    }

    public int getSignatureLength() {
        return this.zrtpEngine != null ? this.zrtpEngine.getSignatureLength() : 0;
    }

    public void handleGoClear() {
        this.securityEventManager.confirmGoClear();
    }

    public void setConnector(AbstractRTPConnector connector) {
        this.zrtpConnector = connector;
    }

    public void setUserCallback(SecurityEventManager ub) {
        this.securityEventManager = ub;
    }

    public boolean isStarted() {
        return this.started;
    }

    public SecurityEventManager getUserCallback() {
        return this.securityEventManager;
    }

    public byte[] getPeerZid() {
        return this.zrtpEngine != null ? this.zrtpEngine.getPeerZid() : null;
    }

    public int getNumberSupportedVersions() {
        return this.zrtpEngine != null ? this.zrtpEngine.getNumberSupportedVersions() : 0;
    }

    public int getCurrentProtocolVersion() {
        return this.zrtpEngine != null ? this.zrtpEngine.getCurrentProtocolVersion() : 0;
    }

    private class TimeoutProvider
    extends Thread {
        private long nextDelay;
        private boolean newTask;
        private boolean stop;
        private final Object sync;

        public TimeoutProvider(String name) {
            super(name);
            this.nextDelay = 0L;
            this.newTask = false;
            this.stop = false;
            this.sync = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void requestTimeout(long delay) {
            Object object = this.sync;
            synchronized (object) {
                this.nextDelay = delay;
                this.newTask = true;
                this.sync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopRun() {
            Object object = this.sync;
            synchronized (object) {
                this.stop = true;
                this.sync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelRequest() {
            Object object = this.sync;
            synchronized (object) {
                this.newTask = false;
                this.sync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                Object object = this.sync;
                synchronized (object) {
                    while (!this.newTask && !this.stop) {
                        try {
                            this.sync.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                long currentTime = System.currentTimeMillis();
                long endTime = currentTime + this.nextDelay;
                Object object2 = this.sync;
                synchronized (object2) {
                    while (currentTime < endTime && this.newTask && !this.stop) {
                        try {
                            this.sync.wait(endTime - currentTime);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        currentTime = System.currentTimeMillis();
                    }
                }
                if (!this.newTask || this.stop) continue;
                this.newTask = false;
                ZRTPTransformEngine.this.handleTimeout();
            }
        }
    }
}

