/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.maccoreaudio;

import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.GainControl;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.MediaServiceImpl;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.AudioSystem2;
import org.jitsi.impl.neomedia.device.MacCoreAudioDevice;
import org.jitsi.impl.neomedia.device.UpdateAvailableDeviceListListener;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPullBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.maccoreaudio.DataSource;
import org.jitsi.service.neomedia.BasicVolumeControl;
import org.jitsi.util.Logger;

public class MacCoreaudioStream
extends AbstractPullBufferStream<DataSource> {
    private static final Logger logger = Logger.getLogger(MacCoreaudioStream.class);
    private final boolean audioQualityImprovement;
    private byte[] buffer = null;
    private int bytesPerBuffer;
    private String deviceUID;
    private AudioFormat format = null;
    private Vector<byte[]> freeBufferList = new Vector();
    private Vector<byte[]> fullBufferList = new Vector();
    private final GainControl gainControl;
    private int nbBufferData = 0;
    private int sequenceNumber = 0;
    private Object startStopMutex = new Object();
    private Lock stopLock = new ReentrantLock();
    private long stream = 0L;
    private final UpdateAvailableDeviceListListener updateAvailableDeviceListListener = new UpdateAvailableDeviceListListener(){
        private String deviceUID = null;
        private boolean start = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void didUpdateAvailableDeviceList() throws Exception {
            Object object = MacCoreaudioStream.this.startStopMutex;
            synchronized (object) {
                if (MacCoreaudioStream.this.stream == 0L && this.start) {
                    MacCoreaudioStream.this.setDeviceUID(this.deviceUID);
                    MacCoreaudioStream.this.start();
                }
                this.deviceUID = null;
                this.start = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void willUpdateAvailableDeviceList() throws Exception {
            Object object = MacCoreaudioStream.this.startStopMutex;
            synchronized (object) {
                if (MacCoreaudioStream.this.stream == 0L) {
                    this.deviceUID = null;
                    this.start = false;
                } else {
                    this.deviceUID = MacCoreaudioStream.this.deviceUID;
                    this.start = true;
                    MacCoreaudioStream.this.stop();
                    MacCoreaudioStream.this.setDeviceUID(null);
                }
            }
        }
    };

    public MacCoreaudioStream(DataSource dataSource, FormatControl formatControl, boolean audioQualityImprovement) {
        super(dataSource, formatControl);
        this.audioQualityImprovement = audioQualityImprovement;
        MediaServiceImpl mediaServiceImpl = NeomediaServiceUtils.getMediaServiceImpl();
        this.gainControl = mediaServiceImpl == null ? null : (GainControl)((Object)mediaServiceImpl.getInputVolumeControl());
        AudioSystem2 audioSystem = (AudioSystem2)AudioSystem.getAudioSystem("maccoreaudio");
        if (audioSystem != null) {
            audioSystem.addUpdateAvailableDeviceListListener(this.updateAvailableDeviceListListener);
        }
    }

    private void connect() {
        AudioFormat format = (AudioFormat)this.getFormat();
        int channels = format.getChannels();
        if (channels == -1) {
            channels = 1;
        }
        int sampleSizeInBits = format.getSampleSizeInBits();
        double sampleRate = format.getSampleRate();
        int framesPerBuffer = (int)(sampleRate * 20.0 / (double)(channels * 1000));
        this.bytesPerBuffer = sampleSizeInBits / 8 * channels * framesPerBuffer;
        this.format = new AudioFormat("LINEAR", sampleRate, sampleSizeInBits, channels, 0, 1, -1, -1.0, Format.byteArray);
    }

    @Override
    protected Format doGetFormat() {
        return this.format == null ? super.doGetFormat() : this.format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(Buffer buffer) throws IOException {
        int length = 0;
        byte[] data = AbstractCodec2.validateByteArraySize(buffer, this.bytesPerBuffer, false);
        Object object = this.startStopMutex;
        synchronized (object) {
            while (this.fullBufferList.size() == 0 && this.stream != 0L) {
                try {
                    this.startStopMutex.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this.stream != 0L) {
                this.freeBufferList.add(data);
                data = this.fullBufferList.remove(0);
                length = data.length;
            }
        }
        if (length != 0 && this.gainControl != null) {
            BasicVolumeControl.applyGain(this.gainControl, data, 0, length);
        }
        long bufferTimeStamp = System.nanoTime();
        buffer.setData(data);
        buffer.setFlags(128);
        if (this.format != null) {
            buffer.setFormat(this.format);
        }
        buffer.setHeader(null);
        buffer.setLength(length);
        buffer.setOffset(0);
        buffer.setSequenceNumber(this.sequenceNumber++);
        buffer.setTimeStamp(bufferTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readInput(byte[] buffer, int bufferLength) {
        int nbCopied = 0;
        while (bufferLength > 0) {
            int length = this.buffer.length - this.nbBufferData;
            if (bufferLength < length) {
                length = bufferLength;
            }
            System.arraycopy(buffer, nbCopied, this.buffer, this.nbBufferData, length);
            this.nbBufferData += length;
            nbCopied += length;
            bufferLength -= length;
            if (this.nbBufferData != this.buffer.length) continue;
            this.fullBufferList.add(this.buffer);
            this.buffer = null;
            this.nbBufferData = 0;
            if (this.stopLock.tryLock()) {
                try {
                    Object object = this.startStopMutex;
                    synchronized (object) {
                        this.startStopMutex.notify();
                        if (this.freeBufferList.size() > 0) {
                            this.buffer = this.freeBufferList.remove(0);
                        }
                    }
                }
                finally {
                    this.stopLock.unlock();
                }
            }
            if (this.buffer != null) continue;
            this.buffer = new byte[this.bytesPerBuffer];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDeviceUID(String deviceUID) {
        Object object = this.startStopMutex;
        synchronized (object) {
            if (this.deviceUID != null) {
                try {
                    this.stop();
                }
                catch (IOException ioex) {
                    logger.info(ioex);
                }
                this.format = null;
            }
            this.deviceUID = deviceUID;
            if (this.deviceUID != null) {
                this.connect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        Object object = this.startStopMutex;
        synchronized (object) {
            if (this.stream == 0L && this.deviceUID != null) {
                this.buffer = new byte[this.bytesPerBuffer];
                this.nbBufferData = 0;
                this.fullBufferList.clear();
                this.freeBufferList.clear();
                AudioSystem2 audioSystem = (AudioSystem2)AudioSystem.getAudioSystem("maccoreaudio");
                if (audioSystem != null) {
                    audioSystem.willOpenStream();
                }
                try {
                    this.stream = MacCoreAudioDevice.startStream(this.deviceUID, this, (float)this.format.getSampleRate(), this.format.getChannels(), this.format.getSampleSizeInBits(), false, this.format.getEndian() == 1, false, true, audioSystem == null ? true : audioSystem.isEchoCancel());
                }
                finally {
                    if (audioSystem != null) {
                        audioSystem.didOpenStream();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        this.stopLock.lock();
        try {
            Object object = this.startStopMutex;
            synchronized (object) {
                if (this.stream != 0L && this.deviceUID != null) {
                    MacCoreAudioDevice.stopStream(this.deviceUID, this.stream);
                    this.stream = 0L;
                    this.fullBufferList.clear();
                    this.freeBufferList.clear();
                    this.startStopMutex.notify();
                }
            }
        }
        finally {
            this.stopLock.unlock();
        }
    }
}

