/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxInputStream;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.launch.AntMain;
import org.apache.tools.ant.util.JavaEnvUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Main
implements AntMain {
    public static final String DEFAULT_BUILD_FILENAME = "build.xml";
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private static boolean isLogFileUsed = false;
    private static String antVersion = null;
    private int msgOutputLevel;
    private File buildFile;
    private Vector targets;
    private Properties definedProps;
    private Vector listeners;
    private Vector propertyFiles;
    private boolean allowInput;
    private boolean keepGoingMode;
    private String loggerClassname;
    private String inputHandlerClassname;
    private boolean emacsMode;
    private boolean readyToRun;
    private boolean projectHelp;
    private Integer threadPriority;
    static /* synthetic */ Class class$org$apache$tools$ant$Main;

    private static final void printMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string != null) {
            System.err.println(string);
        }
    }

    public static void start(String[] stringArray, Properties properties, ClassLoader classLoader) {
        Main main = new Main();
        main.startAnt(stringArray, properties, classLoader);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startAnt(String[] stringArray, Properties properties, ClassLoader classLoader) {
        String string;
        try {
            Diagnostics.validateVersion();
            this.processArgs(stringArray);
        }
        catch (Throwable throwable) {
            Main.handleLogfile();
            Main.printMessage(throwable);
            System.exit(1);
        }
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                string = properties.getProperty(string2);
                this.definedProps.put(string2, string);
            }
        }
        int n = 1;
        try {
            try {
                try {
                    this.runBuild(classLoader);
                    n = 0;
                }
                catch (ExitStatusException exitStatusException) {
                    n = exitStatusException.getStatus();
                    if (n != 0) {
                        throw exitStatusException;
                    }
                }
            }
            catch (BuildException buildException) {
                if (err != System.err) {
                    Main.printMessage(buildException);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Main.printMessage(throwable);
            }
        }
        catch (Throwable throwable) {
            string = null;
            Main.handleLogfile();
            throw throwable;
        }
        {
            string = null;
        }
        Main.handleLogfile();
        System.exit(n);
    }

    private static final void handleLogfile() {
        if (isLogFileUsed) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (err != null) {
                try {
                    err.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void main(String[] stringArray) {
        Main.start(stringArray, null, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void processArgs(String[] stringArray) {
        Object object;
        Object object2;
        String string;
        String string2 = null;
        PrintStream printStream = null;
        int n = 0;
        while (true) {
            if (n >= stringArray.length) {
                if (this.buildFile != null) break;
                this.buildFile = string2 != null ? this.findBuildFile(System.getProperty("user.dir"), string2) : new File(DEFAULT_BUILD_FILENAME);
            }
            string = stringArray[n];
            if (string.equals("-help") || string.equals("-h")) {
                Main.printUsage();
                return;
            }
            if (string.equals("-version")) {
                Main.printVersion();
                return;
            }
            if (string.equals("-diagnostics")) {
                Diagnostics.doReport(System.out);
                return;
            }
            if (string.equals("-quiet") || string.equals("-q")) {
                this.msgOutputLevel = 1;
            } else if (string.equals("-verbose") || string.equals("-v")) {
                Main.printVersion();
                this.msgOutputLevel = 3;
            } else if (string.equals("-debug") || string.equals("-d")) {
                Main.printVersion();
                this.msgOutputLevel = 4;
            } else if (string.equals("-noinput")) {
                this.allowInput = false;
            } else {
                if (string.equals("-logfile") || string.equals("-l")) {
                    try {
                        object2 = new File(stringArray[n + 1]);
                        ++n;
                        printStream = new PrintStream(new FileOutputStream((File)object2));
                        isLogFileUsed = true;
                    }
                    catch (IOException iOException) {
                        object = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                        throw new BuildException((String)object);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        object = "You must specify a log file when using the -log argument";
                        throw new BuildException((String)object);
                    }
                }
                if (string.equals("-buildfile") || string.equals("-file") || string.equals("-f")) {
                    try {
                        this.buildFile = new File(stringArray[n + 1].replace('/', File.separatorChar));
                        ++n;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        object = "You must specify a buildfile when using the -buildfile argument";
                        throw new BuildException((String)object);
                    }
                }
                if (string.equals("-listener")) {
                    try {
                        this.listeners.addElement(stringArray[n + 1]);
                        ++n;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        object = "You must specify a classname when using the -listener argument";
                        throw new BuildException((String)object);
                    }
                }
                if (string.startsWith("-D")) {
                    object2 = string.substring(2, string.length());
                    object = null;
                    int n2 = ((String)object2).indexOf("=");
                    if (n2 > 0) {
                        object = ((String)object2).substring(n2 + 1);
                        object2 = ((String)object2).substring(0, n2);
                    } else {
                        if (n >= stringArray.length - 1) throw new BuildException("Missing value for property " + (String)object2);
                        object = stringArray[++n];
                    }
                    this.definedProps.put(object2, object);
                } else {
                    if (string.equals("-logger")) {
                        if (this.loggerClassname != null) {
                            throw new BuildException("Only one logger class may  be specified.");
                        }
                        try {
                            this.loggerClassname = stringArray[++n];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            throw new BuildException("You must specify a classname when using the -logger argument");
                        }
                    }
                    if (string.equals("-inputhandler")) {
                        if (this.inputHandlerClassname != null) {
                            throw new BuildException("Only one input handler class may be specified.");
                        }
                        try {
                            this.inputHandlerClassname = stringArray[++n];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            throw new BuildException("You must specify a classname when using the -inputhandler argument");
                        }
                    }
                    if (string.equals("-emacs") || string.equals("-e")) {
                        this.emacsMode = true;
                    } else if (string.equals("-projecthelp") || string.equals("-p")) {
                        this.projectHelp = true;
                    } else if (string.equals("-find") || string.equals("-s")) {
                        string2 = n < stringArray.length - 1 ? stringArray[++n] : DEFAULT_BUILD_FILENAME;
                    } else {
                        if (string.startsWith("-propertyfile")) {
                            try {
                                this.propertyFiles.addElement(stringArray[n + 1]);
                                ++n;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                object = "You must specify a property filename when using the -propertyfile argument";
                                throw new BuildException((String)object);
                            }
                        }
                        if (string.equals("-k") || string.equals("-keep-going")) {
                            this.keepGoingMode = true;
                        } else if (string.equals("-nice")) {
                            try {
                                this.threadPriority = Integer.decode(stringArray[n + 1]);
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                throw new BuildException("You must supply a niceness value (1-10) after the -nice option");
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new BuildException("Unrecognized niceness value: " + stringArray[n + 1]);
                            }
                            ++n;
                            if (this.threadPriority < 1) throw new BuildException("Niceness value is out of the range 1-10");
                            if (this.threadPriority > 10) {
                                throw new BuildException("Niceness value is out of the range 1-10");
                            }
                        } else {
                            if (string.startsWith("-")) {
                                object2 = "Unknown argument: " + string;
                                System.out.println((String)object2);
                                Main.printUsage();
                                throw new BuildException("");
                            }
                            this.targets.addElement(string);
                        }
                    }
                }
            }
            ++n;
        }
        if (!this.buildFile.exists()) {
            System.out.println("Buildfile: " + this.buildFile + " does not exist!");
            throw new BuildException("Build failed");
        }
        if (this.buildFile.isDirectory()) {
            System.out.println("What? Buildfile: " + this.buildFile + " is a dir!");
            throw new BuildException("Build failed");
        }
        n = 0;
        block25: while (true) {
            block69: {
                Object var9_19;
                if (n >= this.propertyFiles.size()) {
                    if (this.msgOutputLevel >= 2) {
                        System.out.println("Buildfile: " + this.buildFile);
                    }
                    if (printStream != null) {
                        out = printStream;
                        err = printStream;
                        System.setOut(out);
                        System.setErr(err);
                    }
                    this.readyToRun = true;
                    return;
                }
                string = (String)this.propertyFiles.elementAt(n);
                object2 = new Properties();
                object = null;
                try {
                    try {
                        object = new FileInputStream(string);
                        ((Properties)object2).load((InputStream)object);
                    }
                    catch (IOException iOException) {
                        System.out.println("Could not load property file " + string + ": " + iOException.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    var9_19 = null;
                    if (object == null) throw throwable;
                    try {
                        ((FileInputStream)object).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    var9_19 = null;
                    if (object == null) break block69;
                }
                try {}
                catch (IOException iOException) {}
                ((FileInputStream)object).close();
            }
            Enumeration<?> enumeration = ((Properties)object2).propertyNames();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    ++n;
                    continue block25;
                }
                String string3 = (String)enumeration.nextElement();
                if (this.definedProps.getProperty(string3) != null) continue;
                this.definedProps.put(string3, ((Properties)object2).getProperty(string3));
            }
            break;
        }
    }

    private final File getParentFile(File file) {
        File file2 = file.getParentFile();
        if (file2 != null && this.msgOutputLevel >= 3) {
            System.out.println("Searching in " + file2.getAbsolutePath());
        }
        return file2;
    }

    private final File findBuildFile(String string, String string2) throws BuildException {
        if (this.msgOutputLevel >= 2) {
            System.out.println("Searching for " + string2 + " ...");
        }
        File file = new File(new File(string).getAbsolutePath());
        File file2 = new File(file, string2);
        while (!file2.exists()) {
            if ((file = this.getParentFile(file)) == null) {
                throw new BuildException("Could not locate a build file!");
            }
            file2 = new File(file, string2);
        }
        return file2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void runBuild(ClassLoader classLoader) throws BuildException {
        if (!this.readyToRun) {
            return;
        }
        Project project = new Project();
        project.setCoreLoader(classLoader);
        Throwable throwable = null;
        try {
            try {
                SecurityManager securityManager;
                InputStream inputStream;
                PrintStream printStream;
                PrintStream printStream2;
                block25: {
                    block26: {
                        this.addBuildListeners(project);
                        this.addInputHandler(project);
                        printStream2 = System.err;
                        printStream = System.out;
                        inputStream = System.in;
                        securityManager = null;
                        if (!JavaEnvUtils.isJavaVersion("1.0") && !JavaEnvUtils.isJavaVersion("1.1")) {
                            securityManager = System.getSecurityManager();
                        }
                        try {
                            if (this.allowInput) {
                                project.setDefaultInputStream(System.in);
                            }
                            System.setIn(new DemuxInputStream(project));
                            System.setOut(new PrintStream(new DemuxOutputStream(project, false)));
                            System.setErr(new PrintStream(new DemuxOutputStream(project, true)));
                            if (!this.projectHelp) {
                                project.fireBuildStarted();
                            }
                            if (this.threadPriority != null) {
                                try {
                                    project.log("Setting Ant's thread priority to " + this.threadPriority, 3);
                                    Thread.currentThread().setPriority(this.threadPriority);
                                }
                                catch (SecurityException securityException) {
                                    project.log("A security manager refused to set the -nice value");
                                }
                            }
                            project.init();
                            project.setUserProperty("ant.version", Main.getAntVersion());
                            Enumeration<Object> enumeration = this.definedProps.keys();
                            while (enumeration.hasMoreElements()) {
                                String string = (String)enumeration.nextElement();
                                String string2 = (String)this.definedProps.get(string);
                                project.setUserProperty(string, string2);
                            }
                            project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                            project.setKeepGoingMode(this.keepGoingMode);
                            ProjectHelper.configureProject(project, this.buildFile);
                            if (!this.projectHelp) break block25;
                            Main.printDescription(project);
                            boolean bl = false;
                            if (this.msgOutputLevel > 2) {
                                bl = true;
                            }
                            Main.printTargets(project, bl);
                            Object var11_14 = null;
                            if (securityManager == null) break block26;
                        }
                        catch (Throwable throwable2) {
                            Object var11_15 = null;
                            if (securityManager != null) {
                                System.setSecurityManager(securityManager);
                            }
                            System.setOut(printStream);
                            System.setErr(printStream2);
                            System.setIn(inputStream);
                            throw throwable2;
                        }
                        System.setSecurityManager(securityManager);
                    }
                    System.setOut(printStream);
                    System.setErr(printStream2);
                    System.setIn(inputStream);
                    Object var5_17 = null;
                    if (!this.projectHelp) {
                        project.fireBuildFinished(throwable);
                        return;
                    }
                    if (throwable == null) return;
                    project.log(throwable.toString(), 0);
                    return;
                }
                if (this.targets.size() == 0 && project.getDefaultTarget() != null) {
                    this.targets.addElement(project.getDefaultTarget());
                }
                project.executeTargets(this.targets);
                Object var11_16 = null;
                if (securityManager != null) {
                    System.setSecurityManager(securityManager);
                }
                System.setOut(printStream);
                System.setErr(printStream2);
                System.setIn(inputStream);
            }
            catch (RuntimeException runtimeException) {
                throwable = runtimeException;
                throw runtimeException;
            }
            catch (Error error) {
                throwable = error;
                throw error;
            }
            Object var5_19 = null;
            if (!this.projectHelp) {
                project.fireBuildFinished(throwable);
                return;
            }
            if (throwable == null) return;
            project.log(throwable.toString(), 0);
            return;
        }
        catch (Throwable throwable3) {
            Object var5_18 = null;
            if (!this.projectHelp) {
                project.fireBuildFinished(throwable);
                throw throwable3;
            }
            if (throwable == null) throw throwable3;
            project.log(throwable.toString(), 0);
            throw throwable3;
        }
    }

    protected void addBuildListeners(Project project) {
        project.addBuildListener(this.createLogger());
        int n = 0;
        while (n < this.listeners.size()) {
            String string = (String)this.listeners.elementAt(n);
            try {
                BuildListener buildListener = (BuildListener)Class.forName(string).newInstance();
                if (project != null) {
                    project.setProjectReference(buildListener);
                }
                project.addBuildListener(buildListener);
            }
            catch (Throwable throwable) {
                throw new BuildException("Unable to instantiate listener " + string, throwable);
            }
            ++n;
        }
    }

    private final void addInputHandler(Project project) throws BuildException {
        InputHandler inputHandler = null;
        if (this.inputHandlerClassname == null) {
            inputHandler = new DefaultInputHandler();
        } else {
            try {
                inputHandler = (InputHandler)Class.forName(this.inputHandlerClassname).newInstance();
                if (project != null) {
                    project.setProjectReference(inputHandler);
                }
            }
            catch (ClassCastException classCastException) {
                String string = "The specified input handler class " + this.inputHandlerClassname + " does not implement the InputHandler interface";
                throw new BuildException(string);
            }
            catch (Exception exception) {
                String string = "Unable to instantiate specified input handler class " + this.inputHandlerClassname + " : " + exception.getClass().getName();
                throw new BuildException(string);
            }
        }
        project.setInputHandler(inputHandler);
    }

    private final BuildLogger createLogger() {
        BuildLogger buildLogger = null;
        if (this.loggerClassname != null) {
            try {
                Class<?> clazz = Class.forName(this.loggerClassname);
                buildLogger = (BuildLogger)clazz.newInstance();
            }
            catch (ClassCastException classCastException) {
                System.err.println("The specified logger class " + this.loggerClassname + " does not implement the BuildLogger interface");
                throw new RuntimeException();
            }
            catch (Exception exception) {
                System.err.println("Unable to instantiate specified logger class " + this.loggerClassname + " : " + exception.getClass().getName());
                throw new RuntimeException();
            }
        } else {
            buildLogger = new DefaultLogger();
        }
        buildLogger.setMessageOutputLevel(this.msgOutputLevel);
        buildLogger.setOutputPrintStream(out);
        buildLogger.setErrorPrintStream(err);
        buildLogger.setEmacsMode(this.emacsMode);
        return buildLogger;
    }

    private static final void printUsage() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ant [options] [target [target2 [target3] ...]]" + string);
        stringBuffer.append("Options: " + string);
        stringBuffer.append("  -help, -h              print this message" + string);
        stringBuffer.append("  -projecthelp, -p       print project help information" + string);
        stringBuffer.append("  -version               print the version information and exit" + string);
        stringBuffer.append("  -diagnostics           print information that might be helpful to" + string);
        stringBuffer.append("                         diagnose or report problems." + string);
        stringBuffer.append("  -quiet, -q             be extra quiet" + string);
        stringBuffer.append("  -verbose, -v           be extra verbose" + string);
        stringBuffer.append("  -debug, -d             print debugging information" + string);
        stringBuffer.append("  -emacs, -e             produce logging information without adornments" + string);
        stringBuffer.append("  -lib <path>            specifies a path to search for jars and classes" + string);
        stringBuffer.append("  -logfile <file>        use given file for log" + string);
        stringBuffer.append("    -l     <file>                ''" + string);
        stringBuffer.append("  -logger <classname>    the class which is to perform logging" + string);
        stringBuffer.append("  -listener <classname>  add an instance of class as a project listener" + string);
        stringBuffer.append("  -noinput               do not allow interactive input" + string);
        stringBuffer.append("  -buildfile <file>      use given buildfile" + string);
        stringBuffer.append("    -file    <file>              ''" + string);
        stringBuffer.append("    -f       <file>              ''" + string);
        stringBuffer.append("  -D<property>=<value>   use value for given property" + string);
        stringBuffer.append("  -keep-going, -k        execute all targets that do not depend" + string);
        stringBuffer.append("                         on failed target(s)" + string);
        stringBuffer.append("  -propertyfile <name>   load all properties from file with -D" + string);
        stringBuffer.append("                         properties taking precedence" + string);
        stringBuffer.append("  -inputhandler <class>  the class which will handle input requests" + string);
        stringBuffer.append("  -find <file>           (s)earch for buildfile towards the root of" + string);
        stringBuffer.append("    -s  <file>           the filesystem and use it" + string);
        stringBuffer.append("  -nice  number          A niceness value for the main thread:" + string + "                         1 (lowest) to 10 (highest); 5 is the default" + string);
        System.out.println(stringBuffer.toString());
    }

    private static final void printVersion() throws BuildException {
        System.out.println(Main.getAntVersion());
    }

    public static synchronized String getAntVersion() throws BuildException {
        if (antVersion == null) {
            try {
                Properties properties = new Properties();
                Class clazz = class$org$apache$tools$ant$Main;
                if (clazz == null) {
                    clazz = class$org$apache$tools$ant$Main = Main.class("[Lorg.apache.tools.ant.Main;", false);
                }
                InputStream inputStream = clazz.getResourceAsStream("/org/apache/tools/ant/version.txt");
                properties.load(inputStream);
                inputStream.close();
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Apache Ant version ");
                stringBuffer.append(properties.getProperty("VERSION"));
                stringBuffer.append(" compiled on ");
                stringBuffer.append(properties.getProperty("DATE"));
                antVersion = stringBuffer.toString();
            }
            catch (IOException iOException) {
                throw new BuildException("Could not load the version information:" + iOException.getMessage());
            }
            catch (NullPointerException nullPointerException) {
                throw new BuildException("Could not load the version information.");
            }
        }
        return antVersion;
    }

    private static final void printDescription(Project project) {
        if (project.getDescription() != null) {
            project.log(project.getDescription());
        }
    }

    private static final void printTargets(Project project, boolean bl) {
        String string;
        int n = 0;
        Enumeration enumeration = project.getTargets().elements();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            int n2;
            Target target = (Target)enumeration.nextElement();
            String string2 = target.getName();
            if (string2.equals("")) continue;
            String string3 = target.getDescription();
            if (string3 == null) {
                n2 = Main.findTargetPosition(vector3, string2);
                vector3.insertElementAt(string2, n2);
                continue;
            }
            n2 = Main.findTargetPosition(vector, string2);
            vector.insertElementAt(string2, n2);
            vector2.insertElementAt(string3, n2);
            if (string2.length() <= n) continue;
            n = string2.length();
        }
        Main.printTargets(project, vector, vector2, "Main targets:", n);
        if (vector.size() == 0) {
            bl = true;
        }
        if (bl) {
            Main.printTargets(project, vector3, null, "Other targets:", 0);
        }
        if ((string = project.getDefaultTarget()) != null && !"".equals(string)) {
            project.log("Default target: " + string);
        }
    }

    private static final int findTargetPosition(Vector vector, String string) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < vector.size() && n == vector.size()) {
            if (string.compareTo((String)vector.elementAt(n2)) < 0) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    private static final void printTargets(Project project, Vector vector, Vector vector2, String string, int n) {
        String string2 = System.getProperty("line.separator");
        String string3 = "    ";
        while (string3.length() <= n) {
            string3 = string3 + string3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + string2 + string2);
        int n2 = 0;
        while (n2 < vector.size()) {
            stringBuffer.append(" ");
            stringBuffer.append(vector.elementAt(n2));
            if (vector2 != null) {
                stringBuffer.append(string3.substring(0, n - ((String)vector.elementAt(n2)).length() + 2));
                stringBuffer.append(vector2.elementAt(n2));
            }
            stringBuffer.append(string2);
            ++n2;
        }
        project.log(stringBuffer.toString());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.msgOutputLevel = 2;
        this.targets = new Vector();
        this.definedProps = new Properties();
        this.listeners = new Vector(1);
        this.propertyFiles = new Vector(1);
        this.allowInput = true;
        this.keepGoingMode = false;
        this.loggerClassname = null;
        this.inputHandlerClassname = null;
        this.emacsMode = false;
        this.readyToRun = false;
        this.projectHelp = false;
        this.threadPriority = null;
    }

    public Main() {
        this.this();
    }

    protected Main(String[] stringArray) throws BuildException {
        this.this();
        this.processArgs(stringArray);
    }
}

