/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.data.derby;

import com.voxeo.data.DatabaseUpdaterLifecycleListener;
import com.voxeo.data.Schema;
import com.voxeo.logging.Loggerf;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DerbyLifecycleListener
implements DatabaseUpdaterLifecycleListener {
    private static final Loggerf log = Loggerf.getLogger(DerbyLifecycleListener.class);

    public void after(Schema schema, boolean success) {
        String databaseName = schema.getName();
        try {
            DriverManager.getConnection("jdbc:derby:" + databaseName + ";shutdown=true");
        }
        catch (SQLException e) {
            log.info("Derby database shut down [name=%s]", databaseName);
        }
    }

    public void before(DataSource datasource, Schema schema) {
    }
}

