/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.atomiclong;

import com.hazelcast.concurrent.atomiclong.AtomicLongReplicationOperation;
import com.hazelcast.concurrent.atomiclong.AtomicLongWrapper;
import com.hazelcast.concurrent.atomiclong.proxy.AtomicLongProxy;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AtomicLongService
implements ManagedService,
RemoteService,
MigrationAwareService {
    public static final String SERVICE_NAME = "hz:impl:atomicLongService";
    private NodeEngine nodeEngine;
    private final ConcurrentMap<String, AtomicLongWrapper> numbers = new ConcurrentHashMap<String, AtomicLongWrapper>();
    private final ConstructorFunction<String, AtomicLongWrapper> atomicLongConstructorFunction = new ConstructorFunction<String, AtomicLongWrapper>(){

        @Override
        public AtomicLongWrapper createNew(String key) {
            return new AtomicLongWrapper();
        }
    };

    public AtomicLongWrapper getNumber(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.numbers, name, this.atomicLongConstructorFunction);
    }

    public boolean containsAtomicLong(String name) {
        return this.numbers.containsKey(name);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void reset() {
        this.numbers.clear();
    }

    @Override
    public void shutdown() {
        this.reset();
    }

    @Override
    public AtomicLongProxy createDistributedObject(String name) {
        return new AtomicLongProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.numbers.remove(name);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        if (event.getReplicaIndex() > 1) {
            return null;
        }
        HashMap<String, Long> data = new HashMap<String, Long>();
        int partitionId = event.getPartitionId();
        for (String name : this.numbers.keySet()) {
            if (partitionId != this.nodeEngine.getPartitionService().getPartitionId(StringPartitioningStrategy.getPartitionKey(name))) continue;
            data.put(name, ((AtomicLongWrapper)this.numbers.get(name)).get());
        }
        return data.isEmpty() ? null : new AtomicLongReplicationOperation(data);
    }

    @Override
    public void commitMigration(PartitionMigrationEvent partitionMigrationEvent) {
        if (partitionMigrationEvent.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.removeNumber(partitionMigrationEvent.getPartitionId());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent partitionMigrationEvent) {
        if (partitionMigrationEvent.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.removeNumber(partitionMigrationEvent.getPartitionId());
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.removeNumber(partitionId);
    }

    public void removeNumber(int partitionId) {
        Iterator iterator = this.numbers.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (this.nodeEngine.getPartitionService().getPartitionId(StringPartitioningStrategy.getPartitionKey(name)) != partitionId) continue;
            iterator.remove();
        }
    }
}

