/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osgi.framework;

import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import net.java.sip.communicator.impl.osgi.framework.BundleImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceRegistrationImpl
implements ServiceRegistration {
    private static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    };
    private static final Map<String, Object> EMPTY_PROPERTIES = ServiceRegistrationImpl.newCaseInsensitiveMapInstance();
    private final BundleImpl bundle;
    private final String[] classNames;
    private final Map<String, Object> properties;
    private Object service;
    private final Long serviceId;
    private final ServiceReferenceImpl serviceReference = new ServiceReferenceImpl();

    public ServiceRegistrationImpl(BundleImpl bundleImpl, long l, String[] stringArray, Object object, Dictionary<String, ?> dictionary) {
        this.bundle = bundleImpl;
        this.serviceId = l;
        this.classNames = stringArray;
        this.service = object;
        if (dictionary == null || dictionary.isEmpty()) {
            this.properties = EMPTY_PROPERTIES;
        } else {
            Enumeration<String> enumeration = dictionary.keys();
            Map<String, Object> map = ServiceRegistrationImpl.newCaseInsensitiveMapInstance();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if ("objectClass".equalsIgnoreCase(string) || "service.id".equalsIgnoreCase(string)) continue;
                if (map.containsKey(string)) {
                    throw new IllegalArgumentException(string);
                }
                map.put(string, dictionary.get(string));
            }
            this.properties = map.isEmpty() ? EMPTY_PROPERTIES : map;
        }
    }

    public ServiceReferenceImpl getReference() {
        return this.serviceReference;
    }

    public ServiceReference getReference(Class<?> clazz) {
        return this.serviceReference;
    }

    private static Map<String, Object> newCaseInsensitiveMapInstance() {
        return new TreeMap<String, Object>(CASE_INSENSITIVE_COMPARATOR);
    }

    public void setProperties(Dictionary dictionary) {
    }

    public void unregister() {
        this.bundle.getFramework().unregisterService(this.bundle, this);
    }

    class ServiceReferenceImpl
    implements ServiceReference {
        ServiceReferenceImpl() {
        }

        public int compareTo(Object object) {
            Long l = ServiceRegistrationImpl.this.serviceId;
            Long l2 = ((ServiceRegistrationImpl)object).serviceId;
            return l2.compareTo(l);
        }

        public Bundle getBundle() {
            return ServiceRegistrationImpl.this.bundle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getProperty(String string) {
            Object object;
            if ("objectClass".equalsIgnoreCase(string)) {
                object = ServiceRegistrationImpl.this.classNames;
            } else if ("service.id".equalsIgnoreCase(string)) {
                object = ServiceRegistrationImpl.this.serviceId;
            } else {
                Map map = ServiceRegistrationImpl.this.properties;
                synchronized (map) {
                    object = ServiceRegistrationImpl.this.properties.get(string);
                }
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getPropertyKeys() {
            Map map = ServiceRegistrationImpl.this.properties;
            synchronized (map) {
                String[] stringArray = new String[2 + ServiceRegistrationImpl.this.properties.size()];
                int n = 0;
                stringArray[n++] = "objectClass";
                stringArray[n++] = "service.id";
                for (String string : ServiceRegistrationImpl.this.properties.keySet()) {
                    stringArray[n++] = string;
                }
                return stringArray;
            }
        }

        Object getService() {
            return ServiceRegistrationImpl.this.service;
        }

        public Bundle[] getUsingBundles() {
            return null;
        }

        public boolean isAssignableTo(Bundle bundle, String string) {
            return false;
        }
    }
}

