/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.html.Markup;
import java.util.Properties;

public class ListItem
extends Paragraph {
    private static final long serialVersionUID = 1970670787169329006L;
    private Chunk symbol;

    public ListItem() {
    }

    public ListItem(float leading) {
        super(leading);
    }

    public ListItem(Chunk chunk) {
        super(chunk);
    }

    public ListItem(String string) {
        super(string);
    }

    public ListItem(String string, Font font) {
        super(string, font);
    }

    public ListItem(float leading, Chunk chunk) {
        super(leading, chunk);
    }

    public ListItem(float leading, String string) {
        super(leading, string);
    }

    public ListItem(float leading, String string, Font font) {
        super(leading, string, font);
    }

    public ListItem(Phrase phrase) {
        super(phrase);
    }

    public ListItem(Properties attributes) {
        super("", FontFactory.getFont(attributes));
        String value = (String)attributes.remove("itext");
        if (value != null) {
            this.add(new Chunk(value));
        }
        if ((value = (String)attributes.remove("leading")) != null) {
            this.setLeading(Float.parseFloat(String.valueOf(value) + "f"));
        } else {
            value = (String)attributes.remove("line-height");
            if (value != null) {
                this.setLeading(Markup.parseLength(value));
            }
        }
        value = (String)attributes.remove("indentationleft");
        if (value != null) {
            this.setIndentationLeft(Float.parseFloat(String.valueOf(value) + "f"));
        }
        if ((value = (String)attributes.remove("indentationright")) != null) {
            this.setIndentationRight(Float.parseFloat(String.valueOf(value) + "f"));
        }
        if ((value = (String)attributes.remove("align")) != null) {
            this.setAlignment(value);
        }
    }

    public int type() {
        return 15;
    }

    public void setListSymbol(Chunk symbol) {
        if (this.symbol == null) {
            this.symbol = symbol;
            if (this.symbol.font().isStandardFont()) {
                this.symbol.setFont(this.font);
            }
        }
    }

    public Chunk listSymbol() {
        return this.symbol;
    }

    public static boolean isTag(String tag) {
        return "listitem".equals(tag);
    }

    public void setIndentationLeft(float indentation, boolean autoindent) {
        if (autoindent) {
            System.err.println(String.valueOf(this.listSymbol().toString()) + " " + this.listSymbol().getWidthPoint());
            this.setIndentationLeft(this.listSymbol().getWidthPoint());
        } else {
            this.setIndentationLeft(indentation);
        }
    }
}

