/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.LockSupport;
import javax.media.rtp.OutputDataStream;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.util.Logger;

public abstract class RTPConnectorOutputStream
implements OutputDataStream {
    private static final Logger logger = Logger.getLogger(RTPConnectorOutputStream.class);
    public static final int MAX_PACKETS_PER_MILLIS_POLICY_PACKET_QUEUE_CAPACITY = 256;
    private MaxPacketsPerMillisPolicy maxPacketsPerMillisPolicy;
    protected final List<InetSocketAddress> targets = new LinkedList<InetSocketAddress>();
    private final LinkedBlockingQueue<RawPacket> rawPacketPool = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<RawPacket[]> rawPacketArrayPool = new LinkedBlockingQueue();
    private long numberOfPackets = 0L;
    private boolean enabled = true;

    public void addTarget(InetAddress remoteAddr, int remotePort) {
        InetSocketAddress target = new InetSocketAddress(remoteAddr, remotePort);
        if (!this.targets.contains(target)) {
            this.targets.add(target);
        }
    }

    public void close() {
        if (this.maxPacketsPerMillisPolicy != null) {
            this.maxPacketsPerMillisPolicy.close();
            this.maxPacketsPerMillisPolicy = null;
        }
        this.removeTargets();
    }

    protected RawPacket[] createRawPacket(byte[] buffer, int offset, int length) {
        byte[] pktBuffer;
        RawPacket pkt;
        RawPacket[] pkts = this.rawPacketArrayPool.poll();
        if (pkts == null) {
            pkts = new RawPacket[1];
        }
        if ((pkt = this.rawPacketPool.poll()) == null) {
            pktBuffer = new byte[length];
            pkt = new RawPacket();
        } else {
            pktBuffer = pkt.getBuffer();
        }
        if (pktBuffer.length < length) {
            pktBuffer = new byte[length];
        }
        pkt.setBuffer(pktBuffer);
        pkt.setFlags(0);
        pkt.setLength(length);
        pkt.setOffset(0);
        System.arraycopy(buffer, offset, pktBuffer, 0, length);
        pkts[0] = pkt;
        return pkts;
    }

    public boolean removeTarget(InetAddress remoteAddr, int remotePort) {
        Iterator<InetSocketAddress> targetIter = this.targets.iterator();
        while (targetIter.hasNext()) {
            InetSocketAddress target = targetIter.next();
            if (!target.getAddress().equals(remoteAddr) || target.getPort() != remotePort) continue;
            targetIter.remove();
            return true;
        }
        return false;
    }

    public void removeTargets() {
        this.targets.clear();
    }

    static boolean logPacket(long numOfPacket) {
        return numOfPacket == 1L || numOfPacket == 300L || numOfPacket == 500L || numOfPacket == 1000L || numOfPacket % 5000L == 0L;
    }

    protected abstract void sendToTarget(RawPacket var1, InetSocketAddress var2) throws IOException;

    protected abstract void doLogPacket(RawPacket var1, InetSocketAddress var2);

    protected abstract boolean isSocketValid();

    private boolean send(RawPacket packet) {
        if (!this.isSocketValid()) {
            this.rawPacketPool.offer(packet);
            return false;
        }
        ++this.numberOfPackets;
        for (InetSocketAddress target : this.targets) {
            try {
                PacketLoggingService packetLogging;
                this.sendToTarget(packet, target);
                if (!RTPConnectorOutputStream.logPacket(this.numberOfPackets) || (packetLogging = LibJitsi.getPacketLoggingService()) == null || !packetLogging.isLoggingEnabled(PacketLoggingService.ProtocolName.RTP)) continue;
                this.doLogPacket(packet, target);
            }
            catch (IOException ioe) {
                this.rawPacketPool.offer(packet);
                return false;
            }
        }
        this.rawPacketPool.offer(packet);
        return true;
    }

    public void setMaxPacketsPerMillis(int maxPackets, long perMillis) {
        if (this.maxPacketsPerMillisPolicy == null) {
            if (maxPackets > 0) {
                if (perMillis < 1L) {
                    throw new IllegalArgumentException("perMillis");
                }
                this.maxPacketsPerMillisPolicy = new MaxPacketsPerMillisPolicy(maxPackets, perMillis);
            }
        } else {
            this.maxPacketsPerMillisPolicy.setMaxPacketsPerMillis(maxPackets, perMillis);
        }
    }

    @Override
    public int write(byte[] buffer, int offset, int length) {
        if (logger.isDebugEnabled() && this.targets.isEmpty()) {
            logger.debug("Write called without targets!", new Throwable());
        }
        if (!this.enabled) {
            return length;
        }
        RawPacket[] pkts = this.createRawPacket(buffer, offset, length);
        boolean fail = false;
        for (int i = 0; i < pkts.length; ++i) {
            RawPacket pkt = pkts[i];
            pkts[i] = null;
            if (pkt != null && !fail) {
                if (this.maxPacketsPerMillisPolicy == null) {
                    if (!this.send(pkt)) {
                        fail = true;
                        continue;
                    }
                } else {
                    this.maxPacketsPerMillisPolicy.write(pkt);
                }
            }
            if (pkt == null || !fail) continue;
            this.rawPacketPool.offer(pkt);
        }
        this.rawPacketArrayPool.offer(pkts);
        return fail ? -1 : length;
    }

    public void setPriority(int priority) {
    }

    public void setEnabled(boolean enabled) {
        if (logger.isDebugEnabled()) {
            logger.debug("setEnabled: " + enabled);
        }
        this.enabled = enabled;
    }

    private class MaxPacketsPerMillisPolicy {
        private int maxPackets = -1;
        private long millisStartTime = 0L;
        private final ArrayBlockingQueue<RawPacket> packetQueue = new ArrayBlockingQueue(256);
        private long packetsSentInMillis = 0L;
        private long perNanos = -1L;
        private Thread sendThread;
        private boolean closed = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MaxPacketsPerMillisPolicy(int maxPackets, long perMillis) {
            this.setMaxPacketsPerMillis(maxPackets, perMillis);
            MaxPacketsPerMillisPolicy maxPacketsPerMillisPolicy = this;
            synchronized (maxPacketsPerMillisPolicy) {
                if (this.sendThread == null) {
                    this.sendThread = new Thread(this.getClass().getName()){

                        @Override
                        public void run() {
                            MaxPacketsPerMillisPolicy.this.runInSendThread();
                        }
                    };
                    this.sendThread.setDaemon(true);
                    this.sendThread.start();
                }
            }
        }

        synchronized void close() {
            if (!this.closed) {
                this.closed = true;
                this.packetQueue.offer(new RawPacket());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runInSendThread() {
            try {
                while (!this.closed) {
                    RawPacket packet;
                    try {
                        packet = this.packetQueue.take();
                    }
                    catch (InterruptedException iex) {
                        continue;
                    }
                    if (this.closed) {
                        break;
                    }
                    long time = System.nanoTime();
                    long millisRemainingTime = time - this.millisStartTime;
                    if (this.perNanos < 1L || millisRemainingTime >= this.perNanos) {
                        this.millisStartTime = time;
                        this.packetsSentInMillis = 0L;
                    } else if (this.maxPackets > 0 && this.packetsSentInMillis >= (long)this.maxPackets) {
                        while ((millisRemainingTime = System.nanoTime() - this.millisStartTime) < this.perNanos) {
                            LockSupport.parkNanos(millisRemainingTime);
                        }
                        this.millisStartTime = System.nanoTime();
                        this.packetsSentInMillis = 0L;
                    }
                    RTPConnectorOutputStream.this.send(packet);
                    ++this.packetsSentInMillis;
                }
            }
            finally {
                this.packetQueue.clear();
                ArrayBlockingQueue<RawPacket> arrayBlockingQueue = this.packetQueue;
                synchronized (arrayBlockingQueue) {
                    if (Thread.currentThread().equals(this.sendThread)) {
                        this.sendThread = null;
                    }
                }
            }
        }

        public void setMaxPacketsPerMillis(int maxPackets, long perMillis) {
            if (maxPackets < 1) {
                this.maxPackets = -1;
                this.perNanos = -1L;
            } else {
                if (perMillis < 1L) {
                    throw new IllegalArgumentException("perMillis");
                }
                this.maxPackets = maxPackets;
                this.perNanos = perMillis * 1000000L;
            }
        }

        public void write(RawPacket packet) {
            while (true) {
                try {
                    this.packetQueue.put(packet);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

