/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import org.ice4j.socket.DelegatingDatagramSocket;
import org.ice4j.socket.StunDatagramPacketFilter;

public class DelegatingSocket
extends Socket {
    protected final Socket delegate;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private long nbReceivedRtpPackets = 0L;
    private long nbSentRtpPackets = 0L;
    private long nbLostRtpPackets = 0L;
    private long lastRtpSequenceNumber = -1L;
    private long lastLostPacketLogTime = 0L;

    public DelegatingSocket() {
        this.delegate = null;
    }

    public DelegatingSocket(InetAddress address, int port) throws IOException {
        this.delegate = null;
    }

    public DelegatingSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        this.delegate = null;
    }

    public DelegatingSocket(Proxy proxy) {
        this.delegate = null;
    }

    protected DelegatingSocket(SocketImpl impl) throws SocketException {
        this.delegate = null;
    }

    public DelegatingSocket(String host, int port) throws UnknownHostException, IOException {
        this.delegate = null;
    }

    public DelegatingSocket(String host, int port, InetAddress localAddr, int localPort) {
        this.delegate = null;
    }

    public DelegatingSocket(Socket socket) {
        this.delegate = socket;
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        if (this.delegate != null) {
            this.delegate.bind(bindpoint);
        } else {
            super.bind(bindpoint);
        }
    }

    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        } else {
            super.close();
        }
    }

    public void connect(SocketAddress endpoint) throws IOException {
        if (this.delegate != null) {
            this.delegate.connect(endpoint);
        } else {
            super.connect(endpoint);
        }
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (this.delegate != null) {
            this.delegate.connect(endpoint, timeout);
        } else {
            super.connect(endpoint, timeout);
        }
    }

    public SocketChannel getChannel() {
        if (this.delegate != null) {
            return this.delegate.getChannel();
        }
        return super.getChannel();
    }

    public InetAddress getInetAddress() {
        if (this.delegate != null) {
            return this.delegate.getInetAddress();
        }
        return super.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getInputStream();
        }
        return super.getInputStream();
    }

    public boolean getKeepAlive() throws SocketException {
        if (this.delegate != null) {
            return this.delegate.getKeepAlive();
        }
        return super.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        if (this.delegate != null) {
            return this.delegate.getLocalAddress();
        }
        return super.getLocalAddress();
    }

    public int getLocalPort() {
        if (this.delegate != null) {
            return this.delegate.getLocalPort();
        }
        return super.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        if (this.delegate != null) {
            return this.delegate.getLocalSocketAddress();
        }
        return super.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        if (this.delegate != null) {
            return this.delegate.getOOBInline();
        }
        return super.getOOBInline();
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getOutputStream();
        }
        return super.getOutputStream();
    }

    public int getPort() {
        if (this.delegate != null) {
            return this.delegate.getPort();
        }
        return super.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.delegate != null) {
            return this.delegate.getReceiveBufferSize();
        }
        return super.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        if (this.delegate != null) {
            return this.delegate.getRemoteSocketAddress();
        }
        return super.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.delegate != null) {
            return this.delegate.getReuseAddress();
        }
        return super.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        if (this.delegate != null) {
            return this.delegate.getSendBufferSize();
        }
        return super.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        if (this.delegate != null) {
            return this.delegate.getSoLinger();
        }
        return super.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        if (this.delegate != null) {
            return this.delegate.getSoTimeout();
        }
        return super.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        if (this.delegate != null) {
            return this.delegate.getTcpNoDelay();
        }
        return super.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        if (this.delegate != null) {
            return this.delegate.getTrafficClass();
        }
        return super.getTrafficClass();
    }

    public boolean isBound() {
        if (this.delegate != null) {
            return this.delegate.isBound();
        }
        return super.isBound();
    }

    public boolean isClosed() {
        if (this.delegate != null) {
            return this.delegate.isClosed();
        }
        return super.isClosed();
    }

    public boolean isConnected() {
        if (this.delegate != null) {
            return this.delegate.isConnected();
        }
        return super.isConnected();
    }

    public boolean isInputShutdown() {
        if (this.delegate != null) {
            return this.delegate.isInputShutdown();
        }
        return super.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        if (this.delegate != null) {
            return this.delegate.isOutputShutdown();
        }
        return super.isOutputShutdown();
    }

    public void sendUrgentData(int data) throws IOException {
        if (this.delegate != null) {
            this.delegate.sendUrgentData(data);
        } else {
            super.sendUrgentData(data);
        }
    }

    public void setKeepAlive(boolean on) throws SocketException {
        if (this.delegate != null) {
            this.delegate.setKeepAlive(on);
        } else {
            super.setKeepAlive(on);
        }
    }

    public void setOOBInline(boolean on) throws SocketException {
        if (this.delegate != null) {
            this.delegate.setOOBInline(on);
        } else {
            super.setOOBInline(on);
        }
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        if (this.delegate != null) {
            this.delegate.setPerformancePreferences(connectionTime, bandwidth, bandwidth);
        } else {
            super.setPerformancePreferences(connectionTime, latency, bandwidth);
        }
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.delegate != null) {
            this.delegate.setReceiveBufferSize(size);
        } else {
            super.setReceiveBufferSize(size);
        }
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.delegate != null) {
            this.delegate.setReuseAddress(on);
        } else {
            super.setReuseAddress(on);
        }
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (this.delegate != null) {
            this.delegate.setSendBufferSize(size);
        } else {
            super.setSendBufferSize(size);
        }
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (this.delegate != null) {
            this.delegate.setSoLinger(on, linger);
        } else {
            super.setSoLinger(on, linger);
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        if (this.delegate != null) {
            this.delegate.setSoTimeout(timeout);
        } else {
            super.setSoTimeout(timeout);
        }
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        if (this.delegate != null) {
            this.delegate.setTcpNoDelay(on);
        } else {
            super.setTcpNoDelay(on);
        }
    }

    public void setTrafficClass(int tc) throws SocketException {
        if (this.delegate != null) {
            this.delegate.setTrafficClass(tc);
        } else {
            super.setTrafficClass(tc);
        }
    }

    public void shutdownInput() throws IOException {
        if (this.delegate != null) {
            this.delegate.shutdownInput();
        } else {
            super.shutdownInput();
        }
    }

    public void shutdownOutput() throws IOException {
        if (this.delegate != null) {
            this.delegate.shutdownOutput();
        } else {
            super.shutdownOutput();
        }
    }

    public String toString() {
        if (this.delegate != null) {
            return this.delegate.toString();
        }
        return super.toString();
    }

    public void send(DatagramPacket p) throws IOException {
        if (this.delegate != null && this.delegate instanceof DelegatingSocket) {
            ((DelegatingSocket)this.delegate).send(p);
            return;
        }
        if (this.outputStream == null) {
            this.outputStream = this.getOutputStream();
        }
        this.outputStream.write(p.getData(), p.getOffset(), p.getLength());
        ++this.nbSentRtpPackets;
        InetSocketAddress localAddress = (InetSocketAddress)super.getLocalSocketAddress();
        DelegatingDatagramSocket.logPacketToPcap(p, this.nbSentRtpPackets, true, localAddress.getAddress(), localAddress.getPort());
    }

    public void receive(DatagramPacket p) throws IOException {
        if (this.delegate != null && this.delegate instanceof DelegatingSocket) {
            ((DelegatingSocket)this.delegate).receive(p);
        } else {
            if (this.inputStream == null) {
                this.inputStream = this.getInputStream();
            }
            DelegatingSocket.receiveFromNetwork(p, this.inputStream, this.getInetAddress(), this.getPort());
            if (!StunDatagramPacketFilter.isStunPacket(p)) {
                ++this.nbReceivedRtpPackets;
            }
            InetSocketAddress localAddress = (InetSocketAddress)super.getLocalSocketAddress();
            DelegatingDatagramSocket.logPacketToPcap(p, this.nbReceivedRtpPackets, false, localAddress.getAddress(), localAddress.getPort());
            this.updateRtpLosses(p);
        }
    }

    public static void receiveFromNetwork(DatagramPacket p, InputStream inputStream, InetAddress inetAddress, int port) throws IOException {
        int readLen;
        byte[] data = p.getData();
        int len = 0;
        int fb = inputStream.read();
        int sb = inputStream.read();
        if (fb == -1 || sb == -1) {
            p.setLength(0);
            throw new SocketException("read failed");
        }
        int desiredLength = (fb & 0xFF) << 8 | sb & 0xFF;
        int offset = 0;
        for (readLen = 0; readLen < desiredLength; readLen += len) {
            len = inputStream.read(data, offset, desiredLength - offset);
            if (len == -1) {
                throw new SocketException("read failed");
            }
            offset += len;
        }
        if (readLen != desiredLength) {
            throw new SocketException("Failed to receive data from socket");
        }
        p.setData(data);
        p.setLength(len);
        p.setAddress(inetAddress);
        p.setPort(port);
        data = null;
    }

    public void setOriginalInputStream(InputStream inputStream) {
        if (this.inputStream == null && inputStream != null) {
            this.inputStream = inputStream;
        }
    }

    public void updateRtpLosses(DatagramPacket p) {
        if (!StunDatagramPacketFilter.isStunPacket(p)) {
            long newSeq = DelegatingDatagramSocket.getRtpSequenceNumber(p);
            if (this.lastRtpSequenceNumber != -1L) {
                this.nbLostRtpPackets += DelegatingDatagramSocket.getNbLost(this.lastRtpSequenceNumber, newSeq);
            }
            this.lastRtpSequenceNumber = newSeq;
            this.lastLostPacketLogTime = DelegatingDatagramSocket.logRtpLosses(this.nbLostRtpPackets, this.nbReceivedRtpPackets, this.lastLostPacketLogTime);
        }
    }
}

