/*
 * Decompiled with CFR 0.152.
 */
package com.rayo.core.validation;

import com.rayo.core.validation.ValidChoices;
import com.rayo.core.verb.Choices;
import com.rayo.core.verb.Input;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class ChoicesValidator
implements ConstraintValidator<ValidChoices, Input> {
    public void initialize(ValidChoices constraint) {
    }

    public boolean isValid(Input value, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        if ((value.getGrammars() == null || value.getGrammars().size() <= 0) && value.getCpaData() == null) {
            context.buildConstraintViolationWithTemplate("You need to provide at least a valid choice element or CPA data.").addConstraintViolation();
            return false;
        }
        for (Choices choice : value.getGrammars()) {
            if (!choice.isContentsOrUrlSpecified()) {
                context.buildConstraintViolationWithTemplate("For choices, either 'url' or inline choices text is required (not both)").addConstraintViolation();
                return false;
            }
            if (choice.isContentsTypeSpecifiedWithInlineContents()) continue;
            context.buildConstraintViolationWithTemplate("'content-type' is required when specifying choices contents inline").addConstraintViolation();
            return false;
        }
        return true;
    }
}

