/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.client;

import com.hazelcast.client.PartitionClientRequest;
import com.hazelcast.client.SecureRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.TopicPermission;
import com.hazelcast.spi.Operation;
import com.hazelcast.topic.PublishOperation;
import com.hazelcast.topic.TopicPortableHook;
import java.io.IOException;
import java.security.Permission;

public class PublishRequest
extends PartitionClientRequest
implements Portable,
SecureRequest {
    String name;
    private Data message;

    public PublishRequest() {
    }

    public PublishRequest(String name, Data message) {
        this.name = name;
        this.message = message;
    }

    @Override
    protected Operation prepareOperation() {
        return new PublishOperation(this.name, this.message);
    }

    @Override
    protected int getPartition() {
        Data key = this.getClientEngine().toData(this.name);
        return this.getClientEngine().getPartitionService().getPartitionId(key);
    }

    @Override
    protected int getReplicaIndex() {
        return 0;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:topicService";
    }

    @Override
    public int getFactoryId() {
        return TopicPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.message.writeData(out);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        ObjectDataInput in = reader.getRawDataInput();
        this.message = new Data();
        this.message.readData(in);
    }

    @Override
    public Permission getRequiredPermission() {
        return new TopicPermission(this.name, "publish");
    }
}

