/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.record;

import com.hazelcast.map.record.AbstractRecord;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.storage.DataRef;
import com.hazelcast.storage.Storage;

public class OffHeapRecord
extends AbstractRecord<Data> {
    private Storage<DataRef> storage;
    private DataRef valueRef;

    public OffHeapRecord() {
    }

    public OffHeapRecord(Storage<DataRef> storage, Data key, Data value, boolean statisticsEnabled) {
        super(key, statisticsEnabled);
        this.storage = storage;
        this.setValue(value);
    }

    @Override
    public long getCost() {
        long size = super.getCost();
        size += 4L;
        return size += (long)(4 + (this.valueRef == null ? 0 : this.valueRef.heapCost()));
    }

    @Override
    public Data getValue() {
        if (this.valueRef != null) {
            return this.storage.get(this.key.getPartitionHash(), this.valueRef);
        }
        return null;
    }

    @Override
    public void setValue(Data value) {
        this.invalidate();
        if (value != null) {
            this.valueRef = this.storage.put(this.key.getPartitionHash(), value);
        }
    }

    @Override
    public void invalidate() {
        if (this.valueRef != null) {
            this.storage.remove(this.key.getPartitionHash(), this.valueRef);
        }
        this.valueRef = null;
    }
}

