/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor;

import com.hazelcast.executor.CancellationOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;

final class CancellableDelegatingFuture<V>
extends DelegatingFuture<V> {
    private final NodeEngine nodeEngine;
    private final String uuid;
    private final int partitionId;
    private final Address target;
    private volatile boolean cancelled;

    CancellableDelegatingFuture(Future future, NodeEngine nodeEngine, String uuid, int partitionId) {
        super(future, nodeEngine.getSerializationService());
        this.nodeEngine = nodeEngine;
        this.uuid = uuid;
        this.partitionId = partitionId;
        this.target = null;
    }

    CancellableDelegatingFuture(Future future, NodeEngine nodeEngine, String uuid, Address target) {
        super(future, nodeEngine.getSerializationService());
        this.nodeEngine = nodeEngine;
        this.uuid = uuid;
        this.target = target;
        this.partitionId = -1;
    }

    CancellableDelegatingFuture(Future future, V defaultValue, NodeEngine nodeEngine, String uuid, int partitionId) {
        super(future, nodeEngine.getSerializationService(), defaultValue);
        this.nodeEngine = nodeEngine;
        this.uuid = uuid;
        this.partitionId = partitionId;
        this.target = null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone() || this.cancelled) {
            return false;
        }
        CancellationOperation op = new CancellationOperation(this.uuid, mayInterruptIfRunning);
        InvocationBuilder builder = this.partitionId > -1 ? this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:executorService", (Operation)op, this.partitionId) : this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:executorService", (Operation)op, this.target);
        builder.setTryCount(50).setTryPauseMillis(250L);
        Invocation inv = builder.build();
        Future f = inv.invoke();
        try {
            Boolean b = (Boolean)f.get();
            if (b != null && b.booleanValue()) {
                this.setError(new CancellationException());
                this.cancelled = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            this.setDone();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }
}

