/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ConfigDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;

public class ScheduledExecutorConfig
implements IdentifiedDataSerializable {
    private static final int DEFAULT_POOL_SIZE = 16;
    private static final int DEFAULT_CAPACITY = 100;
    private static final int DEFAULT_DURABILITY = 1;
    private String name = "default";
    private int durability = 1;
    private int capacity = 100;
    private int poolSize = 16;
    private transient ScheduledExecutorConfigReadOnly readOnly;

    public ScheduledExecutorConfig() {
    }

    public ScheduledExecutorConfig(String name) {
        this.name = name;
    }

    public ScheduledExecutorConfig(String name, int durability, int capacity, int poolSize) {
        this.name = name;
        this.durability = durability;
        this.poolSize = poolSize;
        this.capacity = capacity;
    }

    public ScheduledExecutorConfig(ScheduledExecutorConfig config) {
        this(config.getName(), config.getDurability(), config.getCapacity(), config.getPoolSize());
    }

    public String getName() {
        return this.name;
    }

    public ScheduledExecutorConfig setName(String name) {
        this.name = name;
        return this;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public ScheduledExecutorConfig setPoolSize(int poolSize) {
        this.poolSize = Preconditions.checkPositive(poolSize, "Pool size should be greater than 0");
        return this;
    }

    public int getDurability() {
        return this.durability;
    }

    public ScheduledExecutorConfig setDurability(int durability) {
        this.durability = Preconditions.checkNotNegative(durability, "durability can't be smaller than 0");
        return this;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public ScheduledExecutorConfig setCapacity(int capacity) {
        this.capacity = Preconditions.checkNotNegative(capacity, "capacity can't be smaller than 0");
        return this;
    }

    public String toString() {
        return "ScheduledExecutorConfig{name='" + this.name + '\'' + ", durability=" + this.durability + ", poolSize-" + this.poolSize + ", capacity-" + this.capacity + '}';
    }

    ScheduledExecutorConfig getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new ScheduledExecutorConfigReadOnly(this);
        }
        return this.readOnly;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 32;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.durability);
        out.writeInt(this.capacity);
        out.writeInt(this.poolSize);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.durability = in.readInt();
        this.capacity = in.readInt();
        this.poolSize = in.readInt();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScheduledExecutorConfig)) {
            return false;
        }
        ScheduledExecutorConfig that = (ScheduledExecutorConfig)o;
        if (this.durability != that.durability) {
            return false;
        }
        if (this.capacity != that.capacity) {
            return false;
        }
        if (this.poolSize != that.poolSize) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public final int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.durability;
        result = 31 * result + this.capacity;
        result = 31 * result + this.poolSize;
        return result;
    }

    static class ScheduledExecutorConfigReadOnly
    extends ScheduledExecutorConfig {
        ScheduledExecutorConfigReadOnly(ScheduledExecutorConfig config) {
            super(config);
        }

        @Override
        public ScheduledExecutorConfig setName(String name) {
            throw new UnsupportedOperationException("This config is read-only scheduled executor: " + this.getName());
        }

        @Override
        public ScheduledExecutorConfig setDurability(int durability) {
            throw new UnsupportedOperationException("This config is read-only scheduled executor: " + this.getName());
        }

        @Override
        public ScheduledExecutorConfig setPoolSize(int poolSize) {
            throw new UnsupportedOperationException("This config is read-only scheduled executor: " + this.getName());
        }

        @Override
        public ScheduledExecutorConfig setCapacity(int capacity) {
            throw new UnsupportedOperationException("This config is read-only scheduled executor: " + this.getName());
        }
    }
}

