/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XmlProperty
extends Task {
    private static final String ID = "id";
    private static final String REF_ID = "refid";
    private static final String LOCATION = "location";
    private static final String VALUE = "value";
    private static final String PATH = "path";
    private static final String PATHID = "pathid";
    private static final String[] ATTRIBUTES = new String[]{"id", "refid", "location", "value", "path", "pathid"};
    private File src;
    private String prefix;
    private boolean keepRoot;
    private boolean validate;
    private boolean collapseAttributes;
    private boolean semanticAttributes;
    private boolean includeSemanticAttribute;
    private File rootDirectory;
    private FileUtils fileUtils;
    private Hashtable addedAttributes;

    public void init() {
        super.init();
    }

    public void execute() throws BuildException {
        if (this.getFile() == null) {
            String string = "XmlProperty task requires a file attribute";
            throw new BuildException(string);
        }
        try {
            this.log("Loading " + this.src.getAbsolutePath(), 3);
            if (this.src.exists()) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(this.validate);
                documentBuilderFactory.setNamespaceAware(false);
                Document document = documentBuilderFactory.newDocumentBuilder().parse(this.src);
                Element element = document.getDocumentElement();
                this.addedAttributes = new Hashtable();
                if (this.keepRoot) {
                    this.addNodeRecursively(element, this.prefix, null);
                } else {
                    NodeList nodeList = element.getChildNodes();
                    int n = nodeList.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        this.addNodeRecursively(nodeList.item(n2), this.prefix, null);
                        ++n2;
                    }
                }
            } else {
                this.log("Unable to find property file: " + this.src.getAbsolutePath(), 3);
            }
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            throw new BuildException(exception);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BuildException(parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    private final void addNodeRecursively(Node node, String string, Object object) {
        String string2 = string;
        if (node.getNodeType() != 3) {
            if (string.trim().length() > 0) {
                string2 = string2 + '.';
            }
            string2 = string2 + node.getNodeName();
        }
        Object object2 = this.processNode(node, string2, object);
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.addNodeRecursively(nodeList.item(n2), string2, object2);
                ++n2;
            }
        }
    }

    void addNodeRecursively(Node node, String string) {
        this.addNodeRecursively(node, string, null);
    }

    public Object processNode(Node node, String string, Object object) {
        Object object2;
        Object object3 = null;
        String string2 = null;
        if (node.hasAttributes()) {
            object2 = node.getAttributes();
            Node node2 = object2.getNamedItem(ID);
            string2 = this.semanticAttributes && node2 != null ? node2.getNodeValue() : null;
            int n = 0;
            while (n < object2.getLength()) {
                String string3;
                String string4;
                Node node3 = object2.item(n);
                if (!this.semanticAttributes) {
                    string4 = this.getAttributeName(node3);
                    string3 = this.getAttributeValue(node3);
                    this.addProperty(string + string4, string3, null);
                } else {
                    Path path;
                    string4 = node3.getNodeName();
                    string3 = this.getAttributeValue(node3);
                    Path path2 = path = object != null && object instanceof Path ? (Path)object : null;
                    if (!string4.equals(ID)) {
                        if (path != null && string4.equals(PATH)) {
                            path.setPath(string3);
                        } else if (object instanceof Path && string4.equals(REF_ID)) {
                            path.setPath(string3);
                        } else if (object instanceof Path && string4.equals(LOCATION)) {
                            path.setLocation(this.resolveFile(string3));
                        } else if (string4.equals(PATHID)) {
                            if (object != null) {
                                throw new BuildException("XmlProperty does not support nested paths");
                            }
                            object3 = new Path(this.getProject());
                            this.getProject().addReference(string3, object3);
                        } else {
                            String string5 = this.getAttributeName(node3);
                            this.addProperty(string + string5, string3, string2);
                        }
                    }
                }
                ++n;
            }
        }
        object2 = null;
        if (node.getNodeType() == 3) {
            object2 = this.getAttributeValue(node);
        } else if (node.getNodeType() == 1 && node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 4) {
            object2 = node.getFirstChild().getNodeValue();
        }
        if (object2 != null) {
            if (this.semanticAttributes && string2 == null && object instanceof String) {
                string2 = (String)object;
                System.out.println("Setting id = " + string2);
            }
            if (((String)object2).trim().length() != 0) {
                this.addProperty(string, (String)object2, string2);
            }
        }
        return object3 != null ? object3 : string2;
    }

    private final void addProperty(String string, String string2, String string3) {
        String string4 = string + ':' + string2;
        if (string3 != null) {
            string4 = string4 + "(id=" + string3 + ')';
        }
        this.log(string4, 4);
        if (this.addedAttributes.containsKey(string)) {
            string2 = (String)this.addedAttributes.get(string) + ',' + string2;
            this.getProject().setProperty(string, string2);
        } else {
            this.getProject().setNewProperty(string, string2);
        }
        this.addedAttributes.put(string, string2);
        if (string3 != null) {
            this.getProject().addReference(string3, string2);
        }
    }

    private final String getAttributeName(Node node) {
        String string = node.getNodeName();
        if (this.semanticAttributes) {
            if (string.equals(REF_ID)) {
                return "";
            }
            if (!XmlProperty.isSemanticAttribute(string) || this.includeSemanticAttribute) {
                return "." + string;
            }
            return "";
        }
        if (this.collapseAttributes) {
            return "." + string;
        }
        return "(" + string + ')';
    }

    private static final boolean isSemanticAttribute(String string) {
        int n = 0;
        while (n < ATTRIBUTES.length) {
            if (string.equals(ATTRIBUTES[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final String getAttributeValue(Node node) {
        String string = node.getNodeValue().trim();
        if (this.semanticAttributes) {
            Object object;
            String string2 = node.getNodeName();
            string = this.getProject().replaceProperties(string);
            if (string2.equals(LOCATION)) {
                File file = this.resolveFile(string);
                return file.getPath();
            }
            if (string2.equals(REF_ID) && (object = this.getProject().getReference(string)) != null) {
                return object.toString();
            }
        }
        return string;
    }

    public void setFile(File file) {
        this.src = file;
    }

    public void setPrefix(String string) {
        this.prefix = string.trim();
    }

    public void setKeeproot(boolean bl) {
        this.keepRoot = bl;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    public void setCollapseAttributes(boolean bl) {
        this.collapseAttributes = bl;
    }

    public void setSemanticAttributes(boolean bl) {
        this.semanticAttributes = bl;
    }

    public void setRootDirectory(File file) {
        this.rootDirectory = file;
    }

    public void setIncludeSemanticAttribute(boolean bl) {
        this.includeSemanticAttribute = bl;
    }

    protected File getFile() {
        return this.src;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected boolean getKeeproot() {
        return this.keepRoot;
    }

    protected boolean getValidate() {
        return this.validate;
    }

    protected boolean getCollapseAttributes() {
        return this.collapseAttributes;
    }

    protected boolean getSemanticAttributes() {
        return this.semanticAttributes;
    }

    protected File getRootDirectory() {
        return this.rootDirectory;
    }

    protected boolean getIncludeSementicAttribute() {
        return this.includeSemanticAttribute;
    }

    private final File resolveFile(String string) {
        if (this.rootDirectory == null) {
            return this.getProject().resolveFile(string);
        }
        return this.fileUtils.resolveFile(this.rootDirectory, string);
    }

    private final /* synthetic */ void this() {
        this.prefix = "";
        this.keepRoot = true;
        this.validate = false;
        this.collapseAttributes = false;
        this.semanticAttributes = false;
        this.includeSemanticAttribute = false;
        this.rootDirectory = null;
        this.fileUtils = FileUtils.newFileUtils();
        this.addedAttributes = new Hashtable();
    }

    public XmlProperty() {
        this.this();
    }
}

