/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.filetransfer.FileTransferListener;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class FileTransferManager {
    private final FileTransferNegotiator fileTransferNegotiator;
    private List listeners;
    private XMPPConnection connection;

    public FileTransferManager(XMPPConnection connection) {
        this.connection = connection;
        this.fileTransferNegotiator = FileTransferNegotiator.getInstanceFor(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileTransferListener(FileTransferListener li) {
        if (this.listeners == null) {
            this.initListeners();
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(li);
        }
    }

    private void initListeners() {
        this.listeners = new ArrayList();
        this.connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                FileTransferManager.this.fireNewRequest((StreamInitiation)packet);
            }
        }, new AndFilter(new PacketTypeFilter(StreamInitiation.class), new IQTypeFilter(IQ.Type.SET)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNewRequest(StreamInitiation initiation) {
        FileTransferListener[] listeners = null;
        List list = this.listeners;
        synchronized (list) {
            listeners = new FileTransferListener[this.listeners.size()];
            this.listeners.toArray(listeners);
        }
        FileTransferRequest request = new FileTransferRequest(this, initiation);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].fileTransferRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileTransferListener(FileTransferListener li) {
        if (this.listeners == null) {
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(li);
        }
    }

    public OutgoingFileTransfer createOutgoingFileTransfer(String userID) {
        if (userID == null || StringUtils.parseName(userID).length() <= 0 || StringUtils.parseServer(userID).length() <= 0 || StringUtils.parseResource(userID).length() <= 0) {
            throw new IllegalArgumentException("The provided user id was not fully qualified");
        }
        return new OutgoingFileTransfer(this.connection.getUser(), userID, this.fileTransferNegotiator.getNextStreamID(), this.fileTransferNegotiator);
    }

    protected IncomingFileTransfer createIncomingFileTransfer(FileTransferRequest request) {
        if (request == null) {
            throw new NullPointerException("RecieveRequest cannot be null");
        }
        IncomingFileTransfer transfer = new IncomingFileTransfer(request, this.fileTransferNegotiator);
        transfer.setFileInfo(request.getFileName(), request.getFileSize());
        return transfer;
    }

    protected void rejectIncomingFileTransfer(FileTransferRequest request) {
        StreamInitiation initiation = request.getStreamInitiation();
        IQ rejection = FileTransferNegotiator.createIQ(initiation.getPacketID(), initiation.getFrom(), initiation.getTo(), IQ.Type.ERROR);
        rejection.setError(new XMPPError(XMPPError.Condition.forbidden));
        this.connection.sendPacket(rejection);
    }
}

