/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MapEntriesWithPagingPredicateCodec {
    public static final MapMessageType REQUEST_TYPE = MapMessageType.MAP_ENTRIESWITHPAGINGPREDICATE;
    public static final int RESPONSE_TYPE = 108;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, Data predicate) {
        int requiredDataSize = RequestParameters.calculateDataSize(name, predicate);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        clientMessage.set(predicate);
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        Data predicate = null;
        parameters.predicate = predicate = clientMessage.getData();
        return parameters;
    }

    public static ClientMessage encodeResponse(Map<Data, Data> map) {
        int requiredDataSize = ResponseParameters.calculateDataSize(map);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(108);
        Set<Data> map_keySet = map.keySet();
        clientMessage.set(map_keySet.size());
        for (Data map_keySet_item : map_keySet) {
            clientMessage.set(map_keySet_item);
        }
        Collection<Data> map_values = map.values();
        clientMessage.set(map_values.size());
        for (Data map_values_item : map_values) {
            clientMessage.set(map_values_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        HashMap<Data, Data> map = null;
        int map_keySet_size = clientMessage.getInt();
        ArrayList<Data> map_keySet = new ArrayList<Data>(map_keySet_size);
        for (int map_keySet_index = 0; map_keySet_index < map_keySet_size; ++map_keySet_index) {
            Data map_keySet_item = clientMessage.getData();
            map_keySet.add(map_keySet_item);
        }
        int map_values_size = clientMessage.getInt();
        ArrayList<Data> map_values = new ArrayList<Data>(map_values_size);
        for (int map_values_index = 0; map_values_index < map_values_size; ++map_values_index) {
            Data map_values_item = clientMessage.getData();
            map_values.add(map_values_item);
        }
        map = new HashMap<Data, Data>();
        for (int map_index = 0; map_index < map_keySet_size; ++map_index) {
            map.put((Data)map_keySet.get(map_index), (Data)map_values.get(map_index));
        }
        parameters.map = map;
        return parameters;
    }

    public static class ResponseParameters {
        public Map<Data, Data> map;

        public static int calculateDataSize(Map<Data, Data> map) {
            int dataSize = ClientMessage.HEADER_SIZE;
            Set<Data> map_keySet = map.keySet();
            dataSize += 4;
            for (Data map_keySet_item : map_keySet) {
                dataSize += ParameterUtil.calculateDataSize(map_keySet_item);
            }
            Collection<Data> map_values = map.values();
            dataSize += 4;
            for (Data map_values_item : map_values) {
                dataSize += ParameterUtil.calculateDataSize(map_values_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final MapMessageType TYPE = REQUEST_TYPE;
        public String name;
        public Data predicate;

        public static int calculateDataSize(String name, Data predicate) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateStringDataSize(name);
            return dataSize += ParameterUtil.calculateDataSize(predicate);
        }
    }
}

