/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

public class GrowingByteArray {
    private byte[] bytes;
    private int head;

    public GrowingByteArray() {
        this(500);
    }

    public GrowingByteArray(int initialsize) {
        this.bytes = new byte[initialsize];
    }

    public GrowingByteArray add(byte b) {
        if (this.head + 1 == this.bytes.length) {
            this.grow(this.bytes.length);
        }
        this.bytes[this.head++] = b;
        return this;
    }

    public GrowingByteArray add(GrowingByteArray growingByteArray) {
        if (this.head + growingByteArray.head + 1 > this.bytes.length) {
            this.grow(growingByteArray.head);
        }
        System.arraycopy(growingByteArray.bytes, 0, this.bytes, this.head, growingByteArray.head);
        this.head += growingByteArray.head;
        return this;
    }

    public GrowingByteArray add(byte[] bytearray) {
        if (this.head + bytearray.length + 1 > this.bytes.length) {
            this.grow(bytearray.length);
        }
        System.arraycopy(bytearray, 0, this.bytes, this.head, bytearray.length);
        this.head += bytearray.length;
        return this;
    }

    public byte[] get() {
        byte[] result = new byte[this.head];
        System.arraycopy(this.bytes, 0, result, 0, this.head);
        return result;
    }

    private void grow(int size) {
        byte[] newBytes = new byte[this.bytes.length + size];
        System.arraycopy(this.bytes, 0, newBytes, 0, this.head);
        this.bytes = newBytes;
    }

    public int length() {
        return this.head;
    }

    public GrowingByteArray reset() {
        this.head = 0;
        return this;
    }

    public String toString() {
        return new String(this.bytes, 0, this.head);
    }
}

