/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import javax.net.SocketFactory;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joscar.net.ClientConnEvent;
import net.kano.joscar.net.ClientConnListener;
import net.kano.joscar.net.ClientConnStreamHandler;

public class ClientConn {
    public static final State STATE_NOT_CONNECTED = new State("NOT_CONNECTED");
    public static final State STATE_INITING = new State("INITING");
    public static final State STATE_RESOLVING = new State("RESOLVING");
    public static final State STATE_CONNECTING = new State("CONNECTING");
    public static final State STATE_CONNECTED = new State("CONNECTED");
    public static final State STATE_FAILED = new State("FAILED");
    public static final State REASON_ON_PURPOSE = new State("ON_PURPOSE");
    public static final State REASON_CONN_CLOSED = new State("CONN_CLOSED");
    private State state = STATE_NOT_CONNECTED;
    private String host = null;
    private InetAddress ip = null;
    private int port = -1;
    private CopyOnWriteArrayList connListeners = new CopyOnWriteArrayList();
    private SocketFactory socketFactory = null;
    private Socket socket = null;
    private ConnectionThread connThread = null;
    private ClientConnStreamHandler streamHandler = null;

    public ClientConn() {
    }

    public ClientConn(String string, int n) {
        this.host = string;
        this.port = n;
    }

    public ClientConn(InetAddress inetAddress, int n) {
        this.ip = inetAddress;
        this.port = n;
    }

    public final void addConnListener(ClientConnListener clientConnListener) {
        DefensiveTools.checkNull(clientConnListener, "l");
        this.connListeners.addIfAbsent(clientConnListener);
    }

    public final void removeConnListener(ClientConnListener clientConnListener) {
        DefensiveTools.checkNull(clientConnListener, "l");
        this.connListeners.remove(clientConnListener);
    }

    public final synchronized Socket getSocket() {
        return this.socket;
    }

    public final synchronized String getHost() {
        return this.host;
    }

    public final synchronized void setHost(String string) {
        this.host = string;
    }

    public final synchronized InetAddress getIpAddress() {
        return this.ip;
    }

    public final synchronized void setIpAddress(InetAddress inetAddress) {
        this.ip = inetAddress;
    }

    public final synchronized int getPort() {
        return this.port;
    }

    public final synchronized void setPort(int n) {
        this.port = n;
    }

    public final synchronized State getState() {
        return this.state;
    }

    private final synchronized void setState(State state, Object object) {
        if (this.state == state || this.state == STATE_FAILED && state == STATE_NOT_CONNECTED) {
            return;
        }
        State state2 = this.state;
        this.state = state;
        ClientConnEvent clientConnEvent = new ClientConnEvent(this, state2, this.state, object);
        Iterator iterator = this.connListeners.iterator();
        while (iterator.hasNext()) {
            ClientConnListener clientConnListener = (ClientConnListener)iterator.next();
            clientConnListener.stateChanged(clientConnEvent);
        }
    }

    private final synchronized void setSocket(Socket socket) {
        this.socket = socket;
    }

    public final synchronized void connect() throws IllegalStateException {
        if (this.state != STATE_NOT_CONNECTED && this.state != STATE_FAILED) {
            throw new IllegalStateException("I am already connected/connecting");
        }
        if (this.host == null && this.ip == null) {
            throw new IllegalStateException("either host or ip must be non-null");
        }
        if (this.host != null && this.ip != null) {
            throw new IllegalStateException("host and ip may not both be non-null");
        }
        if (this.port == -1) {
            throw new IllegalStateException("port must not be -1");
        }
        this.setState(STATE_INITING, null);
        Object object = this.host == null ? this.ip : this.host;
        this.connThread = new ConnectionThread(MiscTools.getClassName(this) + " to " + object + ":" + this.port);
        try {
            this.connThread.start();
        }
        catch (Throwable throwable) {
            this.setState(STATE_FAILED, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized void processError(Throwable throwable) {
        DefensiveTools.checkNull(throwable, "t");
        if (this.state == STATE_NOT_CONNECTED || this.state == STATE_FAILED) {
            return;
        }
        try {
            this.closeConn();
        }
        finally {
            this.setState(STATE_NOT_CONNECTED, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void disconnect() {
        if (this.state == STATE_NOT_CONNECTED || this.state == STATE_FAILED) {
            return;
        }
        try {
            this.closeConn();
        }
        finally {
            this.setState(STATE_NOT_CONNECTED, REASON_ON_PURPOSE);
        }
    }

    private synchronized void closeConn() {
        if (this.connThread != null) {
            this.connThread.cancel();
            this.connThread = null;
        }
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final synchronized void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public final synchronized SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public final synchronized void setStreamHandler(ClientConnStreamHandler clientConnStreamHandler) {
        this.streamHandler = clientConnStreamHandler;
    }

    public final synchronized ClientConnStreamHandler getStreamHandler() {
        return this.streamHandler;
    }

    private final Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SocketFactory socketFactory = this.getSocketFactory();
        if (socketFactory != null) {
            return socketFactory.createSocket(inetAddress, n);
        }
        return new Socket(inetAddress, n);
    }

    static /* synthetic */ InetAddress access$100(ClientConn clientConn) {
        return clientConn.ip;
    }

    static /* synthetic */ String access$200(ClientConn clientConn) {
        return clientConn.host;
    }

    static /* synthetic */ void access$300(ClientConn clientConn, State state, Object object) {
        clientConn.setState(state, object);
    }

    static /* synthetic */ int access$400(ClientConn clientConn) {
        return clientConn.port;
    }

    static /* synthetic */ Socket access$500(ClientConn clientConn, InetAddress inetAddress, int n) throws IOException {
        return clientConn.createSocket(inetAddress, n);
    }

    static /* synthetic */ void access$600(ClientConn clientConn, Socket socket) {
        clientConn.setSocket(socket);
    }

    public static final class State {
        private final String name;

        private State(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    private class ConnectionThread
    extends Thread {
        private boolean cancelled;

        public ConnectionThread(String string) {
            super(string);
            this.cancelled = false;
        }

        public void cancel() {
            this.cancelled = true;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

