/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl;

import com.hazelcast.cluster.impl.ConfigCheck;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class JoinMessage
implements DataSerializable {
    protected byte packetVersion;
    protected int buildNumber;
    protected Address address;
    protected String uuid;
    protected ConfigCheck configCheck;
    protected int memberCount;

    public JoinMessage() {
    }

    public JoinMessage(byte packetVersion, int buildNumber, Address address, String uuid, ConfigCheck configCheck, int memberCount) {
        this.packetVersion = packetVersion;
        this.buildNumber = buildNumber;
        this.address = address;
        this.uuid = uuid;
        this.configCheck = configCheck;
        this.memberCount = memberCount;
    }

    public byte getPacketVersion() {
        return this.packetVersion;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public Address getAddress() {
        return this.address;
    }

    public String getUuid() {
        return this.uuid;
    }

    public ConfigCheck getConfigCheck() {
        return this.configCheck;
    }

    public int getMemberCount() {
        return this.memberCount;
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.packetVersion = in.readByte();
        this.buildNumber = in.readInt();
        this.address = new Address();
        this.address.readData(in);
        this.uuid = in.readUTF();
        this.configCheck = new ConfigCheck();
        this.configCheck.readData(in);
        this.memberCount = in.readInt();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeByte(this.packetVersion);
        out.writeInt(this.buildNumber);
        this.address.writeData(out);
        out.writeUTF(this.uuid);
        this.configCheck.writeData(out);
        out.writeInt(this.memberCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("JoinMessage");
        sb.append("{packetVersion=").append(this.packetVersion);
        sb.append(", buildNumber=").append(this.buildNumber);
        sb.append(", address=").append(this.address);
        sb.append(", uuid='").append(this.uuid).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

