/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class SsiRightsCmd
extends SsiCommand {
    private static final int TYPE_MAXIMA = 4;
    private final int[] maxima;

    protected SsiRightsCmd(SnacPacket snacPacket) {
        super(3);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        Tlv tlv = immutableTlvChain.getLastTlv(4);
        if (tlv != null) {
            ByteBlock byteBlock2 = tlv.getData();
            this.maxima = new int[byteBlock2.getLength() / 2];
            for (int i = 0; i < this.maxima.length; ++i) {
                this.maxima[i] = BinaryTools.getUShort(byteBlock2, i * 2);
            }
        } else {
            this.maxima = null;
        }
    }

    public SsiRightsCmd(int[] nArray) {
        super(3);
        this.maxima = (int[])(nArray == null ? null : nArray.clone());
    }

    public final int[] getMaxima() {
        return (int[])(this.maxima == null ? null : this.maxima.clone());
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.maxima != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < this.maxima.length; ++i) {
                    BinaryTools.writeUShort(byteArrayOutputStream, this.maxima[i]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ByteBlock byteBlock = ByteBlock.wrap(byteArrayOutputStream.toByteArray());
            new Tlv(4, byteBlock).write(outputStream);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.maxima.length * 12);
        if (this.maxima != null) {
            for (int i = 0; i < this.maxima.length; ++i) {
                stringBuffer.append("0x");
                stringBuffer.append(Integer.toHexString(i));
                stringBuffer.append(": ");
                stringBuffer.append(this.maxima[i]);
                stringBuffer.append(", ");
            }
        }
        return "SsiRightsCmd: " + this.maxima.length + " maxima: " + stringBuffer;
    }
}

