/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import net.kano.joscar.DefensiveTools;

public abstract class ConnProcessor {
    private boolean attached = false;
    private InputStream in = null;
    private OutputStream out = null;

    public final synchronized void attachToSocket(Socket socket) throws IOException {
        DefensiveTools.checkNull(socket, "socket");
        this.attachToInput(socket.getInputStream());
        this.attachToOutput(socket.getOutputStream());
    }

    public final synchronized void attachToInput(InputStream inputStream) {
        DefensiveTools.checkNull(inputStream, "in");
        this.in = inputStream;
        this.attached = true;
    }

    public final synchronized void attachToOutput(OutputStream outputStream) {
        DefensiveTools.checkNull(outputStream, "out");
        this.out = outputStream;
        this.attached = true;
    }

    protected final synchronized boolean isAttached() {
        return this.attached;
    }

    protected final synchronized InputStream getInputStream() {
        return this.in;
    }

    protected final synchronized OutputStream getOutputStream() {
        return this.out;
    }

    public final synchronized void detach() {
        this.in = null;
        this.out = null;
        this.attached = false;
    }
}

