/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapterFactory;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.SourceFileScanner;
import org.apache.tools.ant.util.facade.FacadeTaskHelper;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Javac
extends MatchingTask {
    private static final String FAIL_MSG = "Compile failed; see the compiler error output for details.";
    private Path src;
    private File destDir;
    private Path compileClasspath;
    private Path compileSourcepath;
    private String encoding;
    private boolean debug;
    private boolean optimize;
    private boolean deprecation;
    private boolean depend;
    private boolean verbose;
    private String target;
    private Path bootclasspath;
    private Path extdirs;
    private boolean includeAntRuntime;
    private boolean includeJavaRuntime;
    private boolean fork;
    private String forkedExecutable;
    private boolean nowarn;
    private String memoryInitialSize;
    private String memoryMaximumSize;
    private FacadeTaskHelper facade;
    protected boolean failOnError;
    protected boolean listFiles;
    protected File[] compileList;
    private String source;
    private String debugLevel;
    private File tmpDir;

    public String getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(String string) {
        this.debugLevel = string;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path path) {
        if (this.src == null) {
            this.src = path;
        } else {
            this.src.append(path);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setSourcepath(Path path) {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = path;
        } else {
            this.compileSourcepath.append(path);
        }
    }

    public Path getSourcepath() {
        return this.compileSourcepath;
    }

    public Path createSourcepath() {
        if (this.compileSourcepath == null) {
            this.compileSourcepath = new Path(this.getProject());
        }
        return this.compileSourcepath.createPath();
    }

    public void setSourcepathRef(Reference reference) {
        this.createSourcepath().setRefid(reference);
    }

    public void setClasspath(Path path) {
        if (this.compileClasspath == null) {
            this.compileClasspath = path;
        } else {
            this.compileClasspath.append(path);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setBootclasspath(Path path) {
        if (this.bootclasspath == null) {
            this.bootclasspath = path;
        } else {
            this.bootclasspath.append(path);
        }
    }

    public Path getBootclasspath() {
        return this.bootclasspath;
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.getProject());
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference reference) {
        this.createBootclasspath().setRefid(reference);
    }

    public void setExtdirs(Path path) {
        if (this.extdirs == null) {
            this.extdirs = path;
        } else {
            this.extdirs.append(path);
        }
    }

    public Path getExtdirs() {
        return this.extdirs;
    }

    public Path createExtdirs() {
        if (this.extdirs == null) {
            this.extdirs = new Path(this.getProject());
        }
        return this.extdirs.createPath();
    }

    public void setListfiles(boolean bl) {
        this.listFiles = bl;
    }

    public boolean getListfiles() {
        return this.listFiles;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setProceed(boolean bl) {
        this.failOnError = bl ^ true;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setDeprecation(boolean bl) {
        this.deprecation = bl;
    }

    public boolean getDeprecation() {
        return this.deprecation;
    }

    public void setMemoryInitialSize(String string) {
        this.memoryInitialSize = string;
    }

    public String getMemoryInitialSize() {
        return this.memoryInitialSize;
    }

    public void setMemoryMaximumSize(String string) {
        this.memoryMaximumSize = string;
    }

    public String getMemoryMaximumSize() {
        return this.memoryMaximumSize;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setOptimize(boolean bl) {
        this.optimize = bl;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public void setDepend(boolean bl) {
        this.depend = bl;
    }

    public boolean getDepend() {
        return this.depend;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getTarget() {
        return this.target;
    }

    public void setIncludeantruntime(boolean bl) {
        this.includeAntRuntime = bl;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean bl) {
        this.includeJavaRuntime = bl;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public void setFork(boolean bl) {
        this.fork = bl;
    }

    public void setExecutable(String string) {
        this.forkedExecutable = string;
    }

    public String getExecutable() {
        return this.forkedExecutable;
    }

    public boolean isForkedJavac() {
        boolean bl = false;
        if (this.fork || "extJavac".equals(this.getCompiler())) {
            bl = true;
        }
        return bl;
    }

    public String getJavacExecutable() {
        if (this.forkedExecutable == null && this.isForkedJavac()) {
            this.forkedExecutable = this.getSystemJavac();
        } else if (this.forkedExecutable != null && !this.isForkedJavac()) {
            this.forkedExecutable = null;
        }
        return this.forkedExecutable;
    }

    public void setNowarn(boolean bl) {
        this.nowarn = bl;
    }

    public boolean getNowarn() {
        return this.nowarn;
    }

    public ImplementationSpecificArgument createCompilerArg() {
        ImplementationSpecificArgument implementationSpecificArgument = new ImplementationSpecificArgument();
        this.facade.addImplementationArgument(implementationSpecificArgument);
        return implementationSpecificArgument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCurrentCompilerArgs() {
        String string = this.facade.getExplicitChoice();
        this.facade.setImplementation(this.getCompiler());
        try {
            String[] stringArray = this.facade.getArgs();
            Object var3_3 = null;
            this.facade.setImplementation(string);
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.facade.setImplementation(string);
            throw throwable;
        }
    }

    public void setTempdir(File file) {
        this.tmpDir = file;
    }

    public File getTempdir() {
        return this.tmpDir;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.resetFileLists();
        String[] stringArray = this.src.list();
        int n = 0;
        while (n < stringArray.length) {
            File file = this.getProject().resolveFile(stringArray[n]);
            if (!file.exists()) {
                throw new BuildException("srcdir \"" + file.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner directoryScanner = this.getDirectoryScanner(file);
            String[] stringArray2 = directoryScanner.getIncludedFiles();
            this.scanDir(file, this.destDir != null ? this.destDir : file, stringArray2);
            ++n;
        }
        this.compile();
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
    }

    protected void scanDir(File file, File file2, String[] stringArray) {
        GlobPatternMapper globPatternMapper = new GlobPatternMapper();
        globPatternMapper.setFrom("*.java");
        globPatternMapper.setTo("*.class");
        SourceFileScanner sourceFileScanner = new SourceFileScanner(this);
        File[] fileArray = sourceFileScanner.restrictAsFiles(stringArray, file, file2, globPatternMapper);
        if (fileArray.length > 0) {
            File[] fileArray2 = new File[this.compileList.length + fileArray.length];
            System.arraycopy(this.compileList, 0, fileArray2, 0, this.compileList.length);
            System.arraycopy(fileArray, 0, fileArray2, this.compileList.length, fileArray.length);
            this.compileList = fileArray2;
        }
    }

    public File[] getFileList() {
        return this.compileList;
    }

    protected boolean isJdkCompiler(String string) {
        boolean bl = false;
        if ("modern".equals(string) || "classic".equals(string) || "javac1.1".equals(string) || "javac1.2".equals(string) || "javac1.3".equals(string) || "javac1.4".equals(string) || "javac1.5".equals(string)) {
            bl = true;
        }
        return bl;
    }

    protected String getSystemJavac() {
        return JavaEnvUtils.getJdkExecutable("javac");
    }

    public void setCompiler(String string) {
        this.facade.setImplementation(string);
    }

    public String getCompiler() {
        String string = this.getCompilerVersion();
        if (this.fork) {
            if (this.isJdkCompiler(string)) {
                if (this.facade.hasBeenSet()) {
                    this.log("Since fork is true, ignoring compiler setting.", 1);
                }
                string = "extJavac";
            } else {
                this.log("Since compiler setting isn't classic or modern,ignoring fork setting.", 1);
            }
        }
        return string;
    }

    public String getCompilerVersion() {
        this.facade.setMagicValue(this.getProject().getProperty("build.compiler"));
        return this.facade.getImplementation();
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist or is not a directory", this.getLocation());
        }
    }

    protected void compile() {
        String string = this.getCompiler();
        if (this.compileList.length > 0) {
            this.log("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
            if (this.listFiles) {
                int n = 0;
                while (n < this.compileList.length) {
                    String string2 = this.compileList[n].getAbsolutePath();
                    this.log(string2);
                    ++n;
                }
            }
            CompilerAdapter compilerAdapter = CompilerAdapterFactory.getCompiler(string, this);
            compilerAdapter.setJavac(this);
            if (!compilerAdapter.execute()) {
                if (this.failOnError) {
                    throw new BuildException(FAIL_MSG, this.getLocation());
                }
                this.log(FAIL_MSG, 0);
            }
        }
    }

    private final /* synthetic */ void this() {
        this.debug = false;
        this.optimize = false;
        this.deprecation = false;
        this.depend = false;
        this.verbose = false;
        this.includeAntRuntime = true;
        this.includeJavaRuntime = false;
        this.fork = false;
        this.forkedExecutable = null;
        this.nowarn = false;
        this.facade = null;
        this.failOnError = true;
        this.listFiles = false;
        this.compileList = new File[0];
    }

    public Javac() {
        this.this();
        this.facade = JavaEnvUtils.isJavaVersion("1.1") ? new FacadeTaskHelper("javac1.1") : (JavaEnvUtils.isJavaVersion("1.2") ? new FacadeTaskHelper("javac1.2") : (JavaEnvUtils.isJavaVersion("1.3") ? new FacadeTaskHelper("javac1.3") : (JavaEnvUtils.isJavaVersion("1.4") ? new FacadeTaskHelper("javac1.4") : (JavaEnvUtils.isJavaVersion("1.5") ? new FacadeTaskHelper("javac1.5") : new FacadeTaskHelper("classic")))));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ImplementationSpecificArgument
    extends org.apache.tools.ant.util.facade.ImplementationSpecificArgument {
        public void setCompiler(String string) {
            super.setImplementation(string);
        }
    }
}

