/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.monitor;

import com.hazelcast.monitor.LocalInstanceOperationStats;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

abstract class LocalOperationStatsSupport
implements LocalInstanceOperationStats {
    long periodStart;
    long periodEnd;

    LocalOperationStatsSupport() {
    }

    public final long getPeriodStart() {
        return this.periodStart;
    }

    public final long getPeriodEnd() {
        return this.periodEnd;
    }

    public final void writeData(DataOutput out) throws IOException {
        out.writeLong(this.periodStart);
        out.writeLong(this.periodEnd);
        this.writeDataInternal(out);
    }

    abstract void writeDataInternal(DataOutput var1) throws IOException;

    public final void readData(DataInput in) throws IOException {
        this.periodStart = in.readLong();
        this.periodEnd = in.readLong();
        this.readDataInternal(in);
    }

    abstract void readDataInternal(DataInput var1) throws IOException;

    class OperationStat
    implements DataSerializable {
        long count;
        long totalLatency;

        public OperationStat() {
            this(0L, 0L);
        }

        public OperationStat(long c, long l) {
            this.count = c;
            this.totalLatency = l;
        }

        public String toString() {
            return "OperationStat{count=" + this.count + ", averageLatency=" + (this.count == 0L ? 0L : this.totalLatency / this.count) + '}';
        }

        public void writeData(DataOutput out) throws IOException {
            out.writeLong(this.count);
            out.writeLong(this.totalLatency);
        }

        public void readData(DataInput in) throws IOException {
            this.count = in.readLong();
            this.totalLatency = in.readLong();
        }

        public void add(long c, long l) {
            this.count += c;
            this.totalLatency += l;
        }
    }
}

