/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import net.sf.cindy.Message;
import net.sf.cindy.impl.Constants;
import net.sf.cindy.impl.SocketSession;
import net.sf.cindy.util.ByteBufferUtils;
import net.sf.cindy.util.queue.Queue;
import net.sf.cindy.util.queue.QueueFactory;

public class SecureSocketSession
extends SocketSession {
    private volatile boolean firstHandshake = true;
    private volatile boolean handshakeCompleted = false;
    private final Queue tempWriteQueue = QueueFactory.createQueue();
    private boolean useClientMode = true;
    private SSLContext sslc;
    private SSLEngine engine;
    private ByteBuffer decodedReadBuffer;
    private ByteBuffer encodedWriteBuffer;

    public void setSSLContext(SSLContext sSLContext) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set SSLContext after session have started");
        }
        this.sslc = sSLContext;
    }

    public SSLContext getSSLContext() {
        return this.sslc;
    }

    public void setUseClientMode(boolean bl) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("can't set useClientMode after session have started");
        }
        this.useClientMode = bl;
    }

    public boolean isHandshakeCompleted() {
        return this.handshakeCompleted;
    }

    public synchronized void start(boolean bl) throws IllegalStateException {
        if (this.sslc == null) {
            throw new IllegalStateException("SSLContext is null");
        }
        super.start(bl);
    }

    protected void dispatchMessageSent(Message message) {
        if (!(message instanceof HandshakeMessage)) {
            super.dispatchMessageSent(message);
        }
    }

    protected void dispatchSessionEstablished() {
        super.dispatchSessionEstablished();
        this.initSSLEngine();
        this.initBuffer();
        this.doHandshake();
    }

    protected void initSSLEngine() {
        Socket socket = this.getChannel().socket();
        this.engine = this.useClientMode ? this.sslc.createSSLEngine(socket.getInetAddress().getHostAddress(), socket.getPort()) : this.sslc.createSSLEngine();
        this.engine.setUseClientMode(this.useClientMode);
    }

    private void initBuffer() {
        SSLSession sSLSession = this.engine.getSession();
        if (sSLSession.getPacketBufferSize() > this.readBuffer.capacity()) {
            this.readBuffer = ByteBufferUtils.increaseCapacity(this.readBuffer, sSLSession.getPacketBufferSize() - this.readBuffer.capacity());
        }
        this.decodedReadBuffer = ByteBufferUtils.allocate(sSLSession.getApplicationBufferSize(), Constants.USE_DIRECT_BUFFER);
        this.encodedWriteBuffer = ByteBufferUtils.allocate(sSLSession.getPacketBufferSize(), Constants.USE_DIRECT_BUFFER);
    }

    public void handshake() {
        if (!this.handshakeCompleted) {
            return;
        }
        this.doHandshake();
    }

    private void doHandshake() {
        try {
            this.handshakeCompleted = false;
            this.engine.beginHandshake();
            if (this.useClientMode) {
                super.write(new HandshakeMessage());
            }
        }
        catch (SSLException sSLException) {
            this.dispatchException(sSLException);
            this.close();
        }
    }

    private ByteBuffer getContentFromEncodedWriteBuffer() {
        if (this.encodedWriteBuffer.hasRemaining()) {
            byte[] byArray = new byte[this.encodedWriteBuffer.remaining()];
            this.encodedWriteBuffer.get(byArray);
            this.encodedWriteBuffer.clear();
            return ByteBuffer.wrap(byArray);
        }
        return null;
    }

    public void write(Message message) throws IllegalArgumentException {
        if (this.firstHandshake) {
            this.tempWriteQueue.push(message);
        } else {
            super.write(message);
        }
    }

    public boolean blockWrite(Message message) throws IllegalArgumentException, IllegalStateException {
        if (this.isHandshakeCompleted()) {
            return super.blockWrite(message);
        }
        throw new IllegalStateException("can't block write until handshake completed");
    }

    protected synchronized void handshakeCompleted() {
        this.handshakeCompleted = true;
        if (this.firstHandshake) {
            Message message;
            this.firstHandshake = false;
            while ((message = (Message)this.tempWriteQueue.pop()) != null) {
                this.write(message);
            }
        }
    }

    protected void onUnregister() {
        if (this.engine != null) {
            this.engine.closeOutbound();
            if (!this.engine.isInboundDone()) {
                ByteBuffer[] byteBufferArray = this.messageToByteBuffer(new HandshakeMessage());
                try {
                    long l;
                    while (ByteBufferUtils.hasRemaining(byteBufferArray) && (l = this.getChannel().write(byteBufferArray)) != -1L) {
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                this.engine.closeInbound();
            }
            catch (SSLException sSLException) {
                // empty catch block
            }
            this.engine = null;
        }
        this.firstHandshake = true;
        this.handshakeCompleted = false;
        this.tempWriteQueue.clear();
        super.onUnregister();
    }

    protected ByteBuffer[] messageToByteBuffer(Message message) {
        ByteBuffer[] byteBufferArray = super.messageToByteBuffer(message);
        if (byteBufferArray == null) {
            byteBufferArray = new ByteBuffer[]{};
        }
        try {
            block8: {
                while (true) {
                    SSLEngineResult sSLEngineResult = this.engine.wrap(byteBufferArray, this.encodedWriteBuffer);
                    SSLEngineResult.Status status = sSLEngineResult.getStatus();
                    SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    if (status == SSLEngineResult.Status.OK) {
                        if (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) continue;
                            if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                                this.engine.getDelegatedTask().run();
                                continue;
                            }
                            if (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) continue;
                            this.handshakeCompleted();
                        }
                        break block8;
                    }
                    if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        this.encodedWriteBuffer = ByteBufferUtils.increaseCapacity(this.encodedWriteBuffer, Constants.BUFFER_CAPACITY);
                        continue;
                    }
                    if (status == SSLEngineResult.Status.CLOSED) break block8;
                    if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) break;
                }
                this.close(false);
                return null;
            }
            this.encodedWriteBuffer.flip();
            return new ByteBuffer[]{this.getContentFromEncodedWriteBuffer()};
        }
        catch (SSLException sSLException) {
            this.dispatchException(sSLException);
            this.close();
            return null;
        }
    }

    protected void recognizeMessageAndDispatch(ByteBuffer byteBuffer) {
        try {
            boolean bl;
            boolean bl2;
            block11: {
                bl2 = false;
                bl = false;
                while (true) {
                    SSLEngineResult sSLEngineResult = this.engine.unwrap(byteBuffer, this.decodedReadBuffer);
                    SSLEngineResult.Status status = sSLEngineResult.getStatus();
                    SSLEngineResult.HandshakeStatus handshakeStatus = sSLEngineResult.getHandshakeStatus();
                    if (status == SSLEngineResult.Status.OK) {
                        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                            bl2 = true;
                            continue;
                        }
                        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.engine.getDelegatedTask().run();
                            continue;
                        }
                        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) continue;
                        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                            super.write(new HandshakeMessage());
                        } else {
                            if (handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED) continue;
                            this.handshakeCompleted();
                        }
                        break block11;
                    }
                    if (status == SSLEngineResult.Status.BUFFER_UNDERFLOW) break block11;
                    if (status == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        this.decodedReadBuffer = ByteBufferUtils.increaseCapacity(this.decodedReadBuffer, Constants.BUFFER_CAPACITY);
                        continue;
                    }
                    if (status == SSLEngineResult.Status.CLOSED) break;
                }
                bl = true;
            }
            if (bl2) {
                this.decodedReadBuffer.flip();
                super.recognizeMessageAndDispatch(this.decodedReadBuffer);
                this.decodedReadBuffer.compact();
            }
            if (bl) {
                this.close();
            }
        }
        catch (SSLException sSLException) {
            this.dispatchException(sSLException);
            this.close();
        }
    }

    private static class HandshakeMessage
    implements Message {
        private HandshakeMessage() {
        }

        public boolean readFromBuffer(ByteBuffer byteBuffer) {
            return false;
        }

        public ByteBuffer[] toByteBuffer() {
            return null;
        }
    }
}

