/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.impl.AttributeType;
import com.hazelcast.query.impl.ComparisonType;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.MultiResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.SingleResultSet;
import com.hazelcast.query.impl.SortedIndexStore;
import com.hazelcast.query.impl.TypeConverters;
import com.hazelcast.query.impl.UnsortedIndexStore;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class IndexImpl
implements Index {
    public static final NullObject NULL = new NullObject();
    private final ConcurrentMap<Data, Comparable> recordValues = new ConcurrentHashMap<Data, Comparable>(1000);
    private final IndexStore indexStore;
    private final String attribute;
    private final boolean ordered;
    private volatile AttributeType attributeType;

    public IndexImpl(String attribute, boolean ordered) {
        this.attribute = attribute;
        this.ordered = ordered;
        this.indexStore = ordered ? new SortedIndexStore() : new UnsortedIndexStore();
    }

    @Override
    public void removeEntryIndex(Data indexKey) {
        Comparable oldValue = (Comparable)this.recordValues.remove(indexKey);
        if (oldValue != null) {
            this.indexStore.removeIndex(oldValue, indexKey);
        }
    }

    @Override
    public void clear() {
        this.recordValues.clear();
        this.indexStore.clear();
        this.attributeType = null;
    }

    ConcurrentMap<Data, QueryableEntry> getRecordMap(Comparable indexValue) {
        return this.indexStore.getRecordMap(indexValue);
    }

    @Override
    public void saveEntryIndex(QueryableEntry e) throws QueryException {
        if (this.attributeType == null) {
            this.attributeType = e.getAttributeType(this.attribute);
        }
        Data key = e.getIndexKey();
        Comparable oldValue = (Comparable)this.recordValues.remove(key);
        Comparable newValue = e.getAttribute(this.attribute);
        if (newValue == null) {
            newValue = NULL;
        } else if (newValue.getClass().isEnum()) {
            newValue = TypeConverters.ENUM_CONVERTER.convert(newValue);
        }
        this.recordValues.put(key, newValue);
        if (oldValue == null) {
            this.indexStore.newIndex(newValue, e);
        } else {
            this.indexStore.removeIndex(oldValue, key);
            this.indexStore.newIndex(newValue, e);
        }
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable[] values) {
        if (values.length == 1) {
            if (this.attributeType != null) {
                return this.indexStore.getRecords(this.convert(values[0]));
            }
            return new SingleResultSet(null);
        }
        MultiResultSet results = new MultiResultSet();
        if (this.attributeType != null) {
            HashSet<Comparable> convertedValues = new HashSet<Comparable>(values.length);
            for (Comparable value : values) {
                convertedValues.add(this.convert(value));
            }
            this.indexStore.getRecords(results, convertedValues);
        }
        return results;
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        if (this.attributeType != null) {
            return this.indexStore.getRecords(this.convert(value));
        }
        return new SingleResultSet(null);
    }

    @Override
    public Set<QueryableEntry> getSubRecordsBetween(Comparable from, Comparable to) {
        MultiResultSet results = new MultiResultSet();
        if (this.attributeType != null) {
            this.indexStore.getSubRecordsBetween(results, this.convert(from), this.convert(to));
        }
        return results;
    }

    @Override
    public Set<QueryableEntry> getSubRecords(ComparisonType comparisonType, Comparable searchedValue) {
        MultiResultSet results = new MultiResultSet();
        if (this.attributeType != null) {
            this.indexStore.getSubRecords(results, comparisonType, this.convert(searchedValue));
        }
        return results;
    }

    private Comparable convert(Comparable value) {
        if (this.attributeType == null) {
            return value;
        }
        return this.attributeType.getConverter().convert(value);
    }

    public ConcurrentMap<Data, Comparable> getRecordValues() {
        return this.recordValues;
    }

    @Override
    public String getAttributeName() {
        return this.attribute;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    public static final class NullObject
    implements Comparable {
        public int compareTo(Object o) {
            if (o == this || o instanceof NullObject) {
                return 0;
            }
            return -1;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }
    }
}

