/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.jpath.expression;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.jsp.PageContext;
import org.apache.taglibs.standard.lang.jpath.adapter.IterationContext;
import org.apache.taglibs.standard.lang.jpath.expression.EvaluationException;
import org.apache.taglibs.standard.lang.jpath.expression.Identifier;
import org.apache.taglibs.standard.lang.jpath.expression.Introspectable;
import org.apache.taglibs.standard.lang.jpath.expression.Parser;
import org.apache.taglibs.standard.lang.jpath.expression.SimpleNode;

public class MethodCall
extends SimpleNode
implements Introspectable {
    public MethodCall(int id) {
        super(id);
    }

    public MethodCall(Parser p, int id) {
        super(p, id);
    }

    public Object evaluate(PageContext pageContext, IterationContext icontext, int scope) throws EvaluationException {
        throw new EvaluationException(this, "A MethodCall must be called on another object");
    }

    public Object evaluate(PageContext pageContext, IterationContext icontext, Object parent) throws EvaluationException {
        Object result = null;
        String methodName = ((Identifier)this.jjtGetChild((int)0)).val;
        if (parent != null) {
            try {
                MethodDescriptor md = this.getFeatureDescriptor(parent.getClass(), methodName);
                Object[] args = new Object[this.jjtGetNumChildren() - 1];
                int i = 1;
                while (i < this.jjtGetNumChildren()) {
                    args[i - 1] = this.jjtGetChild(i).evaluate(pageContext, icontext);
                    ++i;
                }
                if (md != null) {
                    result = this.tempGetAttribute(parent, methodName, args);
                }
            }
            catch (IntrospectionException ie) {
                throw new EvaluationException(this, "Introspection Exception:" + ie.getMessage());
            }
            catch (NoSuchMethodException nsme) {
                throw new EvaluationException(this, "NoSuchMethodException:" + nsme.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new EvaluationException(this, "IllegalAccessException:" + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                throw new EvaluationException(this, "InvocationTargetException:" + ite.getMessage());
            }
        }
        return result;
    }

    private MethodDescriptor getFeatureDescriptor(Class c, String key) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(c);
        MethodDescriptor[] mda = beanInfo.getMethodDescriptors();
        int i = mda.length - 1;
        while (i >= 0) {
            MethodDescriptor md = mda[i];
            if (md.getName().equals(key)) {
                return md;
            }
            --i;
        }
        return null;
    }

    private Object getAttribute(MethodDescriptor md, Object o, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object result = null;
        Method m = md.getMethod();
        result = m.invoke(o, args);
        return result;
    }

    private Object tempGetAttribute(Object parent, String key, Object[] args) throws IntrospectionException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> c = parent.getClass();
        Method[] methods = c.getMethods();
        Method m = null;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(key)) {
                m = methods[i];
            }
            ++i;
        }
        m = this.getPublicMethod(c, m.getName(), m.getParameterTypes());
        Object result = m.invoke(parent, args);
        return result;
    }

    private Method getPublicMethod(Class c, String name, Class[] paramTypes) throws NoSuchMethodException {
        Method result = null;
        if ((c.getModifiers() & 1) == 0) {
            Class sc = c.getSuperclass();
            if (sc != null) {
                try {
                    result = this.getPublicMethod(sc, name, paramTypes);
                }
                catch (NoSuchMethodException nsme) {
                    // empty catch block
                }
            }
            if (result == null) {
                Class<?>[] interfaces = c.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    try {
                        result = this.getPublicMethod(interfaces[i], name, paramTypes);
                    }
                    catch (NoSuchMethodException nsme) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        } else {
            result = c.getMethod(name, paramTypes);
        }
        return result;
    }
}

