/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.filter.support;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultWriteFuture;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.support.SSLByteBufferPool;
import org.apache.mina.util.SessionLog;

public class SSLHandler {
    private final SSLFilter parent;
    private final SSLContext ctx;
    private final IoSession session;
    private final Queue<ScheduledWrite> scheduledWrites = new ConcurrentLinkedQueue<ScheduledWrite>();
    private SSLEngine sslEngine;
    private java.nio.ByteBuffer inNetBuffer;
    private java.nio.ByteBuffer outNetBuffer;
    private java.nio.ByteBuffer appBuffer;
    private final java.nio.ByteBuffer hsBB = java.nio.ByteBuffer.allocate(0);
    private SSLEngineResult.HandshakeStatus initialHandshakeStatus;
    private boolean initialHandshakeComplete;
    private boolean writingEncryptedData;

    public SSLHandler(SSLFilter parent, SSLContext sslc, IoSession session) throws SSLException {
        this.parent = parent;
        this.session = session;
        this.ctx = sslc;
        this.init();
    }

    public void init() throws SSLException {
        if (this.sslEngine != null) {
            return;
        }
        this.sslEngine = this.ctx.createSSLEngine();
        this.sslEngine.setUseClientMode(this.parent.isUseClientMode());
        if (this.parent.isWantClientAuth()) {
            this.sslEngine.setWantClientAuth(true);
        }
        if (this.parent.isNeedClientAuth()) {
            this.sslEngine.setNeedClientAuth(true);
        }
        if (this.parent.getEnabledCipherSuites() != null) {
            this.sslEngine.setEnabledCipherSuites(this.parent.getEnabledCipherSuites());
        }
        if (this.parent.getEnabledProtocols() != null) {
            this.sslEngine.setEnabledProtocols(this.parent.getEnabledProtocols());
        }
        this.sslEngine.beginHandshake();
        this.initialHandshakeStatus = this.sslEngine.getHandshakeStatus();
        this.initialHandshakeComplete = false;
        SSLByteBufferPool.initiate(this.sslEngine);
        this.appBuffer = SSLByteBufferPool.getApplicationBuffer();
        this.inNetBuffer = SSLByteBufferPool.getPacketBuffer();
        this.outNetBuffer = SSLByteBufferPool.getPacketBuffer();
        this.outNetBuffer.position(0);
        this.outNetBuffer.limit(0);
        this.writingEncryptedData = false;
    }

    public void destroy() {
        if (this.sslEngine == null) {
            return;
        }
        try {
            this.sslEngine.closeInbound();
        }
        catch (SSLException e) {
            SessionLog.debug((IoSession)this.session, (String)"Unexpected exception from SSLEngine.closeInbound().", (Throwable)e);
        }
        try {
            do {
                this.outNetBuffer.clear();
            } while (this.sslEngine.wrap(this.hsBB, this.outNetBuffer).bytesProduced() > 0);
        }
        catch (SSLException e) {
            SessionLog.debug((IoSession)this.session, (String)"Unexpected exception from SSLEngine.wrap().", (Throwable)e);
        }
        this.sslEngine.closeOutbound();
        this.sslEngine = null;
        SSLByteBufferPool.release(this.appBuffer);
        SSLByteBufferPool.release(this.inNetBuffer);
        SSLByteBufferPool.release(this.outNetBuffer);
        this.scheduledWrites.clear();
    }

    public SSLFilter getParent() {
        return this.parent;
    }

    public IoSession getSession() {
        return this.session;
    }

    public boolean isWritingEncryptedData() {
        return this.writingEncryptedData;
    }

    public boolean isInitialHandshakeComplete() {
        return this.initialHandshakeComplete;
    }

    public boolean isInboundDone() {
        return this.sslEngine == null || this.sslEngine.isInboundDone();
    }

    public boolean isOutboundDone() {
        return this.sslEngine == null || this.sslEngine.isOutboundDone();
    }

    public boolean needToCompleteInitialHandshake() {
        return this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && !this.isInboundDone();
    }

    public void scheduleWrite(IoFilter.NextFilter nextFilter, IoFilter.WriteRequest writeRequest) {
        this.scheduledWrites.add(new ScheduledWrite(nextFilter, writeRequest));
    }

    public void flushScheduledWrites() throws SSLException {
        ScheduledWrite scheduledWrite;
        while ((scheduledWrite = this.scheduledWrites.poll()) != null) {
            if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                SessionLog.debug((IoSession)this.session, (String)(" Flushing buffered write request: " + scheduledWrite.writeRequest));
            }
            this.parent.filterWrite(scheduledWrite.nextFilter, this.session, scheduledWrite.writeRequest);
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, java.nio.ByteBuffer buf) throws SSLException {
        if (buf.limit() > this.inNetBuffer.remaining()) {
            this.inNetBuffer = SSLByteBufferPool.expandBuffer(this.inNetBuffer, this.inNetBuffer.capacity() + buf.limit() * 2);
            this.appBuffer = SSLByteBufferPool.expandBuffer(this.appBuffer, this.inNetBuffer.capacity() * 2);
            this.appBuffer.position(0);
            this.appBuffer.limit(0);
            if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                SessionLog.debug((IoSession)this.session, (String)(" expanded inNetBuffer:" + this.inNetBuffer));
                SessionLog.debug((IoSession)this.session, (String)(" expanded appBuffer:" + this.appBuffer));
            }
        }
        this.inNetBuffer.put(buf);
        if (!this.initialHandshakeComplete) {
            this.handshake(nextFilter);
        } else {
            this.decrypt();
        }
        if (this.isInboundDone()) {
            buf.position(buf.position() - this.inNetBuffer.position());
            this.inNetBuffer.clear();
        }
    }

    public java.nio.ByteBuffer getAppBuffer() {
        return this.appBuffer;
    }

    public java.nio.ByteBuffer getOutNetBuffer() {
        return this.outNetBuffer;
    }

    public void encrypt(java.nio.ByteBuffer src) throws SSLException {
        if (!this.initialHandshakeComplete) {
            throw new IllegalStateException();
        }
        this.outNetBuffer.clear();
        while (src.hasRemaining()) {
            if (src.remaining() > (this.outNetBuffer.capacity() - this.outNetBuffer.position()) / 2) {
                this.outNetBuffer = SSLByteBufferPool.expandBuffer(this.outNetBuffer, src.capacity() * 2);
                if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                    SessionLog.debug((IoSession)this.session, (String)(" expanded outNetBuffer:" + this.outNetBuffer));
                }
            }
            SSLEngineResult result = this.sslEngine.wrap(src, this.outNetBuffer);
            if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                SessionLog.debug((IoSession)this.session, (String)(" Wrap res:" + result));
            }
            if (result.getStatus() == SSLEngineResult.Status.OK) {
                if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
                this.doTasks();
                continue;
            }
            throw new SSLException("SSLEngine error during encrypt: " + (Object)((Object)result.getStatus()) + " src: " + src + "outNetBuffer: " + this.outNetBuffer);
        }
        this.outNetBuffer.flip();
    }

    public boolean closeOutbound() throws SSLException {
        if (this.sslEngine == null || this.sslEngine.isOutboundDone()) {
            return false;
        }
        this.sslEngine.closeOutbound();
        this.outNetBuffer.clear();
        SSLEngineResult result = this.sslEngine.wrap(this.hsBB, this.outNetBuffer);
        if (result.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new SSLException("Improper close state: " + result);
        }
        this.outNetBuffer.flip();
        return true;
    }

    private void decrypt() throws SSLException {
        if (!this.initialHandshakeComplete) {
            throw new IllegalStateException();
        }
        if (this.appBuffer.hasRemaining()) {
            if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                SessionLog.debug((IoSession)this.session, (String)" Error: appBuffer not empty!");
            }
            throw new IllegalStateException();
        }
        this.unwrap();
    }

    private SSLEngineResult.Status checkStatus(SSLEngineResult.Status status) throws SSLException {
        if (status != SSLEngineResult.Status.OK && status != SSLEngineResult.Status.CLOSED && status != SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            throw new SSLException("SSLEngine error during decrypt: " + (Object)((Object)status) + " inNetBuffer: " + this.inNetBuffer + "appBuffer: " + this.appBuffer);
        }
        return status;
    }

    public void handshake(IoFilter.NextFilter nextFilter) throws SSLException {
        if (SessionLog.isDebugEnabled((IoSession)this.session)) {
            SessionLog.debug((IoSession)this.session, (String)" doHandshake()");
        }
        while (!this.initialHandshakeComplete) {
            if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                this.session.setAttribute(SSLFilter.SSL_SESSION, (Object)this.sslEngine.getSession());
                if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                    SSLSession sslSession = this.sslEngine.getSession();
                    SessionLog.debug((IoSession)this.session, (String)"  initialHandshakeStatus=FINISHED");
                    SessionLog.debug((IoSession)this.session, (String)("  sslSession CipherSuite used " + sslSession.getCipherSuite()));
                }
                this.initialHandshakeComplete = true;
                if (!this.session.containsAttribute(SSLFilter.USE_NOTIFICATION)) break;
                nextFilter.messageReceived(this.session, (Object)SSLFilter.SESSION_SECURED);
                break;
            }
            if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                    SessionLog.debug((IoSession)this.session, (String)"  initialHandshakeStatus=NEED_TASK");
                }
                this.initialHandshakeStatus = this.doTasks();
                continue;
            }
            if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                    SessionLog.debug((IoSession)this.session, (String)"  initialHandshakeStatus=NEED_UNWRAP");
                }
                SSLEngineResult.Status status = this.unwrapHandshake();
                if ((this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED || status != SSLEngineResult.Status.BUFFER_UNDERFLOW) && !this.isInboundDone()) continue;
                break;
            }
            if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                    SessionLog.debug((IoSession)this.session, (String)"  initialHandshakeStatus=NEED_WRAP");
                }
                if (this.outNetBuffer.hasRemaining()) {
                    if (!SessionLog.isDebugEnabled((IoSession)this.session)) break;
                    SessionLog.debug((IoSession)this.session, (String)"  Still data in out buffer!");
                    break;
                }
                this.outNetBuffer.clear();
                SSLEngineResult result = this.sslEngine.wrap(this.hsBB, this.outNetBuffer);
                if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                    SessionLog.debug((IoSession)this.session, (String)(" Wrap res:" + result));
                }
                this.outNetBuffer.flip();
                this.initialHandshakeStatus = result.getHandshakeStatus();
                this.writeNetBuffer(nextFilter);
                continue;
            }
            throw new IllegalStateException("Invalid Handshaking State" + (Object)((Object)this.initialHandshakeStatus));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteFuture writeNetBuffer(IoFilter.NextFilter nextFilter) throws SSLException {
        if (!this.getOutNetBuffer().hasRemaining()) {
            return DefaultWriteFuture.newNotWrittenFuture((IoSession)this.session);
        }
        this.writingEncryptedData = true;
        DefaultWriteFuture writeFuture = null;
        try {
            if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                SessionLog.debug((IoSession)this.session, (String)(" write outNetBuffer: " + this.getOutNetBuffer()));
            }
            ByteBuffer writeBuffer = SSLHandler.copy(this.getOutNetBuffer());
            if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                SessionLog.debug((IoSession)this.session, (String)(" session write: " + writeBuffer));
            }
            writeFuture = new DefaultWriteFuture(this.session);
            this.parent.filterWrite(nextFilter, this.session, new IoFilter.WriteRequest((Object)writeBuffer, (WriteFuture)writeFuture));
            while (this.needToCompleteInitialHandshake()) {
                try {
                    this.handshake(nextFilter);
                }
                catch (SSLException ssle) {
                    SSLHandshakeException newSSLE = new SSLHandshakeException("Initial SSL handshake failed.");
                    newSSLE.initCause(ssle);
                    throw newSSLE;
                }
                if (!this.getOutNetBuffer().hasRemaining()) continue;
                if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                    SessionLog.debug((IoSession)this.session, (String)(" write outNetBuffer2: " + this.getOutNetBuffer()));
                }
                ByteBuffer writeBuffer2 = SSLHandler.copy(this.getOutNetBuffer());
                writeFuture = new DefaultWriteFuture(this.session);
                this.parent.filterWrite(nextFilter, this.session, new IoFilter.WriteRequest((Object)writeBuffer2, (WriteFuture)writeFuture));
            }
        }
        finally {
            this.writingEncryptedData = false;
        }
        return writeFuture;
    }

    private SSLEngineResult.Status unwrap() throws SSLException {
        SSLEngineResult res;
        if (SessionLog.isDebugEnabled((IoSession)this.session)) {
            SessionLog.debug((IoSession)this.session, (String)" unwrap()");
        }
        this.appBuffer.clear();
        this.inNetBuffer.flip();
        do {
            if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                SessionLog.debug((IoSession)this.session, (String)("   inNetBuffer: " + this.inNetBuffer));
                SessionLog.debug((IoSession)this.session, (String)("   appBuffer: " + this.appBuffer));
            }
            res = this.sslEngine.unwrap(this.inNetBuffer, this.appBuffer);
            if (!SessionLog.isDebugEnabled((IoSession)this.session)) continue;
            SessionLog.debug((IoSession)this.session, (String)(" Unwrap res:" + res));
        } while (res.getStatus() == SSLEngineResult.Status.OK);
        this.inNetBuffer.compact();
        this.appBuffer.flip();
        return this.checkStatus(res.getStatus());
    }

    private SSLEngineResult.Status unwrapHandshake() throws SSLException {
        SSLEngineResult res;
        if (SessionLog.isDebugEnabled((IoSession)this.session)) {
            SessionLog.debug((IoSession)this.session, (String)" unwrapHandshake()");
        }
        this.appBuffer.clear();
        this.inNetBuffer.flip();
        do {
            if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                SessionLog.debug((IoSession)this.session, (String)("   inNetBuffer: " + this.inNetBuffer));
                SessionLog.debug((IoSession)this.session, (String)("   appBuffer: " + this.appBuffer));
            }
            res = this.sslEngine.unwrap(this.inNetBuffer, this.appBuffer);
            if (!SessionLog.isDebugEnabled((IoSession)this.session)) continue;
            SessionLog.debug((IoSession)this.session, (String)(" Unwrap res:" + res));
        } while (res.getStatus() == SSLEngineResult.Status.OK && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
        this.initialHandshakeStatus = res.getHandshakeStatus();
        if (this.initialHandshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED && this.appBuffer.position() == 0 && res.getStatus() == SSLEngineResult.Status.OK && this.inNetBuffer.hasRemaining()) {
            do {
                if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                    SessionLog.debug((IoSession)this.session, (String)"  extra handshake unwrap");
                    SessionLog.debug((IoSession)this.session, (String)("   inNetBuffer: " + this.inNetBuffer));
                    SessionLog.debug((IoSession)this.session, (String)("   appBuffer: " + this.appBuffer));
                }
                res = this.sslEngine.unwrap(this.inNetBuffer, this.appBuffer);
                if (!SessionLog.isDebugEnabled((IoSession)this.session)) continue;
                SessionLog.debug((IoSession)this.session, (String)(" Unwrap res:" + res));
            } while (res.getStatus() == SSLEngineResult.Status.OK);
        }
        this.inNetBuffer.compact();
        this.appBuffer.flip();
        return this.checkStatus(res.getStatus());
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        if (SessionLog.isDebugEnabled((IoSession)this.session)) {
            SessionLog.debug((IoSession)this.session, (String)"   doTasks()");
        }
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            if (SessionLog.isDebugEnabled((IoSession)this.session)) {
                SessionLog.debug((IoSession)this.session, (String)("    doTask: " + runnable));
            }
            runnable.run();
        }
        if (SessionLog.isDebugEnabled((IoSession)this.session)) {
            SessionLog.debug((IoSession)this.session, (String)("   doTasks(): " + (Object)((Object)this.sslEngine.getHandshakeStatus())));
        }
        return this.sslEngine.getHandshakeStatus();
    }

    public static ByteBuffer copy(java.nio.ByteBuffer src) {
        ByteBuffer copy = ByteBuffer.allocate((int)src.remaining());
        copy.put(src);
        copy.flip();
        return copy;
    }

    private static class ScheduledWrite {
        private final IoFilter.NextFilter nextFilter;
        private final IoFilter.WriteRequest writeRequest;

        ScheduledWrite(IoFilter.NextFilter nextFilter, IoFilter.WriteRequest writeRequest) {
            this.nextFilter = nextFilter;
            this.writeRequest = writeRequest;
        }
    }
}

